/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.versioning;

import java.io.Serializable;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.gradle.BuildInvocations;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.gradle.ProjectPublications;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.outcomes.ProjectOutcomes;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VersionDetails
implements Serializable {
    private final String providerVersion;

    public static VersionDetails from(String version) {
        return VersionDetails.from(GradleVersion.version((String)version));
    }

    public static VersionDetails from(GradleVersion version) {
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"4.8")) >= 0) {
            return new R48VersionDetails(version.getVersion());
        }
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"4.4")) >= 0) {
            return new R44VersionDetails(version.getVersion());
        }
        if (version.getBaseVersion().compareTo(GradleVersion.version((String)"3.5")) >= 0) {
            return new R35VersionDetails(version.getVersion());
        }
        if (version.compareTo(GradleVersion.version((String)"2.1")) >= 0) {
            return new R21VersionDetails(version.getVersion());
        }
        if (version.compareTo(GradleVersion.version((String)"1.12")) >= 0) {
            return new R112VersionDetails(version.getVersion());
        }
        if (version.compareTo(GradleVersion.version((String)"1.8")) >= 0) {
            return new R18VersionDetails(version.getVersion());
        }
        if (version.compareTo(GradleVersion.version((String)"1.6")) >= 0) {
            return new R16VersionDetails(version.getVersion());
        }
        return new R12VersionDetails(version.getVersion());
    }

    protected VersionDetails(String version) {
        this.providerVersion = version;
    }

    public String getVersion() {
        return this.providerVersion;
    }

    public boolean maySupportModel(Class<?> modelType) {
        return false;
    }

    public boolean supportsCancellation() {
        return false;
    }

    public boolean supportsEnvironmentVariablesCustomization() {
        return false;
    }

    public boolean supportsRunTasksBeforeExecutingAction() {
        return false;
    }

    public boolean supportsParameterizedToolingModels() {
        return false;
    }

    public boolean supportsRunPhasedActions() {
        return false;
    }

    private static class R48VersionDetails
    extends R44VersionDetails {
        public R48VersionDetails(String version) {
            super(version);
        }

        public boolean supportsRunPhasedActions() {
            return true;
        }
    }

    private static class R44VersionDetails
    extends R35VersionDetails {
        public R44VersionDetails(String version) {
            super(version);
        }

        public boolean supportsParameterizedToolingModels() {
            return true;
        }
    }

    private static class R35VersionDetails
    extends R21VersionDetails {
        public R35VersionDetails(String version) {
            super(version);
        }

        public boolean supportsEnvironmentVariablesCustomization() {
            return true;
        }

        public boolean supportsRunTasksBeforeExecutingAction() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R21VersionDetails
    extends VersionDetails {
        public R21VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return true;
        }

        @Override
        public boolean supportsCancellation() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R112VersionDetails
    extends VersionDetails {
        private R112VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R18VersionDetails
    extends VersionDetails {
        private R18VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return modelType != ProjectPublications.class && modelType != BuildInvocations.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R16VersionDetails
    extends VersionDetails {
        public R16VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return modelType != BuildInvocations.class && modelType != ProjectPublications.class && modelType != GradleBuild.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R12VersionDetails
    extends VersionDetails {
        public R12VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return modelType.equals(ProjectOutcomes.class) || modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(BuildEnvironment.class) || modelType.equals(GradleProject.class) || modelType.equals(Void.class);
        }
    }
}

