/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelReference<T> {
    public static final ModelReference<Object> ANY = ModelReference.of(ModelType.untyped());
    @Nullable
    private final ModelPath path;
    private final ModelType<T> type;
    @Nullable
    private final ModelPath scope;
    private final ModelNode.State state;
    @Nullable
    private final String description;
    private int hashCode;

    private ModelReference(@Nullable ModelPath path, ModelType<T> type, @Nullable ModelPath scope, @Nullable ModelNode.State state, @Nullable String description) {
        this.path = path;
        this.type = (ModelType)Preconditions.checkNotNull(type, (Object)"type");
        this.scope = scope;
        this.description = description;
        this.state = state != null ? state : ModelNode.State.GraphClosed;
    }

    public static ModelReference<Object> any() {
        return ANY;
    }

    public static <T> ModelReference<T> of(ModelPath path, ModelType<T> type, String description) {
        return (ModelReference)Cast.uncheckedCast(new ModelReference<T>(path, type, null, null, description));
    }

    public static <T> ModelReference<T> of(String path, ModelType<T> type, String description) {
        return ModelReference.of(ModelPath.path(path), type, description);
    }

    public static <T> ModelReference<T> of(ModelPath path, ModelType<T> type) {
        return (ModelReference)Cast.uncheckedCast(new ModelReference<T>(path, type, null, null, null));
    }

    public static <T> ModelReference<T> of(ModelPath path, ModelType<T> type, ModelNode.State state) {
        return (ModelReference)Cast.uncheckedCast(new ModelReference<T>(path, type, null, state, null));
    }

    public static <T> ModelReference<T> of(ModelPath path, Class<T> type) {
        return ModelReference.of(path, ModelType.of(type));
    }

    public static <T> ModelReference<T> of(String path, Class<T> type) {
        return ModelReference.of(ModelPath.path(path), ModelType.of(type));
    }

    public static <T> ModelReference<T> of(String path, ModelType<T> type) {
        return ModelReference.of(path == null ? null : ModelPath.path(path), type);
    }

    public static <T> ModelReference<T> of(Class<T> type) {
        return ModelReference.of((ModelPath)null, ModelType.of(type));
    }

    public static <T> ModelReference<T> of(ModelType<T> type) {
        return ModelReference.of((ModelPath)null, type);
    }

    public static ModelReference<Object> of(String path) {
        return ModelReference.of(ModelPath.path(path), ModelType.UNTYPED);
    }

    public static ModelReference<Object> of(ModelPath path) {
        return ModelReference.of(path, ModelType.UNTYPED);
    }

    public static ModelReference<Object> untyped(ModelPath path) {
        return ModelReference.untyped(path, null);
    }

    public static ModelReference<Object> untyped(ModelPath path, String description) {
        return ModelReference.of(path, ModelType.UNTYPED, description);
    }

    @Nullable
    public ModelPath getPath() {
        return this.path;
    }

    @Nullable
    public ModelPath getScope() {
        return this.scope;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public ModelType<T> getType() {
        return this.type;
    }

    public ModelNode.State getState() {
        return this.state;
    }

    public boolean isUntyped() {
        return this.type.equals(ModelType.UNTYPED);
    }

    public ModelReference<T> inScope(ModelPath scope) {
        if (scope.equals(this.scope)) {
            return this;
        }
        return (ModelReference)Cast.uncheckedCast(new ModelReference<T>(this.path, this.type, scope, this.state, this.description));
    }

    public ModelReference<T> withPath(ModelPath path) {
        return (ModelReference)Cast.uncheckedCast(new ModelReference<T>(path, this.type, this.scope, this.state, this.description));
    }

    public ModelReference<T> atState(ModelNode.State state) {
        if (state.equals((Object)this.state)) {
            return this;
        }
        return (ModelReference)Cast.uncheckedCast(new ModelReference<T>(this.path, this.type, this.scope, state, this.description));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelReference that = (ModelReference)o;
        return Objects.equal((Object)this.path, (Object)that.path) && Objects.equal((Object)this.scope, (Object)that.scope) && this.type.equals(that.type) && this.state.equals((Object)that.state) && Objects.equal((Object)this.description, (Object)that.description);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result != 0) {
            return result;
        }
        result = this.path == null ? 0 : this.path.hashCode();
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.state.hashCode();
        this.hashCode = result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        return result;
    }

    public String toString() {
        return "ModelReference{path=" + this.path + ", scope=" + this.scope + ", type=" + this.type + ", state=" + (Object)((Object)this.state) + '}';
    }
}

