/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.inspect.AbstractAnnotationDrivenModelRuleExtractor;
import org.gradle.model.internal.inspect.AbstractExtractedModelRule;
import org.gradle.model.internal.inspect.ExtractedModelRule;
import org.gradle.model.internal.inspect.MethodBackedModelAction;
import org.gradle.model.internal.inspect.MethodModelRuleApplicationContext;
import org.gradle.model.internal.inspect.MethodModelRuleExtractionContext;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.inspect.RuleApplicationScope;
import org.gradle.model.internal.inspect.RuleExtractorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutationModelRuleExtractor<T extends Annotation>
extends AbstractAnnotationDrivenModelRuleExtractor<T> {
    @Override
    @Nullable
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition, MethodModelRuleExtractionContext context) {
        this.validateIsVoidMethod(ruleDefinition, context);
        if (ruleDefinition.getReferences().isEmpty()) {
            context.add(ruleDefinition, "A method " + this.getDescription() + " must have at least one parameter");
        }
        if (context.hasProblems()) {
            return null;
        }
        RuleApplicationScope ruleApplicationScope = RuleApplicationScope.fromRuleDefinition(context, ruleDefinition, 0);
        return new ExtractedMutationRule<S>(this.getMutationType(), ruleDefinition, ruleApplicationScope);
    }

    protected abstract ModelActionRole getMutationType();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractedMutationRule<S>
    extends AbstractExtractedModelRule {
        private final ModelActionRole mutationType;
        private final RuleApplicationScope ruleApplicationScope;

        public ExtractedMutationRule(ModelActionRole mutationType, MethodRuleDefinition<?, S> ruleDefinition, RuleApplicationScope ruleApplicationScope) {
            super(ruleDefinition);
            this.mutationType = mutationType;
            this.ruleApplicationScope = ruleApplicationScope;
        }

        @Override
        public void apply(MethodModelRuleApplicationContext context, MutableModelNode target) {
            MethodRuleDefinition ruleDefinition = (MethodRuleDefinition)Cast.uncheckedCast(this.getRuleDefinition());
            MethodBackedModelAction ruleAction = new MethodBackedModelAction(ruleDefinition.getDescriptor(), ruleDefinition.getSubjectReference(), ruleDefinition.getTailReferences());
            RuleExtractorUtils.configureRuleAction(context, this.ruleApplicationScope, this.mutationType, ruleAction);
        }

        @Override
        public List<? extends Class<?>> getRuleDependencies() {
            return Collections.emptyList();
        }
    }
}

