/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.stubs;

import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElementTypeHolderEP;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubSerializer;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public abstract class IStubElementType<StubT extends StubElement, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static volatile boolean ourInitializedStubs;
    private static final Logger LOG;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (ourInitializedStubs) {
            LOG.error("All stub element types should be created before index initialization is complete.\nPlease add the class containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + Arrays.toString(StubElementTypeHolderEP.EP_NAME.getExtensions()));
        }
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    public String getId(@NotNull StubT stub) {
        if (stub == null) {
            IStubElementType.$$$reportNull$$$0(1);
        }
        assert (stub.getStubType() == this);
        StubElement parent2 = stub.getParentStub();
        int count2 = 0;
        for (StubElement child : parent2.getChildrenStubs()) {
            if (child.getStubType() == this) {
                ++count2;
            }
            if (child != stub) continue;
            return '#' + String.valueOf(count2);
        }
        throw new RuntimeException("Parent/child relations corrupted");
    }

    static {
        LOG = Logger.getInstance("#com.intellij.psi.stubs.IStubElementType");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/stubs/IStubElementType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getId";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

