/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Conditions;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.Functions;
import org.jetbrains.kotlin.com.intellij.util.PairFunction;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Producer;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.Convertor;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.HashSet;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.SingletonIterator;

public abstract class JBIterable<E>
implements Iterable<E> {
    final Object content;
    private static final JBIterable EMPTY = new Empty();

    protected JBIterable() {
        this.content = this;
    }

    JBIterable(@NotNull Object content) {
        if (content == null) {
            JBIterable.$$$reportNull$$$0(0);
        }
        this.content = content;
    }

    @NotNull
    public static <E> JBIterable<E> create(final @Nullable Producer<Iterator<E>> producer) {
        if (producer == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            @NotNull
            public Iterator<E> iterator() {
                Iterator iterator2 = (Iterator)producer.produce();
                if (iterator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$1", "iterator"));
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(2);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> from(@Nullable Iterable<? extends E> iterable) {
        if (iterable == null || iterable == EMPTY) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        if (iterable instanceof JBIterable) {
            JBIterable jBIterable = (JBIterable)iterable;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        Multi<? extends E> multi = new Multi<E>(iterable);
        if (multi == null) {
            JBIterable.$$$reportNull$$$0(6);
        }
        return multi;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first2, final @NotNull Function<? super E, ? extends E> generator) {
        if (generator == null) {
            JBIterable.$$$reportNull$$$0(7);
        }
        if (first2 == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(8);
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Function fun = Stateful.copy(generator);
                return new JBIterator<E>(){
                    E cur;
                    {
                        this.cur = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result2 = this.cur;
                        if (result2 == null) {
                            return this.stop();
                        }
                        this.cur = fun.fun(this.cur);
                        return result2;
                    }
                };
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(9);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> generate(final @Nullable E first1, final @Nullable E first2, final @NotNull PairFunction<? super E, ? super E, ? extends E> generator) {
        if (generator == null) {
            JBIterable.$$$reportNull$$$0(10);
        }
        if (first1 == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        JBIterable jBIterable = new JBIterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JBIterator<E>(){
                    E cur1;
                    E cur2;
                    {
                        this.cur1 = first1;
                        this.cur2 = first2;
                    }

                    @Override
                    public E nextImpl() {
                        Object result2 = this.cur1;
                        this.cur1 = this.cur2;
                        this.cur2 = generator.fun(result2, this.cur2);
                        if (result2 == null) {
                            return this.stop();
                        }
                        return result2;
                    }
                };
            }
        };
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> of(@Nullable E element) {
        if (element == null) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        Single single2 = new Single(element);
        if (single2 == null) {
            JBIterable.$$$reportNull$$$0(14);
        }
        return single2;
    }

    @NotNull
    public static <E> JBIterable<E> of(E ... elements) {
        JBIterable<E> jBIterable = elements == null || elements.length == 0 ? JBIterable.empty() : JBIterable.from(ContainerUtilRt.newArrayList(elements));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> empty() {
        JBIterable jBIterable = EMPTY;
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    public static <E> JBIterable<E> once(@NotNull Iterator<E> iterator2) {
        if (iterator2 == null) {
            JBIterable.$$$reportNull$$$0(17);
        }
        JBIterable jBIterable = JBIterable.of(Ref.create(iterator2)).intercept(new Function<Iterator<Ref<Iterator<E>>>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<Ref<Iterator<E>>> iterator2) {
                Ref ref = iterator2.next();
                Iterator result2 = ref.get();
                if (result2 == null) {
                    throw new UnsupportedOperationException();
                }
                ref.set(null);
                return result2;
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(18);
        }
        return jBIterable;
    }

    @NotNull
    public <T extends Iterator<E>> T typedIterator() {
        Iterator iterator2 = this.iterator();
        if (iterator2 == null) {
            JBIterable.$$$reportNull$$$0(19);
        }
        return (T)iterator2;
    }

    public final boolean processEach(@NotNull Processor<E> processor) {
        if (processor == null) {
            JBIterable.$$$reportNull$$$0(20);
        }
        return ContainerUtil.process(this, processor);
    }

    public final void consumeEach(@NotNull Consumer<E> consumer) {
        if (consumer == null) {
            JBIterable.$$$reportNull$$$0(21);
        }
        for (Object e : this) {
            consumer.consume(e);
        }
    }

    @NotNull
    public String toString() {
        String string = this.content == this ? JBIterable.class.getSimpleName() : String.valueOf(this.content);
        if (string == null) {
            JBIterable.$$$reportNull$$$0(22);
        }
        return string;
    }

    public final int size() {
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.size();
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return 1;
        }
        int count2 = 0;
        for (E ignored : itt) {
            ++count2;
        }
        return count2;
    }

    public final boolean contains(@Nullable Object element) {
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.contains(element);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return Comparing.equal(this.content, element);
        }
        for (E e : itt) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public final E get(int index2) {
        List<E> list2 = this.asRandomAccess();
        if (list2 != null) {
            return index2 >= list2.size() ? null : (E)list2.get(index2);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)(index2 == 0 ? this.content : null);
        }
        return this.skip(index2).first();
    }

    @Nullable
    private List<E> asRandomAccess() {
        return this.content instanceof RandomAccess ? (List)this.content : null;
    }

    @Nullable
    private Collection<E> asCollection() {
        return this.content instanceof Collection ? (Collection)this.content : null;
    }

    @Nullable
    private Iterable<E> asIterable() {
        return this.content instanceof Iterable ? (Iterable)this.content : null;
    }

    @NotNull
    public final JBIterable<E> repeat(int count2) {
        Function fun = Functions.identity();
        JBIterable jBIterable = JBIterable.generate(this, fun).take(count2).flatten(fun);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@Nullable Iterable<? extends E> other) {
        if (other == null || other == EMPTY) {
            JBIterable jBIterable = this;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(24);
            }
            return jBIterable;
        }
        if (this == EMPTY) {
            JBIterable<? extends E> jBIterable = JBIterable.from(other);
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(25);
            }
            return jBIterable;
        }
        Appended parent2 = this instanceof Appended ? (Appended)this : new Appended(this, null);
        Appended<? extends E> appended = new Appended<E>(other, parent2);
        if (appended == null) {
            JBIterable.$$$reportNull$$$0(26);
        }
        return appended;
    }

    @NotNull
    public final <T> JBIterable<E> append(@Nullable Iterable<T> other, @NotNull Function<? super T, ? extends Iterable<? extends E>> fun) {
        if (fun == null) {
            JBIterable.$$$reportNull$$$0(27);
        }
        JBIterable<Object> jBIterable = other == null ? this : (this == EMPTY ? JBIterable.from(other).flatten(fun) : this.append((T)JBIterable.from(other).flatten(fun)));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@NotNull E[] elements) {
        if (elements == null) {
            JBIterable.$$$reportNull$$$0(29);
        }
        JBIterable<Object> jBIterable = this == EMPTY ? JBIterable.of(elements) : this.append((E)JBIterable.of(elements));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(30);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> append(@Nullable E element) {
        JBIterable<JBIterable<E>> jBIterable = element == null ? this : (this == EMPTY ? JBIterable.of(element) : this.append(JBIterable.of(element)));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(31);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> filter(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(32);
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).filter(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(33);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> filter(@NotNull Class<T> type2) {
        if (type2 == null) {
            JBIterable.$$$reportNull$$$0(34);
        }
        JBIterable jBIterable = this.filter(Conditions.instanceOf(type2));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(35);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> take(final int count2) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).take(count2);
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(36);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> takeWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(37);
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).takeWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(38);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skip(final int count2) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).skip(count2);
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(39);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> skipWhile(final @NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(40);
        }
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).skipWhile(Stateful.copy(condition));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(41);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> map(final @NotNull Function<? super E, T> function2) {
        if (function2 == null) {
            JBIterable.$$$reportNull$$$0(42);
        }
        JBIterable<T> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<T>>(){

            @Override
            public Iterator<T> fun(Iterator<E> iterator2) {
                return JBIterator.from(iterator2).map(Stateful.copy(function2));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(43);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> transform(@NotNull Function<? super E, T> function2) {
        if (function2 == null) {
            JBIterable.$$$reportNull$$$0(44);
        }
        JBIterable<T> jBIterable = this.map(function2);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(45);
        }
        return jBIterable;
    }

    @NotNull
    public <T> JBIterable<T> flatten(@NotNull Function<? super E, ? extends Iterable<? extends T>> function2) {
        if (function2 == null) {
            JBIterable.$$$reportNull$$$0(46);
        }
        JBIterable<T> jBIterable = this.intercept(new FlattenFun(function2));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(47);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> unique() {
        JBIterable<E> jBIterable = this.unique(Function.ID);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(48);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> unique(final @NotNull Function<? super E, ?> identity) {
        if (identity == null) {
            JBIterable.$$$reportNull$$$0(49);
        }
        JBIterable<E> jBIterable = this.filter(new SCond<E>(){
            HashSet<Object> visited;

            @Override
            public boolean value(E e) {
                if (this.visited == null) {
                    this.visited = new HashSet();
                }
                return this.visited.add(identity.fun(e));
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(50);
        }
        return jBIterable;
    }

    @NotNull
    public final <T, X extends Iterator<E>> JBIterable<T> intercept(@NotNull Function<X, ? extends Iterator<T>> function2) {
        if (function2 == null) {
            JBIterable.$$$reportNull$$$0(51);
        }
        if (this == EMPTY) {
            JBIterable<E> jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(52);
            }
            return jBIterable;
        }
        if (this instanceof Intercepted) {
            Intercepted intercepted = new Intercepted(((Intercepted)this).original, Functions.compose(((Intercepted)this).interceptor, function2));
            if (intercepted == null) {
                JBIterable.$$$reportNull$$$0(53);
            }
            return intercepted;
        }
        Intercepted intercepted = new Intercepted(this, function2);
        if (intercepted == null) {
            JBIterable.$$$reportNull$$$0(54);
        }
        return intercepted;
    }

    @Nullable
    public final E first() {
        List<E> list2 = this.asRandomAccess();
        if (list2 != null) {
            return list2.isEmpty() ? null : (E)list2.get(0);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)this.content;
        }
        Iterator<E> iterator2 = itt.iterator();
        return iterator2.hasNext() ? (E)iterator2.next() : null;
    }

    @Nullable
    public final <T> T first(@NotNull Class<T> type2) {
        E first2;
        if (type2 == null) {
            JBIterable.$$$reportNull$$$0(55);
        }
        return (first2 = this.first()) != null && type2.isInstance(first2) ? (T)first2 : null;
    }

    @Nullable
    public final E first(@NotNull Condition<? super E> condition) {
        E first2;
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(56);
        }
        return (first2 = this.first()) != null && condition.value(first2) ? (E)first2 : null;
    }

    @Nullable
    public final E single() {
        List<E> list2 = this.asRandomAccess();
        if (list2 != null) {
            return list2.size() != 1 ? null : (E)list2.get(0);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)this.content;
        }
        Iterator<E> iterator2 = itt.iterator();
        E first2 = iterator2.hasNext() ? (E)iterator2.next() : null;
        return iterator2.hasNext() ? null : first2;
    }

    @Nullable
    public final E last() {
        List<E> list2 = this.asRandomAccess();
        if (list2 != null) {
            return list2.isEmpty() ? null : (E)list2.get(list2.size() - 1);
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return (E)this.content;
        }
        E cur = null;
        for (E e : itt) {
            cur = e;
        }
        return cur;
    }

    public final <T> T reduce(@Nullable T first2, @NotNull PairFunction<T, ? super E, T> function2) {
        if (function2 == null) {
            JBIterable.$$$reportNull$$$0(57);
        }
        T cur = first2;
        for (Object e : this) {
            cur = function2.fun(cur, e);
        }
        return cur;
    }

    public final E find(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(58);
        }
        return this.filter(condition).first();
    }

    public final int indexOf(@NotNull Condition<? super E> condition) {
        if (condition == null) {
            JBIterable.$$$reportNull$$$0(59);
        }
        int index2 = 0;
        for (Object e : this) {
            if (condition.value(e)) {
                return index2;
            }
            ++index2;
        }
        return -1;
    }

    @NotNull
    public final <T> JBIterable<T> filterMap(@NotNull Function<? super E, T> function2) {
        if (function2 == null) {
            JBIterable.$$$reportNull$$$0(60);
        }
        JBIterable<T> jBIterable = this.map(function2).filter(Conditions.notNull());
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(61);
        }
        return jBIterable;
    }

    @NotNull
    public final <T> JBIterable<T> flatMap(Function<? super E, ? extends Iterable<? extends T>> function2) {
        JBIterable<T> jBIterable = this.map(function2).flatten(Function.ID);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(62);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> join(final @Nullable E separator) {
        JBIterable jBIterable = this.intercept(new Function<Iterator<E>, Iterator<E>>(){

            @Override
            public Iterator<E> fun(Iterator<E> iterator2) {
                final Iterator original = iterator2;
                return new JBIterator<E>(){
                    boolean flag;

                    @Override
                    protected E nextImpl() {
                        if (!original.hasNext()) {
                            return this.stop();
                        }
                        this.flag = !this.flag;
                        return this.flag ? original.next() : separator;
                    }
                };
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(63);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<List<E>> split(final int size, final boolean strict) {
        JBIterable<List<E>> jBIterable = this.split(size).filterMap(new Function<JBIterable<E>, List<E>>(){

            @Override
            public List<E> fun(JBIterable<E> es) {
                List list2 = es.addAllTo(ContainerUtilRt.newArrayListWithCapacity(size));
                return strict && list2.size() < size ? null : list2;
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(64);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(size + " <= 0");
        }
        JBIterable<JBIterable<E>> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<JBIterable<E>>>(){

            @Override
            public Iterator<JBIterable<E>> fun(Iterator<E> iterator2) {
                final Iterator orig = iterator2;
                return new JBIterator<JBIterable<E>>(){
                    JBIterator<E> it;

                    @Override
                    protected JBIterable<E> nextImpl() {
                        JBIterable jBIterable;
                        while (this.it != null && this.it.advance()) {
                        }
                        this.it = null;
                        if (orig.hasNext()) {
                            this.it = JBIterator.wrap(orig);
                            jBIterable = JBIterable.once(this.it.take(size));
                        } else {
                            jBIterable = (JBIterable)this.stop();
                        }
                        return jBIterable;
                    }
                };
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(65);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<JBIterable<E>> split(final Split mode, final Condition<? super E> separator) {
        JBIterable<JBIterable<E>> jBIterable = this.intercept(new Function<Iterator<E>, Iterator<JBIterable<E>>>(){

            @Override
            public Iterator<JBIterable<E>> fun(Iterator<E> iterator2) {
                final Iterator orig = iterator2;
                final Condition condition = Stateful.copy(separator);
                return new JBIterator<JBIterable<E>>(){
                    JBIterator<E> it;
                    E stored;
                    int st;

                    @Override
                    protected JBIterable<E> nextImpl() {
                        while (this.it != null && this.it.advance()) {
                        }
                        this.it = null;
                        if (this.stored == null && !orig.hasNext()) {
                            if (this.st < 0 && mode != Split.BEFORE && mode != Split.GROUP) {
                                this.st = 1;
                                return JBIterable.empty();
                            }
                            return (JBIterable)this.stop();
                        }
                        if (this.st == -2 && mode == Split.AROUND) {
                            this.st = -1;
                            return JBIterable.empty();
                        }
                        Object tmp = this.stored;
                        this.stored = null;
                        this.it = JBIterator.wrap(orig);
                        return JBIterable.of(tmp).append(JBIterable.once(this.it.takeWhile(new Condition<E>(){

                            @Override
                            public boolean value(E e) {
                                boolean result2;
                                boolean sep = condition.value(e);
                                int st0 = st;
                                st = st0 < 0 && sep ? -2 : (st0 > 0 && !sep ? 2 : (sep ? -1 : 1));
                                switch (mode) {
                                    case AFTER: {
                                        result2 = st != -2 && (st != 1 || st0 == 0);
                                        break;
                                    }
                                    case BEFORE: {
                                        result2 = st != -2 && st != -1;
                                        break;
                                    }
                                    case AROUND: {
                                        result2 = st0 >= 0 && st > 0;
                                        break;
                                    }
                                    case GROUP: {
                                        result2 = st0 >= 0 && st > 0 || st0 <= 0 && st < 0;
                                        break;
                                    }
                                    case OFF: {
                                        result2 = st > 0;
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError(st);
                                    }
                                }
                                stored = !result2 && mode != Split.OFF ? e : null;
                                return result2;
                            }
                        })));
                    }
                };
            }
        });
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(66);
        }
        return jBIterable;
    }

    public final boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        Collection<E> col = this.asCollection();
        if (col != null) {
            return col.isEmpty();
        }
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            return false;
        }
        return !itt.iterator().hasNext();
    }

    public final boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @NotNull
    public final JBIterable<E> collect(@NotNull Collection<E> collection) {
        if (collection == null) {
            JBIterable.$$$reportNull$$$0(67);
        }
        JBIterable<E> jBIterable = JBIterable.from(this.addAllTo(collection));
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(68);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> collect() {
        if (this.content instanceof Collection) {
            JBIterable jBIterable = this;
            if (jBIterable == null) {
                JBIterable.$$$reportNull$$$0(69);
            }
            return jBIterable;
        }
        JBIterable jBIterable = this.collect(ContainerUtilRt.newArrayList());
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(70);
        }
        return jBIterable;
    }

    @NotNull
    public final JBIterable<E> sorted(@NotNull Comparator<E> comparator) {
        if (comparator == null) {
            JBIterable.$$$reportNull$$$0(71);
        }
        ArrayList list2 = this.addAllTo(ContainerUtilRt.newArrayList());
        Collections.sort(list2, comparator);
        JBIterable jBIterable = JBIterable.from(list2);
        if (jBIterable == null) {
            JBIterable.$$$reportNull$$$0(72);
        }
        return jBIterable;
    }

    @NotNull
    public final List<E> toList() {
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            List<Object> list2 = Collections.singletonList(this.content);
            if (list2 == null) {
                JBIterable.$$$reportNull$$$0(73);
            }
            return list2;
        }
        List<E> list3 = Collections.unmodifiableList(ContainerUtilRt.newArrayList(itt));
        if (list3 == null) {
            JBIterable.$$$reportNull$$$0(74);
        }
        return list3;
    }

    @NotNull
    public final Set<E> toSet() {
        Iterable<E> itt = this.asIterable();
        if (itt == null) {
            Set<Object> set = Collections.singleton(this.content);
            if (set == null) {
                JBIterable.$$$reportNull$$$0(75);
            }
            return set;
        }
        Set<E> set = Collections.unmodifiableSet(ContainerUtilRt.newLinkedHashSet(itt));
        if (set == null) {
            JBIterable.$$$reportNull$$$0(76);
        }
        return set;
    }

    @NotNull
    public final <K, V> Map<K, V> toMap(@NotNull Convertor<E, K> toKey, @NotNull Convertor<E, V> toValue) {
        if (toKey == null) {
            JBIterable.$$$reportNull$$$0(77);
        }
        if (toValue == null) {
            JBIterable.$$$reportNull$$$0(78);
        }
        LinkedHashMap<K, V> map2 = ContainerUtil.newLinkedHashMap();
        for (Object e : this) {
            map2.put(toKey.convert(e), toValue.convert(e));
        }
        Map map3 = map2.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(map2);
        if (map3 == null) {
            JBIterable.$$$reportNull$$$0(79);
        }
        return map3;
    }

    @NotNull
    public final <V> Map<E, V> toMap(Convertor<E, V> toValue) {
        Map map2 = this.toMap(Convertor.SELF, toValue);
        if (map2 == null) {
            JBIterable.$$$reportNull$$$0(80);
        }
        return map2;
    }

    @NotNull
    public final <K> Map<K, E> toReverseMap(Convertor<E, K> toKey) {
        Map map2 = this.toMap(toKey, Convertor.SELF);
        if (map2 == null) {
            JBIterable.$$$reportNull$$$0(81);
        }
        return map2;
    }

    @NotNull
    public final <C extends Collection<? super E>> C addAllTo(@NotNull C collection) {
        Collection<E> col;
        if (collection == null) {
            JBIterable.$$$reportNull$$$0(82);
        }
        if ((col = this.asCollection()) != null) {
            collection.addAll(col);
        } else {
            Iterable<E> itt = this.asIterable();
            if (itt == null) {
                collection.add((Object)this.content);
            } else {
                for (E item : itt) {
                    collection.add(item);
                }
            }
        }
        C c = collection;
        if (c == null) {
            JBIterable.$$$reportNull$$$0(83);
        }
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 32: 
            case 37: 
            case 40: 
            case 56: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 34: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: 
            case 44: 
            case 46: 
            case 51: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 67: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toKey";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generate";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "once";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "typedIterator";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "take";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "takeWhile";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "skip";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "skipWhile";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "transform";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 48: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "intercept";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMap";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "flatMap";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "toSet";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "toReverseMap";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "once";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processEach";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "consumeEach";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "takeWhile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "skipWhile";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "transform";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "intercept";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "filterMap";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "toMap";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addAllTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 54: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 79: 
            case 80: 
            case 81: 
            case 83: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class SCond<T>
    extends Stateful<SCond>
    implements Condition<T> {
    }

    public static abstract class Stateful<Self extends Stateful>
    implements Cloneable {
        @NotNull
        static <T> T copy(@NotNull T o) {
            if (o == null) {
                Stateful.$$$reportNull$$$0(0);
            }
            if (!(o instanceof Stateful)) {
                T t = o;
                if (t == null) {
                    Stateful.$$$reportNull$$$0(1);
                }
                return t;
            }
            Object object = ((Stateful)o).clone();
            if (object == null) {
                Stateful.$$$reportNull$$$0(2);
            }
            return (T)object;
        }

        public Self clone() {
            try {
                return (Self)((Stateful)super.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Stateful";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Stateful";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "copy";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Split {
        AFTER,
        BEFORE,
        AROUND,
        OFF,
        GROUP;

    }

    private static final class Intercepted<E, T, X>
    extends JBIterable<T> {
        final JBIterable<E> original;
        private final Function<X, ? extends Iterator<T>> interceptor;

        public Intercepted(@NotNull JBIterable<E> original, Function<X, ? extends Iterator<T>> interceptor) {
            if (original == null) {
                Intercepted.$$$reportNull$$$0(0);
            }
            this.original = original;
            this.interceptor = interceptor;
        }

        @Override
        public Iterator<T> iterator() {
            return this.interceptor.fun(this.original.iterator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Intercepted", "<init>"));
        }
    }

    private static final class FlattenFun<E, T>
    implements Function<Iterator<E>, Iterator<T>> {
        final Function<? super E, ? extends Iterable<? extends T>> function;

        FlattenFun(Function<? super E, ? extends Iterable<? extends T>> function2) {
            this.function = function2;
        }

        @Override
        public Iterator<T> fun(Iterator<E> iterator2) {
            return new FlattenIt(iterator2, Stateful.copy(this.function));
        }

        static final class FlattenIt<E, T>
        extends JBIterator<T> {
            final Iterator<E> original;
            final Function<? super E, ? extends Iterable<? extends T>> function;
            Iterator<? extends T> cur;

            public FlattenIt(Iterator<E> iterator2, Function<? super E, ? extends Iterable<? extends T>> fun) {
                this.original = iterator2;
                this.function = fun;
            }

            @Override
            public T nextImpl() {
                if (this.cur != null && this.cur.hasNext()) {
                    return this.cur.next();
                }
                if (!this.original.hasNext()) {
                    return (T)this.stop();
                }
                Iterable<T> next = this.function.fun(this.original.next());
                this.cur = next == null ? null : next.iterator();
                return (T)this.skip();
            }
        }
    }

    private static final class Appended<E>
    extends JBIterable<E> {
        final Iterable<? extends E> iterable;
        final Appended<E> parent;

        Appended(@NotNull Iterable<? extends E> iterable, @Nullable Appended<E> parent2) {
            if (iterable == null) {
                Appended.$$$reportNull$$$0(0);
            }
            this.iterable = iterable;
            this.parent = parent2;
        }

        @Override
        @NotNull
        public Iterator<E> iterator() {
            FlattenFun.FlattenIt flattenIt = new FlattenFun.FlattenIt(Arrays.asList(this.getIterables()).iterator(), Functions.identity());
            if (flattenIt == null) {
                Appended.$$$reportNull$$$0(1);
            }
            return flattenIt;
        }

        @NotNull
        Iterable[] getIterables() {
            int size = 0;
            Appended<E> p = this;
            while (p != null) {
                ++size;
                p = p.parent;
            }
            Iterable[] iterables = new Iterable[size];
            int i = 0;
            Appended<E> p2 = this;
            while (p2 != null) {
                iterables[size - ++i] = p2.iterable;
                p2 = p2.parent;
            }
            if (iterables == null) {
                Appended.$$$reportNull$$$0(2);
            }
            return iterables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iterable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Appended";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Appended";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIterables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Empty
    extends JBIterable {
        private Empty() {
        }

        @Override
        public Iterator iterator() {
            return EmptyIterator.getInstance();
        }
    }

    private static final class Single<E>
    extends JBIterable<E> {
        Single(@NotNull Object content) {
            if (content == null) {
                Single.$$$reportNull$$$0(0);
            }
            super(content);
        }

        @Override
        public Iterator<E> iterator() {
            return new SingletonIterator<Object>(this.content);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/kotlin/com/intellij/util/containers/JBIterable$Single", "<init>"));
        }
    }

    private static final class Multi<E>
    extends JBIterable<E> {
        Multi(Iterable<? extends E> iterable) {
            super(iterable);
        }

        @Override
        public Iterator<E> iterator() {
            return ((Iterable)this.content).iterator();
        }
    }
}

