/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.caching.internal.BuildCacheHasher;

public abstract class AbstractNormalizedFileSnapshot
implements NormalizedFileSnapshot {
    private final FileContentSnapshot snapshot;

    public AbstractNormalizedFileSnapshot(FileContentSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public final FileContentSnapshot getSnapshot() {
        return this.snapshot;
    }

    public final void appendToHasher(BuildCacheHasher hasher) {
        hasher.putString((CharSequence)this.getNormalizedPath());
        hasher.putHash(this.getSnapshot().getContentMd5());
    }

    public final int compareTo(NormalizedFileSnapshot o) {
        int result = this.compareNormalizedPathTo(o);
        if (result == 0) {
            result = this.getSnapshot().getContentMd5().compareTo(o.getSnapshot().getContentMd5());
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNormalizedFileSnapshot that = (AbstractNormalizedFileSnapshot)o;
        return this.snapshot.equals(that.snapshot) && this.hasSameNormalizedPathAs(that);
    }

    public final int hashCode() {
        int result = this.snapshot.hashCode();
        result = 31 * result + this.hashNormalizedPath();
        return result;
    }

    public final String toString() {
        return String.format("'%s' / %s", this.getNormalizedPath(), this.snapshot);
    }

    protected boolean hasSameNormalizedPathAs(AbstractNormalizedFileSnapshot other) {
        return this.getNormalizedPath().equals(other.getNormalizedPath());
    }

    protected int hashNormalizedPath() {
        return this.getNormalizedPath().hashCode();
    }

    protected int compareNormalizedPathTo(NormalizedFileSnapshot other) {
        return this.getNormalizedPath().compareTo(other.getNormalizedPath());
    }
}

