/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gradle.api.Action;
import org.gradle.api.internal.WithEstimatedSize;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.provider.ProviderInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredCollection<T, S extends T>
implements ElementSource<S> {
    protected final ElementSource<T> collection;
    protected final CollectionFilter<S> filter;

    public FilteredCollection(ElementSource<T> collection, CollectionFilter<S> filter) {
        this.collection = collection;
        this.filter = filter;
    }

    @Override
    public boolean add(S o) {
        throw new UnsupportedOperationException(String.format("Cannot add '%s' to '%s' as it is a filtered collection", o, this));
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(String.format("Cannot clear '%s' as it is a filtered collection", this));
    }

    protected boolean accept(Object o) {
        return this.filter.filter(o) != null;
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o) && this.accept(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.collection.containsAll(c)) {
            for (Object o : c) {
                if (this.accept(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean constantTimeIsEmpty() {
        return this.collection.constantTimeIsEmpty();
    }

    @Override
    public boolean isEmpty() {
        if (this.collection.isEmpty()) {
            return true;
        }
        for (T o : this.collection) {
            if (!this.accept(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int estimatedSize() {
        return this.collection.estimatedSize();
    }

    @Override
    public Iterator<S> iterator() {
        this.collection.realizePending(this.filter.getType());
        return new FilteringIterator<T, S>(this.collection, this.filter);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(String.format("Cannot remove '%s' from '%s' as it is a filtered collection", o, this));
    }

    @Override
    public int size() {
        int i = 0;
        for (T o : this.collection) {
            if (!this.accept(o)) continue;
            ++i;
        }
        return i;
    }

    @Override
    public Iterator<S> iteratorNoFlush() {
        return new FilteringIterator<T, S>(this.collection, this.filter);
    }

    @Override
    public void realizePending() {
        this.realizePending(this.filter.getType());
    }

    @Override
    public void realizePending(Class<?> type) {
        this.collection.realizePending(type);
    }

    @Override
    public void addPending(ProviderInternal<? extends S> provider) {
        this.collection.addPending(provider);
    }

    @Override
    public void removePending(ProviderInternal<? extends S> provider) {
        this.collection.removePending(provider);
    }

    @Override
    public void onRealize(Action<ProviderInternal<? extends S>> action) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringIterator<T, S extends T>
    implements Iterator<S>,
    WithEstimatedSize {
        private final CollectionFilter<S> filter;
        private final Iterator<T> iterator;
        private final int estimatedSize;
        private S next;

        FilteringIterator(ElementSource<T> collection, CollectionFilter<S> filter) {
            this.iterator = collection.iteratorNoFlush();
            this.filter = filter;
            this.estimatedSize = collection.estimatedSize();
            this.next = this.findNext();
        }

        private S findNext() {
            while (this.iterator.hasNext()) {
                T potentialNext = this.iterator.next();
                S filtered = this.filter.filter(potentialNext);
                if (filtered == null) continue;
                return filtered;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public S next() {
            if (this.next != null) {
                S thisNext = this.next;
                this.next = this.findNext();
                return thisNext;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal");
        }

        @Override
        public int estimatedSize() {
            return this.estimatedSize;
        }
    }
}

