/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.tasks.SnapshotTaskInputsBuildOperationType;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;

public class ResolveBuildCacheKeyExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(ResolveBuildCacheKeyExecuter.class);
    private static final String BUILD_OPERATION_NAME = "Snapshot task inputs";
    private final TaskExecuter delegate;
    private final BuildOperationExecutor buildOperationExecutor;
    private final boolean buildCacheDebugLogging;

    public ResolveBuildCacheKeyExecuter(TaskExecuter delegate, BuildOperationExecutor buildOperationExecutor, boolean buildCacheDebugLogging) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
        this.buildCacheDebugLogging = buildCacheDebugLogging;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        this.resolve(task, context);
        this.delegate.execute(task, state, context);
    }

    private void resolve(final TaskInternal task, final TaskExecutionContext context) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext buildOperationContext) {
                TaskOutputCachingBuildCacheKey cacheKey = ResolveBuildCacheKeyExecuter.this.doResolve(task, context);
                buildOperationContext.setResult((Object)new OperationResultImpl(cacheKey));
                context.setBuildCacheKey(cacheKey);
            }

            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName((String)("Snapshot task inputs for " + task.getIdentityPath())).name(ResolveBuildCacheKeyExecuter.BUILD_OPERATION_NAME).details((Object)OperationDetailsImpl.INSTANCE);
            }
        });
    }

    private TaskOutputCachingBuildCacheKey doResolve(TaskInternal task, TaskExecutionContext context) {
        TaskArtifactState taskState = context.getTaskArtifactState();
        TaskOutputCachingBuildCacheKey cacheKey = taskState.calculateCacheKey();
        if (context.getTaskProperties().hasDeclaredOutputs() && cacheKey.isValid()) {
            LogLevel logLevel = this.buildCacheDebugLogging ? LogLevel.LIFECYCLE : LogLevel.INFO;
            LOGGER.log(logLevel, "Build cache key for {} is {}", new Object[]{task, cacheKey.getHashCode()});
        }
        return cacheKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @VisibleForTesting
    static class OperationResultImpl
    implements SnapshotTaskInputsBuildOperationType.Result {
        @VisibleForTesting
        final TaskOutputCachingBuildCacheKey key;

        OperationResultImpl(TaskOutputCachingBuildCacheKey key) {
            this.key = key;
        }

        @Override
        @Nullable
        public Map<String, String> getInputHashes() {
            ImmutableSortedMap<String, HashCode> inputHashes = this.key.getInputs().getInputHashes();
            if (inputHashes == null || inputHashes.isEmpty()) {
                return null;
            }
            return Maps.transformValues(inputHashes, (Function)new Function<HashCode, String>(){

                public String apply(HashCode input) {
                    return input.toString();
                }
            });
        }

        @Override
        @Nullable
        public Set<String> getInputPropertiesLoadedByUnknownClassLoader() {
            ImmutableSortedSet<String> inputPropertiesLoadedByUnknownClassLoader = this.key.getInputs().getInputPropertiesLoadedByUnknownClassLoader();
            if (inputPropertiesLoadedByUnknownClassLoader == null || inputPropertiesLoadedByUnknownClassLoader.isEmpty()) {
                return null;
            }
            return inputPropertiesLoadedByUnknownClassLoader;
        }

        @Override
        @Nullable
        public String getClassLoaderHash() {
            HashCode classLoaderHash = this.key.getInputs().getClassLoaderHash();
            return classLoaderHash == null ? null : classLoaderHash.toString();
        }

        @Override
        @Nullable
        public List<String> getActionClassLoaderHashes() {
            List<HashCode> actionClassLoaderHashes = this.key.getInputs().getActionClassLoaderHashes();
            if (actionClassLoaderHashes == null || actionClassLoaderHashes.isEmpty()) {
                return null;
            }
            return Lists.transform(actionClassLoaderHashes, (Function)new Function<HashCode, String>(){

                public String apply(HashCode input) {
                    return input == null ? null : input.toString();
                }
            });
        }

        @Override
        @Nullable
        public List<String> getActionClassNames() {
            ImmutableList<String> actionClassNames = this.key.getInputs().getActionClassNames();
            if (actionClassNames == null || actionClassNames.isEmpty()) {
                return null;
            }
            return actionClassNames;
        }

        @Override
        @Nullable
        public List<String> getOutputPropertyNames() {
            ImmutableSortedSet<String> outputPropertyNames = this.key.getInputs().getOutputPropertyNames();
            if (outputPropertyNames == null || outputPropertyNames.isEmpty()) {
                return null;
            }
            return ImmutableSortedSet.copyOf(outputPropertyNames).asList();
        }

        @Override
        @Nullable
        public String getBuildCacheKey() {
            return this.key.isValid() ? this.key.getHashCode() : null;
        }
    }

    private static class OperationDetailsImpl
    implements SnapshotTaskInputsBuildOperationType.Details {
        private static final OperationDetailsImpl INSTANCE = new OperationDetailsImpl();

        private OperationDetailsImpl() {
        }
    }
}

