/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import java.util.Date;
import javax.mail.search.ComparisonTerm;

public abstract class DateTerm
extends ComparisonTerm {
    protected Date date;

    protected DateTerm(int comparison, Date date) {
        this.comparison = comparison;
        this.date = date;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public int getComparison() {
        return this.comparison;
    }

    protected boolean match(Date d) {
        switch (this.comparison) {
            case 1: {
                return d.before(this.date) || d.equals(this.date);
            }
            case 2: {
                return d.before(this.date);
            }
            case 3: {
                return d.equals(this.date);
            }
            case 4: {
                return !d.equals(this.date);
            }
            case 5: {
                return d.after(this.date);
            }
            case 6: {
                return d.after(this.date) || d.equals(this.date);
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DateTerm && ((DateTerm)other).date.equals(this.date) && super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.date.hashCode() + super.hashCode();
    }
}

