/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ldap;

import gnu.inet.ldap.AttributeValues;
import gnu.inet.ldap.BERDecoder;
import gnu.inet.ldap.BEREncoder;
import gnu.inet.ldap.BERException;
import gnu.inet.ldap.LDAPResult;
import gnu.inet.ldap.Modification;
import gnu.inet.ldap.ResultHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.naming.ldap.Control;

public class LDAPConnection {
    public static final int DEFAULT_PORT = 389;
    public static final int SCOPE_BASE_OBJECT = 0;
    public static final int SCOPE_SINGLE_LEVEL = 1;
    public static final int SCOPE_WHOLE_SUBTREE = 2;
    public static final int DEREF_NEVER = 0;
    public static final int DEREF_IN_SEARCHING = 1;
    public static final int DEREF_FINDING_BASE_OBJ = 2;
    public static final int DEREF_ALWAYS = 3;
    private static final int SUCCESS = 0;
    private static final int SASL_BIND_IN_PROGRESS = 14;
    private static final int MESSAGE = 48;
    private static final int BIND_REQUEST = 96;
    private static final int BIND_RESPONSE = 97;
    private static final int UNBIND_REQUEST = 98;
    private static final int SEARCH_REQUEST = 99;
    private static final int SEARCH_RESULT = 100;
    private static final int SEARCH_RESULT_DONE = 101;
    private static final int MODIFY_REQUEST = 102;
    private static final int MODIFY_RESPONSE = 103;
    private static final int ADD_REQUEST = 104;
    private static final int ADD_RESPONSE = 105;
    private static final int DELETE_REQUEST = 106;
    private static final int DELETE_RESPONSE = 107;
    private static final int MODIFY_DN_REQUEST = 108;
    private static final int MODIFY_DN_RESPONSE = 109;
    private static final int SEARCH_REFERENCE = 115;
    protected String host;
    protected int port;
    protected int version;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private int messageId;
    private Map asyncResponses;

    public LDAPConnection(String string) throws IOException {
        this(string, 389, 0, 0);
    }

    public LDAPConnection(String string, int n) throws IOException {
        this(string, n, 0, 0);
    }

    public LDAPConnection(String string, int n, int n2, int n3) throws IOException {
        this.host = string;
        if (n < 0) {
            n = 389;
        }
        this.port = n;
        this.messageId = 0;
        this.asyncResponses = new HashMap();
        this.version = 3;
        this.socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        if (n2 > 0) {
            this.socket.connect(inetSocketAddress, n2);
        } else {
            this.socket.connect(inetSocketAddress);
        }
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
    }

    public void setVersion(int n) {
        if (n < 2 || n > 3) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        this.version = n;
    }

    public LDAPResult bind(String string, String string2, byte[] byArray, Control[] controlArray) throws IOException {
        BEREncoder bEREncoder;
        int n = this.messageId++;
        boolean bl = this.version == 3;
        BEREncoder bEREncoder2 = new BEREncoder(bl);
        if (string2 == null) {
            bEREncoder2.append(this.version);
            bEREncoder2.append(string);
            if (byArray != null) {
                bEREncoder2.append(byArray);
            }
        } else {
            bEREncoder2.append(this.version);
            bEREncoder2.append(string);
            bEREncoder = new BEREncoder(bl);
            bEREncoder.append(string2);
            if (byArray != null) {
                bEREncoder.append(byArray);
            }
            bEREncoder2.append(bEREncoder.toByteArray(), 16);
        }
        bEREncoder = new BEREncoder(bl);
        if (controlArray != null) {
            for (int i = 0; i < controlArray.length; ++i) {
                bEREncoder.append(this.controlSequence(controlArray[i], bl), 16);
            }
        }
        bEREncoder2.append(bEREncoder.toByteArray(), 128);
        this.write(n, 96, bEREncoder2.toByteArray());
        BERDecoder bERDecoder = this.read(n);
        BERDecoder bERDecoder2 = bERDecoder.parseSequence(97);
        LDAPResult lDAPResult = this.parseResult(bERDecoder2);
        if (bERDecoder2.available()) {
            byte[] byArray2 = bERDecoder2.parseOctetString();
        }
        return lDAPResult;
    }

    public void unbind() throws IOException {
        int n = this.messageId++;
        boolean bl = this.version == 3;
        BEREncoder bEREncoder = new BEREncoder(bl);
        bEREncoder.appendNull();
        this.write(n, 98, bEREncoder.toByteArray());
        this.socket.close();
    }

    public LDAPResult search(String string, int n, int n2, int n3, int n4, boolean bl, String string2, String[] stringArray, Control[] controlArray, ResultHandler resultHandler) throws IOException {
        int n5;
        if (string2 == null || string2.length() == 0) {
            string2 = "(objectClass=*)";
        }
        int n6 = this.messageId++;
        boolean bl2 = this.version == 3;
        BEREncoder bEREncoder = new BEREncoder(bl2);
        bEREncoder.append(string);
        bEREncoder.append(n, 10);
        bEREncoder.append(n2, 10);
        bEREncoder.append(n3);
        bEREncoder.append(n4);
        bEREncoder.append(bl);
        bEREncoder.appendFilter(string2);
        BEREncoder bEREncoder2 = new BEREncoder(bl2);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                bEREncoder2.append(stringArray[i]);
            }
        }
        bEREncoder.append(bEREncoder2.toByteArray(), 16);
        BEREncoder bEREncoder3 = new BEREncoder(bl2);
        if (controlArray != null) {
            for (int i = 0; i < controlArray.length; ++i) {
                bEREncoder3.append(this.controlSequence(controlArray[i], bl2), 16);
            }
        }
        bEREncoder.append(bEREncoder3.toByteArray(), 16);
        this.write(n6, 99, bEREncoder.toByteArray());
        block13: while (true) {
            BERDecoder bERDecoder = this.read(n6);
            n5 = bERDecoder.parseType();
            switch (n5) {
                case 100: {
                    Object object;
                    Object object2;
                    BERDecoder bERDecoder2 = bERDecoder.parseSequence(n5);
                    String string3 = bERDecoder2.parseString();
                    BERDecoder bERDecoder3 = bERDecoder2.parseSequence(48);
                    TreeMap treeMap = new TreeMap();
                    while (bERDecoder3.available()) {
                        object2 = bERDecoder3.parseSequence(48);
                        object = ((BERDecoder)object2).parseString();
                        BERDecoder bERDecoder4 = ((BERDecoder)object2).parseSet(49);
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        while (bERDecoder4.available()) {
                            int n7 = bERDecoder4.parseType();
                            switch (n7) {
                                case 1: {
                                    arrayList.add(bERDecoder4.parseBoolean());
                                    break;
                                }
                                case 2: 
                                case 10: {
                                    arrayList.add(new Integer(bERDecoder4.parseInt()));
                                    break;
                                }
                                case 12: {
                                    arrayList.add(bERDecoder4.parseString());
                                    break;
                                }
                                case 4: {
                                    arrayList.add(bERDecoder4.parseOctetString());
                                }
                            }
                        }
                        treeMap.put(object, arrayList);
                    }
                    resultHandler.searchResultEntry(string3, treeMap);
                    continue block13;
                }
                case 115: {
                    Object object2 = new ArrayList<String>();
                    Object object = bERDecoder.parseSequence(n5);
                    while (((BERDecoder)object).available()) {
                        object2.add(((BERDecoder)object).parseString());
                    }
                    resultHandler.searchResultReference((List)object2);
                    continue block13;
                }
                case 101: {
                    return this.parseResult(bERDecoder.parseSequence(n5));
                }
            }
            break;
        }
        throw new ProtocolException("Unexpected response: " + n5);
    }

    public LDAPResult modify(String string, Modification[] modificationArray) throws IOException {
        Object object;
        Object object2;
        int n = this.messageId++;
        boolean bl = this.version == 3;
        BEREncoder bEREncoder = new BEREncoder(bl);
        bEREncoder.append(string);
        BEREncoder bEREncoder2 = new BEREncoder(bl);
        for (int i = 0; i < modificationArray.length; ++i) {
            object2 = new BEREncoder(bl);
            ((BEREncoder)object2).append(modificationArray[i].operation);
            object = new BEREncoder(bl);
            ((BEREncoder)object).append(modificationArray[i].type);
            BEREncoder bEREncoder3 = new BEREncoder(bl);
            this.appendValues(bEREncoder3, modificationArray[i].values);
            ((BEREncoder)object).append(bEREncoder3.toByteArray(), 17);
            ((BEREncoder)object2).append(((BEREncoder)object).toByteArray(), 16);
            bEREncoder2.append(((BEREncoder)object2).toByteArray(), 16);
        }
        bEREncoder.append(bEREncoder2.toByteArray(), 16);
        this.write(n, 102, bEREncoder.toByteArray());
        BERDecoder bERDecoder = this.read(n);
        object2 = bERDecoder.parseSequence(103);
        object = this.parseResult((BERDecoder)object2);
        return object;
    }

    public LDAPResult add(String string, AttributeValues[] attributeValuesArray) throws IOException {
        Object object;
        Object object2;
        int n = this.messageId++;
        boolean bl = this.version == 3;
        BEREncoder bEREncoder = new BEREncoder(bl);
        bEREncoder.append(string);
        BEREncoder bEREncoder2 = new BEREncoder(bl);
        for (int i = 0; i < attributeValuesArray.length; ++i) {
            object2 = new BEREncoder(bl);
            ((BEREncoder)object2).append(attributeValuesArray[i].type);
            object = new BEREncoder(bl);
            this.appendValues((BEREncoder)object, attributeValuesArray[i].values);
            ((BEREncoder)object2).append(((BEREncoder)object).toByteArray(), 17);
            bEREncoder2.append(((BEREncoder)object2).toByteArray(), 16);
        }
        bEREncoder.append(bEREncoder2.toByteArray(), 16);
        this.write(n, 104, bEREncoder.toByteArray());
        BERDecoder bERDecoder = this.read(n);
        object2 = bERDecoder.parseSequence(105);
        object = this.parseResult((BERDecoder)object2);
        return object;
    }

    public LDAPResult delete(String string) throws IOException {
        int n = this.messageId++;
        boolean bl = this.version == 3;
        BEREncoder bEREncoder = new BEREncoder(bl);
        bEREncoder.append(string);
        this.write(n, 106, bEREncoder.toByteArray());
        BERDecoder bERDecoder = this.read(n);
        int n2 = bERDecoder.parseType();
        if (n2 != 107) {
            throw new ProtocolException("Unexpected response type: " + n2);
        }
        BERDecoder bERDecoder2 = bERDecoder.parseSequence();
        LDAPResult lDAPResult = this.parseResult(bERDecoder2);
        return lDAPResult;
    }

    public LDAPResult modifyDN(String string, String string2, boolean bl, String string3) throws IOException {
        int n = this.messageId++;
        boolean bl2 = this.version == 3;
        BEREncoder bEREncoder = new BEREncoder(bl2);
        bEREncoder.append(string);
        bEREncoder.append(string2);
        bEREncoder.append(bl);
        if (string3 != null) {
            bEREncoder.append(string3);
        }
        this.write(n, 108, bEREncoder.toByteArray());
        BERDecoder bERDecoder = this.read(n);
        BERDecoder bERDecoder2 = bERDecoder.parseSequence(109);
        LDAPResult lDAPResult = this.parseResult(bERDecoder2);
        return lDAPResult;
    }

    void appendValues(BEREncoder bEREncoder, Set set) throws BERException {
        if (set != null) {
            for (Object e : set) {
                if (e == null) {
                    bEREncoder.appendNull();
                    continue;
                }
                if (e instanceof String) {
                    bEREncoder.append((String)e);
                    continue;
                }
                if (e instanceof Integer) {
                    bEREncoder.append((Integer)e);
                    continue;
                }
                if (e instanceof Boolean) {
                    bEREncoder.append((Boolean)e);
                    continue;
                }
                if (e instanceof byte[]) {
                    bEREncoder.append((byte[])e);
                    continue;
                }
                throw new ClassCastException(e.getClass().getName());
            }
        }
    }

    byte[] controlSequence(Control control, boolean bl) throws IOException {
        BEREncoder bEREncoder = new BEREncoder(bl);
        bEREncoder.append(control.getID());
        if (control.isCritical()) {
            bEREncoder.append(true);
        }
        return bEREncoder.toByteArray();
    }

    LDAPResult parseResult(BERDecoder bERDecoder) throws IOException {
        int n;
        int n2 = bERDecoder.parseInt();
        String string = bERDecoder.parseString();
        String string2 = bERDecoder.parseString();
        String[] stringArray = null;
        if (bERDecoder.available() && (n = bERDecoder.parseType()) == 16) {
            ArrayList<String> arrayList = new ArrayList<String>();
            BERDecoder bERDecoder2 = bERDecoder.parseSequence();
            n = bERDecoder2.parseType();
            while (n != -1) {
                arrayList.add(bERDecoder2.parseString());
            }
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return new LDAPResult(n2, string, string2, stringArray);
    }

    void write(int n, int n2, byte[] byArray) throws IOException {
        boolean bl = this.version == 3;
        BEREncoder bEREncoder = new BEREncoder(bl);
        bEREncoder.append(n);
        bEREncoder.append(byArray, n2);
        BEREncoder bEREncoder2 = new BEREncoder(bl);
        bEREncoder2.append(bEREncoder.toByteArray(), 48);
        byte[] byArray2 = bEREncoder2.toByteArray();
        this.out.write(byArray2);
        this.out.flush();
    }

    BERDecoder read(int n) throws IOException {
        Integer n2 = new Integer(n);
        List<BERDecoder> list = (ArrayList<BERDecoder>)this.asyncResponses.get(n2);
        if (list != null) {
            BERDecoder bERDecoder = (BERDecoder)list.remove(0);
            if (list.size() == 0) {
                this.asyncResponses.remove(n2);
            }
            return bERDecoder;
        }
        while (true) {
            byte[] byArray = this.readMessage();
            boolean bl = this.version == 3;
            BERDecoder bERDecoder = new BERDecoder(byArray, bl);
            int n3 = (bERDecoder = bERDecoder.parseSequence(48)).parseInt();
            if (n3 == n) {
                return bERDecoder;
            }
            n2 = new Integer(n3);
            list = (List)this.asyncResponses.get(n2);
            if (list == null) {
                list = new ArrayList<BERDecoder>();
                this.asyncResponses.put(n2, list);
            }
            list.add(bERDecoder);
        }
    }

    byte[] readMessage() throws IOException {
        int n;
        byte[] byArray = new byte[6];
        int n2 = 0;
        byArray[n2++] = (byte)this.readByte();
        int n3 = this.readByte();
        byArray[n2++] = (byte)n3;
        if ((n3 & 0x80) != 0) {
            int n4 = n3 - 128;
            if (n4 > 4) {
                throw new BERException("Data too long: " + n4);
            }
            n3 = 0;
            for (n = 0; n < n4; ++n) {
                int n5 = this.readByte();
                byArray[n2++] = (byte)n5;
                n3 = (n3 << 8) + n5;
            }
        }
        byte[] byArray2 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        if (n3 == 0) {
            return byArray2;
        }
        byArray = null;
        do {
            if ((n = this.in.read(byArray2, n2, n3)) == -1) {
                throw new IOException("EOF");
            }
            n2 += n;
        } while ((n3 -= n) > 0);
        return byArray2;
    }

    int readByte() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new IOException("EOF");
        }
        return n & 0xFF;
    }
}

