/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DNSDatagramSocketFactory;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.Header;
import com.sun.jndi.dns.Packet;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import com.sun.jndi.dns.Tcp;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.naming.ConfigurationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.ServiceUnavailableException;
import sun.security.jca.JCAUtil;

public class DnsClient {
    private static final int IDENT_OFFSET = 0;
    private static final int FLAGS_OFFSET = 2;
    private static final int NUMQ_OFFSET = 4;
    private static final int NUMANS_OFFSET = 6;
    private static final int NUMAUTH_OFFSET = 8;
    private static final int NUMADD_OFFSET = 10;
    private static final int DNS_HDR_SIZE = 12;
    private static final int NO_ERROR = 0;
    private static final int FORMAT_ERROR = 1;
    private static final int SERVER_FAILURE = 2;
    private static final int NAME_ERROR = 3;
    private static final int NOT_IMPL = 4;
    private static final int REFUSED = 5;
    private static final String[] rcodeDescription = new String[]{"No error", "DNS format error", "DNS server failure", "DNS name not found", "DNS operation not supported", "DNS service refused"};
    private static final int DEFAULT_PORT = 53;
    private static final int TRANSACTION_ID_BOUND = 65536;
    private static final SecureRandom random = JCAUtil.getSecureRandom();
    private InetAddress[] servers;
    private int[] serverPorts;
    private int timeout;
    private int retries;
    private final Object udpSocketLock = new Object();
    private static final DNSDatagramSocketFactory factory = new DNSDatagramSocketFactory(random);
    private Map<Integer, ResourceRecord> reqs;
    private Map<Integer, byte[]> resps;
    private Object queuesLock = new Object();
    private static final boolean debug = false;

    public DnsClient(String[] servers, int timeout, int retries) throws NamingException {
        this.timeout = timeout;
        this.retries = retries;
        this.servers = new InetAddress[servers.length];
        this.serverPorts = new int[servers.length];
        for (int i = 0; i < servers.length; ++i) {
            int colon = servers[i].indexOf(58, servers[i].indexOf(93) + 1);
            this.serverPorts[i] = colon < 0 ? 53 : Integer.parseInt(servers[i].substring(colon + 1));
            String server = colon < 0 ? servers[i] : servers[i].substring(0, colon);
            try {
                this.servers[i] = InetAddress.getByName(server);
                continue;
            }
            catch (UnknownHostException e) {
                ConfigurationException ne = new ConfigurationException("Unknown DNS server: " + server);
                ne.setRootCause(e);
                throw ne;
            }
        }
        this.reqs = Collections.synchronizedMap(new HashMap());
        this.resps = Collections.synchronizedMap(new HashMap());
    }

    DatagramSocket getDatagramSocket() throws NamingException {
        try {
            return factory.open();
        }
        catch (SocketException e) {
            ConfigurationException ne = new ConfigurationException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected void finalize() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.queuesLock;
        synchronized (object) {
            this.reqs.clear();
            this.resps.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords query(DnsName fqdn, int qclass, int qtype, boolean recursion, boolean auth) throws NamingException {
        Packet pkt;
        int xid;
        ResourceRecord collision;
        do {
            xid = random.nextInt(65536);
            pkt = this.makeQueryPacket(fqdn, xid, qclass, qtype, recursion);
            Map<Integer, ResourceRecord> map = this.reqs;
            synchronized (map) {
                collision = this.reqs.put(xid, new ResourceRecord(pkt.getData(), pkt.length(), 12, true, false));
                if (collision != null) {
                    this.reqs.put(xid, collision);
                }
            }
        } while (collision != null);
        Exception caughtException = null;
        boolean[] doNotRetry = new boolean[this.servers.length];
        try {
            for (int retry = 0; retry < this.retries; ++retry) {
                for (int i = 0; i < this.servers.length; ++i) {
                    if (doNotRetry[i]) continue;
                    try {
                        byte[] msg = null;
                        msg = this.doUdpQuery(pkt, this.servers[i], this.serverPorts[i], retry, xid);
                        if (msg == null) {
                            if (this.resps.size() > 0) {
                                msg = this.lookupResponse(xid);
                            }
                            if (msg == null) continue;
                        }
                        Header hdr2 = new Header(msg, msg.length);
                        if (auth && !hdr2.authoritative) {
                            caughtException = new NameNotFoundException("DNS response not authoritative");
                            doNotRetry[i] = true;
                            continue;
                        }
                        if (hdr2.truncated) {
                            for (int j = 0; j < this.servers.length; ++j) {
                                int ij = (i + j) % this.servers.length;
                                if (doNotRetry[ij]) continue;
                                try {
                                    byte[] msg2;
                                    try (Tcp tcp = new Tcp(this.servers[ij], this.serverPorts[ij]);){
                                        msg2 = this.doTcpQuery(tcp, pkt);
                                    }
                                    Header hdr22 = new Header(msg2, msg2.length);
                                    if (hdr22.query) {
                                        throw new CommunicationException("DNS error: expecting response");
                                    }
                                    this.checkResponseCode(hdr22);
                                    if (!auth || hdr22.authoritative) {
                                        hdr2 = hdr22;
                                        msg = msg2;
                                        break;
                                    }
                                    doNotRetry[ij] = true;
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        ResourceRecords resourceRecords = new ResourceRecords(msg, msg.length, hdr2, false);
                        return resourceRecords;
                    }
                    catch (IOException e) {
                        if (caughtException == null) {
                            caughtException = e;
                        }
                        if (!e.getClass().getName().equals("java.net.PortUnreachableException")) continue;
                        doNotRetry[i] = true;
                        continue;
                    }
                    catch (NameNotFoundException e) {
                        throw e;
                    }
                    catch (CommunicationException e) {
                        if (caughtException != null) continue;
                        caughtException = e;
                        continue;
                    }
                    catch (NamingException e) {
                        if (caughtException == null) {
                            caughtException = e;
                        }
                        doNotRetry[i] = true;
                    }
                    {
                        continue;
                    }
                }
            }
        }
        finally {
            this.reqs.remove(xid);
        }
        if (caughtException instanceof NamingException) {
            throw (NamingException)caughtException;
        }
        CommunicationException ne = new CommunicationException("DNS error");
        ne.setRootCause(caughtException);
        throw ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(DnsName zone, int qclass, boolean recursion) throws NamingException {
        int xid = random.nextInt(65536);
        Packet pkt = this.makeQueryPacket(zone, xid, qclass, 252, recursion);
        Exception caughtException = null;
        for (int i = 0; i < this.servers.length; ++i) {
            ResourceRecords resourceRecords;
            Tcp tcp = new Tcp(this.servers[i], this.serverPorts[i]);
            try {
                byte[] msg = this.doTcpQuery(tcp, pkt);
                Header hdr2 = new Header(msg, msg.length);
                this.checkResponseCode(hdr2);
                ResourceRecords rrs = new ResourceRecords(msg, msg.length, hdr2, true);
                if (rrs.getFirstAnsType() != 6) {
                    throw new CommunicationException("DNS error: zone xfer doesn't begin with SOA");
                }
                if (rrs.answer.size() == 1 || rrs.getLastAnsType() != 6) {
                    do {
                        if ((msg = this.continueTcpQuery(tcp)) == null) {
                            throw new CommunicationException("DNS error: incomplete zone transfer");
                        }
                        hdr2 = new Header(msg, msg.length);
                        this.checkResponseCode(hdr2);
                        rrs.add(msg, msg.length, hdr2);
                    } while (rrs.getLastAnsType() != 6);
                }
                rrs.answer.removeElementAt(rrs.answer.size() - 1);
                resourceRecords = rrs;
            }
            catch (Throwable throwable) {
                try {
                    tcp.close();
                    throw throwable;
                }
                catch (IOException e) {
                    caughtException = e;
                    continue;
                }
                catch (NameNotFoundException e) {
                    throw e;
                }
                catch (NamingException e) {
                    caughtException = e;
                }
            }
            tcp.close();
            return resourceRecords;
        }
        if (caughtException instanceof NamingException) {
            throw (NamingException)caughtException;
        }
        CommunicationException ne = new CommunicationException("DNS error during zone transfer");
        ne.setRootCause(caughtException);
        throw ne;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] doUdpQuery(Packet pkt, InetAddress server, int port, int retry, int xid) throws IOException, NamingException {
        int minTimeout = 50;
        Object object = this.udpSocketLock;
        synchronized (object) {
            try (DatagramSocket udpSocket = this.getDatagramSocket();){
                DatagramPacket opkt = new DatagramPacket(pkt.getData(), pkt.length(), server, port);
                DatagramPacket ipkt = new DatagramPacket(new byte[8000], 8000);
                udpSocket.connect(server, port);
                int pktTimeout = this.timeout * (1 << retry);
                try {
                    long start;
                    long end;
                    udpSocket.send(opkt);
                    int timeoutLeft = pktTimeout;
                    boolean cnt = false;
                    do {
                        udpSocket.setSoTimeout(timeoutLeft);
                        start = System.currentTimeMillis();
                        udpSocket.receive(ipkt);
                        end = System.currentTimeMillis();
                        byte[] data = ipkt.getData();
                        if (!this.isMatchResponse(data, xid)) continue;
                        byte[] byArray = data;
                        return byArray;
                    } while ((timeoutLeft = pktTimeout - (int)(end - start)) > minTimeout);
                }
                finally {
                    udpSocket.disconnect();
                }
                byte[] byArray = null;
                return byArray;
            }
        }
    }

    private byte[] doTcpQuery(Tcp tcp, Packet pkt) throws IOException {
        int len = pkt.length();
        tcp.out.write(len >> 8);
        tcp.out.write(len);
        tcp.out.write(pkt.getData(), 0, len);
        tcp.out.flush();
        byte[] msg = this.continueTcpQuery(tcp);
        if (msg == null) {
            throw new IOException("DNS error: no response");
        }
        return msg;
    }

    private byte[] continueTcpQuery(Tcp tcp) throws IOException {
        int lenHi = tcp.in.read();
        if (lenHi == -1) {
            return null;
        }
        int lenLo = tcp.in.read();
        if (lenLo == -1) {
            throw new IOException("Corrupted DNS response: bad length");
        }
        int len = lenHi << 8 | lenLo;
        byte[] msg = new byte[len];
        int pos = 0;
        while (len > 0) {
            int n = tcp.in.read(msg, pos, len);
            if (n == -1) {
                throw new IOException("Corrupted DNS response: too little data");
            }
            len -= n;
            pos += n;
        }
        return msg;
    }

    private Packet makeQueryPacket(DnsName fqdn, int xid, int qclass, int qtype, boolean recursion) {
        short qnameLen = fqdn.getOctets();
        int pktLen = 12 + qnameLen + 4;
        Packet pkt = new Packet(pktLen);
        int flags = recursion ? 256 : 0;
        pkt.putShort(xid, 0);
        pkt.putShort(flags, 2);
        pkt.putShort(1, 4);
        pkt.putShort(0, 6);
        pkt.putInt(0, 8);
        this.makeQueryName(fqdn, pkt, 12);
        pkt.putShort(qtype, 12 + qnameLen);
        pkt.putShort(qclass, 12 + qnameLen + 2);
        return pkt;
    }

    private void makeQueryName(DnsName fqdn, Packet pkt, int off) {
        for (int i = fqdn.size() - 1; i >= 0; --i) {
            String label = fqdn.get(i);
            int len = label.length();
            pkt.putByte(len, off++);
            for (int j = 0; j < len; ++j) {
                pkt.putByte(label.charAt(j), off++);
            }
        }
        if (!fqdn.hasRootLabel()) {
            pkt.putByte(0, off);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] lookupResponse(Integer xid) throws NamingException {
        byte[] pkt = this.resps.get(xid);
        if (pkt != null) {
            this.checkResponseCode(new Header(pkt, pkt.length));
            Object object = this.queuesLock;
            synchronized (object) {
                this.resps.remove(xid);
                this.reqs.remove(xid);
            }
        }
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMatchResponse(byte[] pkt, int xid) throws NamingException {
        Header hdr2 = new Header(pkt, pkt.length);
        if (hdr2.query) {
            throw new CommunicationException("DNS error: expecting response");
        }
        if (!this.reqs.containsKey(xid)) {
            return false;
        }
        if (hdr2.xid == xid) {
            this.checkResponseCode(hdr2);
            if (!hdr2.query && hdr2.numQuestions == 1) {
                ResourceRecord rr = new ResourceRecord(pkt, pkt.length, 12, true, false);
                ResourceRecord query = this.reqs.get(xid);
                int qtype = query.getType();
                int qclass = query.getRrclass();
                DnsName qname = query.getName();
                if (!(qtype != 255 && qtype != rr.getType() || qclass != 255 && qclass != rr.getRrclass() || !qname.equals(rr.getName()))) {
                    Object object = this.queuesLock;
                    synchronized (object) {
                        this.resps.remove(xid);
                        this.reqs.remove(xid);
                    }
                    return true;
                }
            }
            return false;
        }
        Object object = this.queuesLock;
        synchronized (object) {
            if (this.reqs.containsKey(hdr2.xid)) {
                this.resps.put(hdr2.xid, pkt);
            }
        }
        return false;
    }

    private void checkResponseCode(Header hdr2) throws NamingException {
        int rcode = hdr2.rcode;
        if (rcode == 0) {
            return;
        }
        String msg = rcode < rcodeDescription.length ? rcodeDescription[rcode] : "DNS error";
        msg = msg + " [response code " + rcode + "]";
        switch (rcode) {
            case 2: {
                throw new ServiceUnavailableException(msg);
            }
            case 3: {
                throw new NameNotFoundException(msg);
            }
            case 4: 
            case 5: {
                throw new OperationNotSupportedException(msg);
            }
        }
        throw new NamingException(msg);
    }

    private static void dprint(String mess) {
    }
}

