/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import sun.nio.cs.HistoricallyNamedCharset;

public class StreamEncoder
extends Writer {
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen = true;
    private Charset cs;
    private CharsetEncoder encoder;
    private ByteBuffer bb;
    private final OutputStream out;
    private WritableByteChannel ch;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private CharBuffer lcb = null;

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream out, Object lock, String charsetName) throws UnsupportedEncodingException {
        String csn = charsetName;
        if (csn == null) {
            csn = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(csn)) {
                return new StreamEncoder(out, lock, Charset.forName(csn));
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw new UnsupportedEncodingException(csn);
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream out, Object lock, Charset cs) {
        return new StreamEncoder(out, lock, cs);
    }

    public static StreamEncoder forOutputStreamWriter(OutputStream out, Object lock, CharsetEncoder enc) {
        return new StreamEncoder(out, lock, enc);
    }

    public static StreamEncoder forEncoder(WritableByteChannel ch, CharsetEncoder enc, int minBufferCap) {
        return new StreamEncoder(ch, enc, minBufferCap);
    }

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new IOException("Stream closed");
            }
            this.implFlushBuffer();
        }
    }

    @Override
    public void write(int c) throws IOException {
        char[] cbuf = new char[]{(char)c};
        this.write(cbuf, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            this.implWrite(cbuf, off, len);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        char[] cbuf = new char[len];
        str.getChars(off, off + len, cbuf, 0);
        this.write(cbuf, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.implFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private boolean isOpen() {
        return this.isOpen;
    }

    private StreamEncoder(OutputStream out, Object lock, Charset cs) {
        this(out, lock, cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    private StreamEncoder(OutputStream out, Object lock, CharsetEncoder enc) {
        super(lock);
        this.out = out;
        this.ch = null;
        this.cs = enc.charset();
        this.encoder = enc;
        if (this.ch == null) {
            this.bb = ByteBuffer.allocate(8192);
        }
    }

    private StreamEncoder(WritableByteChannel ch, CharsetEncoder enc, int mbc) {
        this.out = null;
        this.ch = ch;
        this.cs = enc.charset();
        this.encoder = enc;
        this.bb = ByteBuffer.allocate(mbc < 0 ? 8192 : mbc);
    }

    private void writeBytes() throws IOException {
        int rem;
        this.bb.flip();
        int lim = this.bb.limit();
        int pos = this.bb.position();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem > 0) {
            if (this.ch != null) {
                if (this.ch.write(this.bb) != rem) assert (false) : rem;
            } else {
                this.out.write(this.bb.array(), this.bb.arrayOffset() + pos, rem);
            }
        }
        this.bb.clear();
    }

    private void flushLeftoverChar(CharBuffer cb, boolean endOfInput) throws IOException {
        if (!this.haveLeftoverChar && !endOfInput) {
            return;
        }
        if (this.lcb == null) {
            this.lcb = CharBuffer.allocate(2);
        } else {
            this.lcb.clear();
        }
        if (this.haveLeftoverChar) {
            this.lcb.put(this.leftoverChar);
        }
        if (cb != null && cb.hasRemaining()) {
            this.lcb.put(cb.get());
        }
        this.lcb.flip();
        while (this.lcb.hasRemaining() || endOfInput) {
            CoderResult cr = this.encoder.encode(this.lcb, this.bb, endOfInput);
            if (cr.isUnderflow()) {
                if (!this.lcb.hasRemaining()) break;
                this.leftoverChar = this.lcb.get();
                if (cb != null && cb.hasRemaining()) {
                    this.flushLeftoverChar(cb, endOfInput);
                }
                return;
            }
            if (cr.isOverflow()) {
                assert (this.bb.position() > 0);
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
        this.haveLeftoverChar = false;
    }

    void implWrite(char[] cbuf, int off, int len) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
        if (this.haveLeftoverChar) {
            this.flushLeftoverChar(cb, false);
        }
        while (cb.hasRemaining()) {
            CoderResult cr = this.encoder.encode(cb, this.bb, false);
            if (cr.isUnderflow()) {
                assert (cb.remaining() <= 1) : cb.remaining();
                if (cb.remaining() != 1) break;
                this.haveLeftoverChar = true;
                this.leftoverChar = cb.get();
                break;
            }
            if (cr.isOverflow()) {
                assert (this.bb.position() > 0);
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
    }

    void implFlushBuffer() throws IOException {
        if (this.bb.position() > 0) {
            this.writeBytes();
        }
    }

    void implFlush() throws IOException {
        this.implFlushBuffer();
        if (this.out != null) {
            this.out.flush();
        }
    }

    void implClose() throws IOException {
        this.flushLeftoverChar(null, true);
        try {
            CoderResult cr;
            while (!(cr = this.encoder.flush(this.bb)).isUnderflow()) {
                if (cr.isOverflow()) {
                    assert (this.bb.position() > 0);
                    this.writeBytes();
                    continue;
                }
                cr.throwException();
            }
            if (this.bb.position() > 0) {
                this.writeBytes();
            }
            if (this.ch != null) {
                this.ch.close();
            } else {
                this.out.close();
            }
        }
        catch (IOException x) {
            this.encoder.reset();
            throw x;
        }
    }

    String encodingName() {
        return this.cs instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)((Object)this.cs)).historicalName() : this.cs.name();
    }
}

