/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.ui.components.CellTipAware;

public class CellTipManager
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static final CellTipManager sharedInstance = new CellTipManager();
    private JComponent cellTipComponent;
    private JToolTip cellTip;
    private transient Popup cellTipPopup;
    private MouseMotionListener moveBeforeEnterListener = new MoveBeforeEnterListener();
    private Rectangle popupFrameRect;
    private Rectangle popupRect;
    private UniversalCellTipListener universalCellTipListener = new UniversalCellTipListener();
    private Window cellTipWindow;
    private boolean enabled = true;
    private boolean heavyweightPopupClosed = false;
    private boolean internalMousePressed = false;

    public static CellTipManager sharedInstance() {
        return sharedInstance;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideCellTip();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void hideCellTip() {
        this.hideCellTipWindow();
        this.cellTipComponent = null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.initiateCellTip(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        Window window;
        boolean bl = true;
        if (this.cellTipWindow != null && mouseEvent.getSource() == this.cellTipWindow) {
            Container container = this.cellTipComponent.getTopLevelAncestor();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this.cellTipWindow);
            point.x -= container.getX();
            point.y -= container.getY();
            point = SwingUtilities.convertPoint(null, point, this.cellTipComponent);
            bl = point.x < 0 || point.x >= this.cellTipComponent.getWidth() || point.y < 0 || point.y >= this.cellTipComponent.getHeight();
        } else if (mouseEvent.getSource() == this.cellTipComponent && this.cellTipPopup != null && (window = SwingUtilities.getWindowAncestor(this.cellTipComponent)) != null) {
            Point point = SwingUtilities.convertPoint(this.cellTipComponent, mouseEvent.getPoint(), window);
            Rectangle rectangle = this.cellTipComponent.getTopLevelAncestor().getBounds();
            point.x += rectangle.x;
            point.y += rectangle.y;
            Point point2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(point2, this.cellTip);
            rectangle.x = point2.x;
            rectangle.y = point2.y;
            rectangle.width = this.cellTip.getWidth();
            rectangle.height = this.cellTip.getHeight();
            bl = point.x < rectangle.x || point.x >= rectangle.x + rectangle.width || point.y < rectangle.y || point.y >= rectangle.y + rectangle.height;
        }
        if (bl) {
            if (this.cellTipComponent != null) {
                this.cellTipComponent.removeMouseMotionListener(this);
            }
            this.hideCellTip();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        JComponent jComponent;
        if (this.heavyweightPopupClosed) {
            this.heavyweightPopupClosed = false;
            return;
        }
        this.cellTipComponent = jComponent = (JComponent)mouseEvent.getSource();
        this.showCellTipWindow();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.internalMousePressed) {
            return;
        }
        JComponent jComponent = this.cellTipComponent;
        this.hideCellTip();
        Object object = mouseEvent.getSource();
        if (object instanceof Component && !JComponent.isLightweightComponent((Component)object)) {
            this.heavyweightPopupClosed = true;
            this.internalMousePressed = true;
            ((CellTipAware)((Object)jComponent)).processMouseEvent(SwingUtilities.convertMouseEvent((Component)object, mouseEvent, jComponent));
            MouseEvent mouseEvent2 = new MouseEvent((Component)object, 502, mouseEvent.getWhen() + 1L, mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            ((CellTipAware)((Object)jComponent)).processMouseEvent(SwingUtilities.convertMouseEvent((Component)object, mouseEvent2, jComponent));
            this.internalMousePressed = false;
        } else {
            this.heavyweightPopupClosed = false;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.cellTipComponent instanceof CellTipAware) {
            ((CellTipAware)((Object)this.cellTipComponent)).processMouseEvent(SwingUtilities.convertMouseEvent((Component)mouseWheelEvent.getSource(), mouseWheelEvent, this.cellTipComponent));
        }
    }

    public void registerComponent(JComponent jComponent) {
        if (Platform.isMac()) {
            return;
        }
        if (!(jComponent instanceof CellTipAware)) {
            throw new RuntimeException("Only components implementing org.netbeans.lib.profiler.ui.components.CellTipAware interface can be registered!");
        }
        this.unregisterComponent(jComponent);
        jComponent.addMouseListener(this);
        jComponent.addMouseMotionListener(this.moveBeforeEnterListener);
        this.universalCellTipListener.registerForComponent(jComponent);
    }

    public void unregisterComponent(JComponent jComponent) {
        if (Platform.isMac()) {
            return;
        }
        if (!(jComponent instanceof CellTipAware)) {
            throw new RuntimeException("Only components implementing org.netbeans.lib.profiler.ui.components.CellTipAware interface can be unregistered!");
        }
        jComponent.removeMouseListener(this);
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        this.universalCellTipListener.unregisterForComponent(jComponent);
    }

    private static Frame frameForComponent(Component component) {
        while (!(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    private int getHeightAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.y >= rectangle.y && rectangle2.y + rectangle2.height <= rectangle.y + rectangle.height) {
            return 0;
        }
        return rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height) + 5;
    }

    private int getPopupFitHeight(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getHeightAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getHeightAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getPopupFitWidth(Rectangle rectangle, Component component) {
        if (component != null) {
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JFrame || container instanceof JDialog || container instanceof JWindow) {
                    return this.getWidthAdjust(container.getBounds(), rectangle);
                }
                if (!(container instanceof JApplet) && !(container instanceof JInternalFrame)) continue;
                if (this.popupFrameRect == null) {
                    this.popupFrameRect = new Rectangle();
                }
                Point point = container.getLocationOnScreen();
                this.popupFrameRect.setBounds(point.x, point.y, container.getBounds().width, container.getBounds().height);
                return this.getWidthAdjust(this.popupFrameRect, rectangle);
            }
        }
        return 0;
    }

    private int getWidthAdjust(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle2.x >= rectangle.x && rectangle2.x + rectangle2.width <= rectangle.x + rectangle.width) {
            return 0;
        }
        return rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width) + 5;
    }

    private void hideCellTipWindow() {
        if (this.cellTipPopup != null) {
            if (this.cellTipWindow != null) {
                this.cellTipWindow.removeMouseListener(this);
                this.cellTipWindow.removeMouseWheelListener(this);
                this.cellTipWindow = null;
            }
            this.cellTipPopup.hide();
            this.cellTipPopup = null;
            this.cellTip = null;
        }
    }

    private void initiateCellTip(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.cellTipWindow) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getSource();
        jComponent.removeMouseMotionListener(this.moveBeforeEnterListener);
        Point point = mouseEvent.getPoint();
        if (point.x < 0 || point.x >= jComponent.getWidth() || point.y < 0 || point.y >= jComponent.getHeight()) {
            return;
        }
        jComponent.removeMouseMotionListener(this);
        jComponent.addMouseMotionListener(this);
        boolean bl = this.cellTipComponent == jComponent;
        this.cellTipComponent = jComponent;
        if (this.cellTipPopup != null && !bl) {
            this.showCellTipWindow();
        }
    }

    private void showCellTipWindow() {
        Serializable serializable;
        if (this.cellTipComponent == null || !this.cellTipComponent.isShowing()) {
            return;
        }
        for (serializable = this.cellTipComponent.getParent(); serializable != null && !(serializable instanceof JPopupMenu); serializable = serializable.getParent()) {
            if (!(serializable instanceof Window)) continue;
            if (((Window)serializable).isFocused()) break;
            return;
        }
        if (this.enabled) {
            Point point = this.cellTipComponent.getLocationOnScreen();
            Point point2 = new Point();
            Rectangle rectangle = this.cellTipComponent.getGraphicsConfiguration().getBounds();
            this.hideCellTipWindow();
            if (!(this.cellTipComponent instanceof CellTipAware)) {
                return;
            }
            CellTipAware cellTipAware = (CellTipAware)((Object)this.cellTipComponent);
            Point point3 = cellTipAware.getCellTipLocation();
            if (point3 == null) {
                return;
            }
            this.cellTip = cellTipAware.getCellTip();
            serializable = this.cellTip.getPreferredSize();
            point2.x = point.x + point3.x;
            point2.y = point.y + point3.y;
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(point2.x, point2.y, ((Dimension)serializable).width, ((Dimension)serializable).height);
            if (point2.x < rectangle.x) {
                point2.x = rectangle.x;
            } else if (point2.x - rectangle.x + ((Dimension)serializable).width > rectangle.width) {
                point2.x = rectangle.x + Math.max(0, rectangle.width - ((Dimension)serializable).width);
            }
            if (point2.y < rectangle.y) {
                point2.y = rectangle.y;
            } else if (point2.y - rectangle.y + ((Dimension)serializable).height > rectangle.height) {
                point2.y = rectangle.y + Math.max(0, rectangle.height - ((Dimension)serializable).height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.cellTipPopup = popupFactory.getPopup(this.cellTipComponent, this.cellTip, point2.x, point2.y);
            this.cellTipPopup.show();
            Window window = SwingUtilities.windowForComponent(this.cellTipComponent);
            this.cellTipWindow = SwingUtilities.windowForComponent(this.cellTip);
            if (this.cellTipWindow != null && this.cellTipWindow != window) {
                this.cellTipWindow.addMouseListener(this);
                this.cellTipWindow.addMouseWheelListener(this);
            } else {
                this.cellTipWindow = null;
            }
        }
    }

    private class UniversalCellTipListener
    implements ComponentListener,
    KeyListener,
    FocusListener,
    PropertyChangeListener,
    HierarchyListener,
    HierarchyBoundsListener {
        private UniversalCellTipListener() {
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            this.hideCellTipForOwner(hierarchyEvent.getSource());
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            this.hideCellTipForOwner(hierarchyEvent.getSource());
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            this.hideCellTipForOwner(componentEvent.getSource());
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.hideCellTipForOwner(componentEvent.getSource());
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.hideCellTipForOwner(componentEvent.getSource());
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            this.hideCellTipForOwner(componentEvent.getSource());
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.hideCellTipForOwner(focusEvent.getSource());
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            this.hideCellTipForOwner(hierarchyEvent.getSource());
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.hideCellTipAlways();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.hideCellTipForOwner(propertyChangeEvent.getSource());
        }

        void registerForComponent(JComponent jComponent) {
            if (jComponent == null) {
                return;
            }
            jComponent.addComponentListener(this);
            jComponent.addKeyListener(this);
            jComponent.addFocusListener(this);
            jComponent.addPropertyChangeListener(this);
            jComponent.addHierarchyListener(this);
            jComponent.addHierarchyBoundsListener(this);
        }

        void unregisterForComponent(JComponent jComponent) {
            if (jComponent == null) {
                return;
            }
            jComponent.removeComponentListener(this);
            jComponent.removeKeyListener(this);
            jComponent.removeFocusListener(this);
            jComponent.removePropertyChangeListener(this);
            jComponent.removeHierarchyListener(this);
            jComponent.removeHierarchyBoundsListener(this);
        }

        private void hideCellTipAlways() {
            CellTipManager.this.hideCellTip();
        }

        private void hideCellTipForOwner(Object object) {
            if (CellTipManager.this.cellTipComponent == object) {
                CellTipManager.this.hideCellTip();
            }
        }
    }

    private class MoveBeforeEnterListener
    extends MouseMotionAdapter {
        private MoveBeforeEnterListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            CellTipManager.this.initiateCellTip(mouseEvent);
        }
    }
}

