/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Iterator;
import java.util.Properties;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.PrimitiveArrayDump;

class HprofProxy {
    HprofProxy() {
    }

    static Properties getProperties(Instance instance) {
        Instance instance2 = (Instance)instance.getValueOfField("defaults");
        ObjectArrayDump objectArrayDump = (ObjectArrayDump)instance.getValueOfField("table");
        Properties properties = instance2 != null ? new Properties(HprofProxy.getProperties(instance2)) : new Properties();
        if (objectArrayDump != null) {
            return HprofProxy.getPropertiesFromTable(objectArrayDump, properties, "key", "value");
        }
        Instance instance3 = (Instance)instance.getValueOfField("map");
        if (instance3 != null) {
            objectArrayDump = (ObjectArrayDump)instance3.getValueOfField("table");
            return HprofProxy.getPropertiesFromTable(objectArrayDump, properties, "key", "val");
        }
        return null;
    }

    private static Properties getPropertiesFromTable(ObjectArrayDump objectArrayDump, Properties properties, String string, String string2) {
        Iterator iterator = objectArrayDump.getValues().iterator();
        while (iterator.hasNext()) {
            for (Instance instance = (Instance)iterator.next(); instance != null; instance = (Instance)instance.getValueOfField("next")) {
                Instance instance2 = (Instance)instance.getValueOfField(string);
                Instance instance3 = (Instance)instance.getValueOfField(string2);
                if (instance2 == null) continue;
                properties.setProperty(HprofProxy.getString(instance2), HprofProxy.getString(instance3));
            }
        }
        return properties;
    }

    static String getString(Instance instance) {
        if (instance == null) {
            return "*null*";
        }
        String string = instance.getJavaClass().getName();
        if (String.class.getName().equals(string)) {
            Byte by = (Byte)instance.getValueOfField("coder");
            PrimitiveArrayDump primitiveArrayDump = (PrimitiveArrayDump)instance.getValueOfField("value");
            if (primitiveArrayDump != null) {
                Integer n = (Integer)instance.getValueOfField("offset");
                Integer n2 = (Integer)instance.getValueOfField("count");
                if (n == null) {
                    n = 0;
                }
                if (n2 == null) {
                    n2 = new Integer(primitiveArrayDump.getLength());
                }
                char[] cArray = HprofProxy.getChars(primitiveArrayDump, by, n, n2);
                return new String(cArray).intern();
            }
            return "*null*";
        }
        return "*" + string + "#" + instance.getInstanceNumber() + "*";
    }

    private static char[] getChars(PrimitiveArrayDump primitiveArrayDump, Byte by, int n, int n2) {
        if (by == null) {
            return primitiveArrayDump.getChars(n, n2);
        }
        int n3 = by.intValue();
        switch (n3) {
            case 0: {
                char[] cArray = new char[n2];
                byte[] byArray = primitiveArrayDump.getBytes(n, n2);
                for (int i = 0; i < byArray.length; ++i) {
                    cArray[i] = (char)(byArray[i] & 0xFF);
                }
                return cArray;
            }
            case 1: {
                int[] nArray = HprofProxy.getStringUTF16ShiftBytes(primitiveArrayDump.dumpClass.getHprof());
                char[] cArray = new char[n2 / 2];
                byte[] byArray = primitiveArrayDump.getBytes(n, n2);
                int n4 = nArray[0];
                int n5 = nArray[1];
                for (int i = 0; i < byArray.length; i += 2) {
                    cArray[i / 2] = (char)((byArray[i] & 0xFF) << n4 | (byArray[i + 1] & 0xFF) << n5);
                }
                return cArray;
            }
        }
        return "*unknown coder*".toCharArray();
    }

    private static int[] getStringUTF16ShiftBytes(Heap heap) {
        JavaClass javaClass = heap.getJavaClassByName("java.lang.StringUTF16");
        Integer n = (Integer)javaClass.getValueOfStaticField("HI_BYTE_SHIFT");
        Integer n2 = (Integer)javaClass.getValueOfStaticField("LO_BYTE_SHIFT");
        return new int[]{n, n2};
    }
}

