/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.PointsComputer;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class DiscreteXYPainter
extends TimelineXYPainter {
    private static final Polygon POLYGON = new Polygon();
    private static final int[] x3arr = new int[3];
    private static final int[] y3arr = new int[3];
    private static final int[] x4arr = new int[4];
    private static final int[] y4arr = new int[4];
    protected final int lineWidth;
    protected final Color lineColor;
    protected final Color fillColor;
    protected final Color definingColor;
    protected final Stroke lineStroke;
    protected final int width;
    protected final boolean fixedWidth;
    protected final boolean topLineOnly;
    protected final boolean outlineOnly;
    private final PointsComputer computer;

    DiscreteXYPainter(float f, Color color, Color color2, int n, boolean bl, boolean bl2, boolean bl3, double d, PointsComputer pointsComputer) {
        super((int)Math.ceil(f), color2 != null || !bl2 && !bl3, d);
        if (color == null && color2 == null) {
            throw new IllegalArgumentException("lineColor or fillColor must not be null");
        }
        this.lineWidth = (int)Math.ceil(f);
        this.lineColor = Utils.checkedColor((Color)color);
        this.fillColor = Utils.checkedColor((Color)color2);
        this.definingColor = color != null ? color : color2;
        this.lineStroke = new BasicStroke(f, 1, 1);
        this.width = n;
        this.fixedWidth = bl;
        this.topLineOnly = bl2;
        this.outlineOnly = bl3;
        this.computer = pointsComputer;
    }

    @Override
    protected Color getDefiningColor() {
        return this.definingColor;
    }

    @Override
    protected void paint(XYItem xYItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, SynchronousXYChartContext synchronousXYChartContext) {
        block21: {
            int n;
            int n2;
            int n3;
            int n4;
            block22: {
                int n5;
                n4 = 0;
                n3 = 0;
                if (this.fillColor != null || !this.topLineOnly) {
                    n4 = Utils.checkedInt((double)synchronousXYChartContext.getViewY((double)synchronousXYChartContext.getDataOffsetY()));
                    n4 = Math.max(Utils.checkedInt((double)synchronousXYChartContext.getViewportOffsetY()), n4);
                    n4 = Math.min(Utils.checkedInt((double)(synchronousXYChartContext.getViewportOffsetY() + (long)synchronousXYChartContext.getViewportHeight())), n4);
                    n3 = n4 - this.lineWidth + 1;
                }
                int n6 = this.lineColor == null || this.topLineOnly || this.outlineOnly ? 0 : Math.max(1, (this.width > 0 ? 2 : 1) * this.lineWidth - 1);
                n2 = xYItem.getValuesCount();
                if (this.width <= 0 && this.lineColor != null && !this.topLineOnly) break block22;
                int[][] nArray = this.computer.getVisible(rectangle, n2, synchronousXYChartContext, 1, 0);
                if (nArray == null) {
                    return;
                }
                int[] nArray2 = nArray[0];
                int n7 = nArray[1][0];
                int[][] nArray3 = this.computer.createPoints(nArray2, n7, xYItem, this.dataFactor, synchronousXYChartContext);
                int[] nArray4 = nArray3[0];
                int[] nArray5 = nArray3[1];
                int n8 = n5 = nArray4[0];
                int n9 = 0;
                int n10 = this.fixedWidth ? 0 : this.width;
                for (int i = 0; i < n7; ++i) {
                    int n11;
                    int n12;
                    int n13 = n4 - nArray5[i];
                    if (this.fixedWidth) {
                        n5 = Math.max(n5, n8 - this.width / 2);
                        n9 = i == n7 - 1 ? nArray4[i] : nArray4[i + 1];
                        n12 = n8 + Math.min(this.width / 2, (n9 - n8) / 2);
                    } else {
                        n9 = i == n7 - 1 ? nArray4[i] : nArray4[i + 1];
                        n11 = n9 - n8;
                        n10 = Math.min(n11, this.width + 1);
                        n12 = n8 + (n11 - n10) / 2;
                    }
                    n11 = n12 - n5;
                    if (this.fillColor != null && n11 >= n6) {
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fillRect(n5, n4 - n13, n11 + 1, n13);
                    }
                    if (this.lineColor != null) {
                        graphics2D.setColor(this.lineColor);
                        graphics2D.setStroke(this.lineStroke);
                        if (this.topLineOnly) {
                            graphics2D.drawLine(n5, n4 - n13, Math.max(n5 + 1, n12), n4 - n13);
                        } else if (n11 + 1 <= this.lineWidth) {
                            graphics2D.drawLine(n5, n4 - n13, n5, n3);
                        } else {
                            int[] nArray6;
                            int[] nArray7;
                            if (i == 0) {
                                nArray7 = DiscreteXYPainter.xArr(n5, n12, n12);
                                nArray6 = DiscreteXYPainter.yArr(n4 - n13, n4 - n13, n3);
                            } else if (i == n7 - 1) {
                                nArray7 = DiscreteXYPainter.xArr(n5, n5, n12);
                                nArray6 = DiscreteXYPainter.yArr(n3, n4 - n13, n4 - n13);
                            } else {
                                nArray7 = DiscreteXYPainter.xArr(n5, n5, n12, n12);
                                nArray6 = DiscreteXYPainter.yArr(n3, n4 - n13, n4 - n13, n3);
                            }
                            graphics2D.drawPolyline(nArray7, nArray6, nArray7.length);
                        }
                    }
                    n8 = n9;
                    n5 = n12 + n10;
                }
                break block21;
            }
            int n14 = this.fillColor != null ? 2 : 0;
            int[][] nArray = this.computer.getVisible(rectangle, n2, synchronousXYChartContext, 2, n14);
            if (nArray == null) {
                return;
            }
            int[] nArray8 = nArray[0];
            int n15 = nArray[1][0];
            int[][] nArray9 = this.computer.createPoints(nArray8, n15, xYItem, this.dataFactor, synchronousXYChartContext);
            int[] nArray10 = nArray9[0];
            int[] nArray11 = nArray9[1];
            int n16 = n15;
            n15 -= n14;
            int n17 = nArray10[0];
            for (int i = 1; i < n15 - 2; i += 2) {
                n = nArray10[i + 1];
                n -= (n - n17) / 2;
                nArray10[i] = n;
                n17 = nArray10[i + 1];
                nArray10[i + 1] = n;
            }
            if (this.fillColor != null) {
                nArray10[n16 - 2] = nArray10[n16 - 3];
                nArray11[n16 - 2] = n4;
                nArray10[n16 - 1] = nArray10[0];
                nArray11[n16 - 1] = nArray11[n16 - 2];
                DiscreteXYPainter.POLYGON.xpoints = nArray10;
                DiscreteXYPainter.POLYGON.ypoints = nArray11;
                DiscreteXYPainter.POLYGON.npoints = n16;
                graphics2D.setPaint(this.fillColor);
                graphics2D.fill(POLYGON);
            }
            graphics2D.setColor(this.lineColor);
            graphics2D.setStroke(this.lineStroke);
            graphics2D.drawPolyline(nArray10, nArray11, n15);
            if (this.outlineOnly) break block21;
            graphics2D.setColor(this.lineColor);
            graphics2D.setStroke(this.lineStroke);
            for (n = 1; n < n15 - 1; ++n) {
                int n18 = nArray11[n] + this.lineWidth / 2;
                if (n18 < n3) {
                    graphics2D.drawLine(nArray10[n], n18, nArray10[n], n3);
                }
                if ((n += 3) < n15 - 1) {
                    n18 = nArray11[n] + this.lineWidth / 2;
                    if (n18 >= n3) continue;
                    graphics2D.drawLine(nArray10[n], n18, nArray10[n], n3);
                    continue;
                }
                break;
            }
        }
    }

    private static int[] xArr(int ... nArray) {
        if (nArray.length == 3) {
            DiscreteXYPainter.x3arr[0] = nArray[0];
            DiscreteXYPainter.x3arr[1] = nArray[1];
            DiscreteXYPainter.x3arr[2] = nArray[2];
            return x3arr;
        }
        DiscreteXYPainter.x4arr[0] = nArray[0];
        DiscreteXYPainter.x4arr[1] = nArray[1];
        DiscreteXYPainter.x4arr[2] = nArray[2];
        DiscreteXYPainter.x4arr[3] = nArray[3];
        return x4arr;
    }

    private static int[] yArr(int ... nArray) {
        if (nArray.length == 3) {
            DiscreteXYPainter.y3arr[0] = nArray[0];
            DiscreteXYPainter.y3arr[1] = nArray[1];
            DiscreteXYPainter.y3arr[2] = nArray[2];
            return y3arr;
        }
        DiscreteXYPainter.y4arr[0] = nArray[0];
        DiscreteXYPainter.y4arr[1] = nArray[1];
        DiscreteXYPainter.y4arr[2] = nArray[2];
        DiscreteXYPainter.y4arr[3] = nArray[3];
        return y4arr;
    }
}

