/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.querydsl.container.AttributeSort;
import org.elasticsearch.xpack.sql.querydsl.container.QueryContainer;
import org.elasticsearch.xpack.sql.querydsl.container.ScoreSort;
import org.elasticsearch.xpack.sql.querydsl.container.ScriptSort;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;

public abstract class SourceGenerator {
    private static final List<String> NO_STORED_FIELD = Collections.singletonList("_none_");

    public static SearchSourceBuilder sourceBuilder(QueryContainer container, QueryBuilder filter, Integer size) {
        SearchSourceBuilder source = new SearchSourceBuilder();
        if (container.query() == null) {
            if (filter != null) {
                source.query((QueryBuilder)new ConstantScoreQueryBuilder(filter));
            }
        } else if (filter != null) {
            source.query((QueryBuilder)new BoolQueryBuilder().must(container.query().asBuilder()).filter(filter));
        } else {
            source.query(container.query().asBuilder());
        }
        SqlSourceBuilder sortBuilder = new SqlSourceBuilder();
        container.columns().forEach(cr -> cr.collectFields(sortBuilder));
        sortBuilder.build(source);
        SourceGenerator.optimize(sortBuilder, source);
        AggregationBuilder aggBuilder = container.aggs().asAggBuilder();
        if (aggBuilder != null) {
            source.aggregation(aggBuilder);
        }
        SourceGenerator.sorting(container, source);
        if (size != null) {
            int sz;
            int n = sz = container.limit() > 0 ? Math.min(container.limit(), size) : size;
            if (source.size() == -1) {
                source.size(sz);
            }
            if (aggBuilder instanceof CompositeAggregationBuilder) {
                ((CompositeAggregationBuilder)aggBuilder).size(sz);
            }
        }
        SourceGenerator.optimize(container, source);
        return source;
    }

    private static void sorting(QueryContainer container, SearchSourceBuilder source) {
        if (source.aggregations() != null && source.aggregations().count() > 0) {
            return;
        }
        if (container.sort() == null || container.sort().isEmpty()) {
            source.sort("_doc");
            return;
        }
        for (Sort sortable : container.sort()) {
            ScoreSortBuilder sortBuilder = null;
            if (sortable instanceof AttributeSort) {
                AttributeSort as = (AttributeSort)sortable;
                Attribute attr = as.attribute();
                if (attr instanceof FieldAttribute) {
                    FieldAttribute fa = (FieldAttribute)attr;
                    fa = fa.isInexact() ? fa.exactAttribute() : fa;
                    sortBuilder = SortBuilders.fieldSort((String)fa.name());
                    if (fa.isNested()) {
                        FieldSortBuilder fieldSort = SortBuilders.fieldSort((String)fa.name());
                        NestedSortBuilder newSort = new NestedSortBuilder(fa.nestedParent().name());
                        NestedSortBuilder nestedSort = fieldSort.getNestedSort();
                        if (nestedSort == null) {
                            fieldSort.setNestedSort(newSort);
                        } else {
                            while (nestedSort.getNestedSort() != null) {
                                nestedSort = nestedSort.getNestedSort();
                            }
                            nestedSort.setNestedSort(newSort);
                        }
                        nestedSort = newSort;
                        if (container.query() != null) {
                            container.query().enrichNestedSort(nestedSort);
                        }
                        sortBuilder = fieldSort;
                    }
                }
            } else if (sortable instanceof ScriptSort) {
                ScriptSort ss = (ScriptSort)sortable;
                sortBuilder = SortBuilders.scriptSort((Script)ss.script().toPainless(), (ScriptSortBuilder.ScriptSortType)(ss.script().outputType().isNumeric() ? ScriptSortBuilder.ScriptSortType.NUMBER : ScriptSortBuilder.ScriptSortType.STRING));
            } else if (sortable instanceof ScoreSort) {
                sortBuilder = SortBuilders.scoreSort();
            }
            if (sortBuilder == null) continue;
            sortBuilder.order(sortable.direction().asOrder());
            source.sort((SortBuilder)sortBuilder);
        }
    }

    private static void optimize(SqlSourceBuilder sqlSource, SearchSourceBuilder builder) {
        if (sqlSource.sourceFields.isEmpty()) {
            SourceGenerator.disableSource(builder);
        }
    }

    private static void optimize(QueryContainer query, SearchSourceBuilder builder) {
        if (query.isAggsOnly()) {
            builder.size(0);
            builder.trackScores(false);
            SourceGenerator.disableSource(builder);
        }
    }

    private static void disableSource(SearchSourceBuilder builder) {
        builder.fetchSource(FetchSourceContext.DO_NOT_FETCH_SOURCE);
        if (builder.storedFields() == null) {
            builder.storedFields(NO_STORED_FIELD);
        }
    }
}

