/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.artefact.Artefact;
import grails.compiler.ast.AnnotatedClassInjector;
import grails.compiler.ast.GrailsArtefactClassInjector;
import groovy.lang.Mixin;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.grails.compiler.injection.GrailsASTUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGrailsArtefactTransformer
implements GrailsArtefactClassInjector,
AnnotatedClassInjector,
Comparable {
    private static final Set<String> KNOWN_TRANSFORMED_CLASSES = new HashSet<String>();
    private static final String INSTANCE_PREFIX = "instance";
    private static final String STATIC_PREFIX = "static";
    private static final AnnotationNode AUTO_WIRED_ANNOTATION = new AnnotationNode(new ClassNode(Autowired.class));
    protected static final ClassNode OBJECT_CLASS = new ClassNode(Object.class);
    public static final int PUBLIC_STATIC_MODIFIER = 9;
    public static final String CURRENT_PREFIX = "current";
    public static final String METHOD_MISSING_METHOD_NAME = "methodMissing";
    public static final String STATIC_METHOD_MISSING_METHOD_NAME = "$static_methodMissing";
    private static final String[] DEFAULT_GENERICS_PLACEHOLDERS = new String[]{"D", "T"};
    private final Set<String> classesTransformedByThis = new HashSet<String>();

    @Override
    public String[] getArtefactTypes() {
        return new String[]{this.getArtefactType()};
    }

    protected String getArtefactType() {
        String name = this.getClass().getSimpleName();
        if (name.endsWith("Transformer")) {
            return name.substring(0, name.length() - 11);
        }
        return name;
    }

    public void clearCachedState() {
        this.classesTransformedByThis.clear();
    }

    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public void performInjection(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        if (this.shouldSkipInjection(classNode) || this.hasArtefactAnnotation(classNode)) {
            return;
        }
        this.performInjectionOnAnnotatedClass(source, context, classNode);
    }

    @Override
    public void performInjectionOnAnnotatedClass(SourceUnit source, ClassNode classNode) {
        this.performInjectionOnAnnotatedClass(source, null, classNode);
    }

    @Override
    public void performInjectionOnAnnotatedClass(SourceUnit source, GeneratorContext context, ClassNode classNode) {
        Class staticImplementation;
        if (this.shouldSkipInjection(classNode)) {
            return;
        }
        String className = classNode.getName();
        KNOWN_TRANSFORMED_CLASSES.add(className);
        this.classesTransformedByThis.add(className);
        Map<String, ClassNode> genericsPlaceholders = this.resolveGenericsPlaceHolders(classNode);
        Class instanceImplementation = this.getInstanceImplementation();
        if (instanceImplementation != null) {
            this.performInstanceImplementationInjection(source, classNode, genericsPlaceholders, instanceImplementation);
        }
        if ((staticImplementation = this.getStaticImplementation()) != null) {
            this.performStaticImplementationInjection(classNode, genericsPlaceholders, staticImplementation);
        }
        this.addEnhancedAnnotation(classNode);
    }

    protected void performInstanceImplementationInjection(SourceUnit source, ClassNode classNode, Map<String, ClassNode> genericsPlaceholders, Class instanceImplementation) {
        ConstructorCallExpression constructorCallExpression;
        ClassNode implementationNode;
        try {
            implementationNode = GrailsASTUtils.replaceGenericsPlaceholders(ClassHelper.make((Class)instanceImplementation), genericsPlaceholders);
            constructorCallExpression = GrailsASTUtils.hasZeroArgsConstructor(implementationNode) ? new ConstructorCallExpression(implementationNode, (Expression)ZERO_ARGS) : null;
        }
        catch (Throwable e) {
            return;
        }
        String apiInstanceProperty = INSTANCE_PREFIX + instanceImplementation.getSimpleName();
        VariableExpression apiInstance = new VariableExpression(apiInstanceProperty, implementationNode);
        if (this.requiresStaticLookupMethod()) {
            String lookupMethodName = CURRENT_PREFIX + instanceImplementation.getSimpleName();
            MethodNode lookupMethod = this.createStaticLookupMethod(classNode, implementationNode, apiInstanceProperty, lookupMethodName);
            apiInstance = new MethodCallExpression((Expression)new ClassExpression(classNode), lookupMethodName, (Expression)ZERO_ARGS);
            ((MethodCallExpression)apiInstance).setMethodTarget(lookupMethod);
        } else if (this.requiresAutowiring()) {
            PropertyNode propertyNode = new PropertyNode(apiInstanceProperty, 1, implementationNode, classNode, (Expression)constructorCallExpression, null, null);
            propertyNode.addAnnotation(AUTO_WIRED_ANNOTATION);
            if (this.getMarkerAnnotation() != null) {
                propertyNode.addAnnotation(this.getMarkerAnnotation());
            }
            classNode.addProperty(propertyNode);
        } else {
            FieldNode fieldNode = classNode.getField(apiInstanceProperty);
            if (fieldNode == null || Modifier.isPrivate(fieldNode.getModifiers()) && !fieldNode.getDeclaringClass().equals((Object)classNode)) {
                fieldNode = new FieldNode(apiInstanceProperty, 10, implementationNode, classNode, (Expression)constructorCallExpression);
                classNode.addField(fieldNode);
            }
        }
        while (!implementationNode.equals((Object)OBJECT_CLASS)) {
            List declaredMethods = implementationNode.getMethods();
            for (MethodNode declaredMethod : declaredMethods) {
                if (GrailsASTUtils.isConstructorMethod(declaredMethod)) {
                    GrailsASTUtils.addDelegateConstructor(classNode, declaredMethod, genericsPlaceholders);
                    continue;
                }
                if (!this.isCandidateInstanceMethod(classNode, declaredMethod)) continue;
                this.addDelegateInstanceMethod(classNode, (Expression)apiInstance, declaredMethod, this.getMarkerAnnotation(), genericsPlaceholders);
            }
            implementationNode = implementationNode.getSuperClass();
        }
        this.performInjectionInternal(apiInstanceProperty, source, classNode);
    }

    protected void performStaticImplementationInjection(ClassNode classNode, Map<String, ClassNode> genericsPlaceholders, Class staticImplementation) {
        ClassNode staticImplementationNode = GrailsASTUtils.replaceGenericsPlaceholders(ClassHelper.make((Class)staticImplementation), genericsPlaceholders);
        List declaredMethods = staticImplementationNode.getMethods();
        String staticImplementationSimpleName = staticImplementation.getSimpleName();
        String apiInstanceProperty = STATIC_PREFIX + staticImplementationSimpleName;
        String lookupMethodName = CURRENT_PREFIX + staticImplementationSimpleName;
        if (!this.requiresStaticLookupMethod()) {
            ConstructorCallExpression constructorCallExpression = new ConstructorCallExpression(staticImplementationNode, (Expression)ZERO_ARGS);
            this.addApiLookupFieldAndSetter(classNode, staticImplementationNode, apiInstanceProperty, (Expression)constructorCallExpression);
        }
        MethodNode lookupMethod = this.createStaticLookupMethod(classNode, staticImplementationNode, apiInstanceProperty, lookupMethodName);
        MethodCallExpression apiLookupMethod = new MethodCallExpression((Expression)new ClassExpression(classNode), lookupMethodName, (Expression)ZERO_ARGS);
        apiLookupMethod.setMethodTarget(lookupMethod);
        for (MethodNode declaredMethod : declaredMethods) {
            if (!this.isStaticCandidateMethod(classNode, declaredMethod)) continue;
            this.addDelegateStaticMethod(classNode, apiLookupMethod, declaredMethod, genericsPlaceholders);
        }
    }

    protected void addEnhancedAnnotation(ClassNode classNode) {
        Expression value;
        AnnotationNode annotationNode = GrailsASTUtils.addEnhancedAnnotation(classNode, new String[0]);
        AnnotationNode annotation = GrailsASTUtils.findAnnotation(classNode, Mixin.class);
        if (annotation != null && (value = annotation.getMember("value")) != null) {
            annotationNode.setMember("mixins", value);
        }
    }

    protected boolean shouldSkipInjection(ClassNode classNode) {
        return !this.isValidTargetClassNode(classNode) || !this.isValidArtefactType() && !this.isValidArtefactTypeByConvention(classNode) || this.classesTransformedByThis.contains(classNode.getName());
    }

    protected boolean hasArtefactAnnotation(ClassNode classNode) {
        return !classNode.getAnnotations(new ClassNode(Artefact.class)).isEmpty();
    }

    protected boolean isValidTargetClassNode(ClassNode classNode) {
        if (classNode.isEnum()) {
            return false;
        }
        if (classNode instanceof InnerClassNode) {
            return false;
        }
        return !classNode.getName().contains("$");
    }

    protected boolean isValidArtefactType() {
        return "Domain".equals(this.getArtefactType());
    }

    protected Map<String, ClassNode> resolveGenericsPlaceHolders(ClassNode classNode) {
        HashMap<String, ClassNode> genericsPlaceHolders = new HashMap<String, ClassNode>();
        for (String placeHolder : DEFAULT_GENERICS_PLACEHOLDERS) {
            genericsPlaceHolders.put(placeHolder, classNode);
        }
        return genericsPlaceHolders;
    }

    protected void addDelegateInstanceMethod(ClassNode classNode, Expression delegate, MethodNode declaredMethod, AnnotationNode markerAnnotation, Map<String, ClassNode> genericsPlaceholders) {
        GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)GrailsASTUtils.addDelegateInstanceMethod(classNode, delegate, declaredMethod, this.getMarkerAnnotation(), true, genericsPlaceholders, true));
    }

    protected void addDelegateStaticMethod(ClassNode classNode, MethodCallExpression apiLookupMethod, MethodNode declaredMethod, Map<String, ClassNode> genericsPlaceholders) {
        GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)GrailsASTUtils.addDelegateStaticMethod((Expression)apiLookupMethod, classNode, declaredMethod, this.getMarkerAnnotation(), genericsPlaceholders, true));
    }

    private boolean isValidArtefactTypeByConvention(ClassNode classNode) {
        String[] artefactTypes;
        for (String artefactType : artefactTypes = this.getArtefactTypes()) {
            if (artefactType.equals("*")) {
                return true;
            }
            if (!classNode.getName().endsWith(artefactType)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCandidateInstanceMethod(ClassNode classNode, MethodNode declaredMethod) {
        return GrailsASTUtils.isCandidateInstanceMethod(classNode, declaredMethod);
    }

    protected boolean isStaticCandidateMethod(ClassNode classNode, MethodNode declaredMethod) {
        return this.isStaticMethodIncluded(classNode, declaredMethod) || !this.isStaticMethodExcluded(classNode, declaredMethod) && GrailsASTUtils.isCandidateMethod(declaredMethod);
    }

    protected boolean isStaticMethodExcluded(ClassNode classNode, MethodNode declaredMethod) {
        return GrailsASTUtils.isSetterOrGetterMethod(declaredMethod);
    }

    protected boolean isStaticMethodIncluded(ClassNode classNode, MethodNode declaredMethod) {
        return false;
    }

    private MethodNode createStaticLookupMethod(ClassNode classNode, ClassNode implementationNode, String apiProperty, String lookupMethodName) {
        MethodNode lookupMethod = classNode.getMethod(lookupMethodName, ZERO_PARAMETERS);
        if (lookupMethod == null || !lookupMethod.getDeclaringClass().equals((Object)classNode)) {
            BlockStatement methodBody = new BlockStatement();
            lookupMethod = this.populateAutowiredApiLookupMethod(classNode, implementationNode, apiProperty, lookupMethodName, methodBody);
            classNode.addMethod(lookupMethod);
            GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)lookupMethod);
        }
        return lookupMethod;
    }

    protected boolean requiresStaticLookupMethod() {
        return false;
    }

    protected MethodNode populateAutowiredApiLookupMethod(ClassNode classNode, ClassNode implementationNode, String apiProperty, String methodName, BlockStatement methodBody) {
        this.addApiLookupFieldAndSetter(classNode, implementationNode, apiProperty, null);
        VariableExpression apiVar = new VariableExpression(apiProperty, implementationNode);
        BlockStatement ifBlock = new BlockStatement();
        ArgumentListExpression arguments = new ArgumentListExpression();
        arguments.addExpression((Expression)new ConstantExpression((Object)("Method on class [" + classNode + "] was used outside of a Grails application. If running in the context of a test using the mocking API or bootstrap Grails correctly.")));
        ifBlock.addStatement((Statement)new ThrowStatement((Expression)new ConstructorCallExpression(new ClassNode(IllegalStateException.class), (Expression)arguments)));
        BlockStatement elseBlock = new BlockStatement();
        elseBlock.addStatement((Statement)new ReturnStatement((Expression)apiVar));
        methodBody.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new BinaryExpression((Expression)apiVar, GrailsASTUtils.EQUALS_OPERATOR, (Expression)GrailsASTUtils.NULL_EXPRESSION)), (Statement)ifBlock, (Statement)elseBlock));
        MethodNode methodNode = new MethodNode(methodName, 9, implementationNode, ZERO_PARAMETERS, null, (Statement)methodBody);
        return methodNode;
    }

    protected void addApiLookupFieldAndSetter(ClassNode classNode, ClassNode implementationNode, String apiProperty, Expression initialValueExpression) {
        FieldNode fieldNode = classNode.getField(apiProperty);
        if (fieldNode == null || !fieldNode.getDeclaringClass().equals((Object)classNode)) {
            fieldNode = new FieldNode(apiProperty, 10, implementationNode, classNode, initialValueExpression);
            classNode.addField(fieldNode);
            String setterName = "set" + MetaClassHelper.capitalize((String)apiProperty);
            Parameter setterParameter = new Parameter(implementationNode, apiProperty);
            BlockStatement setterBody = new BlockStatement();
            setterBody.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)new AttributeExpression((Expression)new ClassExpression(classNode), (Expression)new ConstantExpression((Object)apiProperty)), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new VariableExpression((Variable)setterParameter))));
            GrailsASTUtils.addCompileStaticAnnotation((AnnotatedNode)classNode.addMethod(setterName, 9, ClassHelper.VOID_TYPE, new Parameter[]{setterParameter}, null, (Statement)setterBody));
        }
    }

    protected MethodNode populateDefaultApiLookupMethod(ClassNode implementationNode, String apiInstanceProperty, String methodName, BlockStatement methodBody) {
        methodBody.addStatement((Statement)new ReturnStatement((Expression)new VariableExpression(apiInstanceProperty, implementationNode)));
        return new MethodNode(methodName, 2, implementationNode, ZERO_PARAMETERS, null, (Statement)methodBody);
    }

    protected boolean requiresAutowiring() {
        return true;
    }

    protected void performInjectionInternal(String apiInstanceProperty, SourceUnit source, ClassNode classNode) {
    }

    public abstract Class getInstanceImplementation();

    public abstract Class getStaticImplementation();

    @Override
    public void performInjection(SourceUnit source, ClassNode classNode) {
        this.performInjection(source, null, classNode);
    }

    protected AnnotationNode getMarkerAnnotation() {
        return null;
    }

    public static Collection<String> getTransformedClassNames() {
        return Collections.unmodifiableCollection(KNOWN_TRANSFORMED_CLASSES);
    }

    public static void addToTransformedClasses(String name) {
        KNOWN_TRANSFORMED_CLASSES.add(name);
    }
}

