/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bufferset;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.util.Log;

public class BufferSetManager {
    private BufferSet.Scope scope;

    public BufferSetManager() {
        EditBus.addToBus(this);
        try {
            this.scope = BufferSet.Scope.valueOf(jEdit.getProperty("bufferset.scope", "global"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.log(9, this, illegalArgumentException);
            this.scope = BufferSet.Scope.global;
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        if (editPaneUpdate.getWhat() == EditPaneUpdate.DESTROYED) {
            Buffer[] bufferArray;
            EditPane editPane = editPaneUpdate.getEditPane();
            BufferSet bufferSet = editPane.getBufferSet();
            for (Buffer buffer : bufferArray = bufferSet.getAllBuffers()) {
                this._removeBuffer(bufferSet, buffer);
            }
        }
    }

    @EditBus.EBHandler
    public void handlePropertiesChanged(PropertiesChanged propertiesChanged) {
        jEdit.visit(new JEditVisitorAdapter(){

            @Override
            public void visit(EditPane editPane) {
                editPane.getBufferSet().propertiesChanged();
            }
        });
    }

    public int countBufferSets(Buffer buffer) {
        return this.getOwners(buffer).size();
    }

    public void setScope(BufferSet.Scope scope) {
        if (scope == this.scope) {
            return;
        }
        jEdit.setProperty("bufferset.scope", scope.name());
        if (scope.compareTo(this.scope) > 0) {
            if (scope == BufferSet.Scope.global) {
                final Buffer[] bufferArray = jEdit.getBuffers();
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        for (Buffer buffer : bufferArray) {
                            bufferSet.addBuffer(buffer);
                        }
                    }
                });
            } else {
                final HashMap hashMap = new HashMap();
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        Buffer[] bufferArray = bufferSet.getAllBuffers();
                        HashSet<Buffer> hashSet = (HashSet<Buffer>)hashMap.get(editPane.getView());
                        if (hashSet == null) {
                            hashSet = new HashSet<Buffer>();
                            hashMap.put(editPane.getView(), hashSet);
                        }
                        hashSet.addAll(Arrays.asList(bufferArray));
                    }
                });
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        Set set = (Set)hashMap.get(editPane.getView());
                        for (Buffer buffer : set) {
                            bufferSet.addBuffer(buffer);
                        }
                    }
                });
            }
        }
        this.scope = scope;
        EditBus.send(new PropertiesChanged(this));
    }

    public BufferSet.Scope getScope() {
        return this.scope;
    }

    public void addBuffer(View view, Buffer buffer) {
        EditPane editPane = view == null ? null : view.getEditPane();
        this.addBuffer(editPane, buffer);
    }

    public void addBuffer(EditPane editPane, final Buffer buffer) {
        if (editPane == null) {
            editPane = jEdit.getActiveView().getEditPane();
        }
        BufferSet bufferSet = editPane.getBufferSet();
        switch (this.scope) {
            case editpane: {
                bufferSet.addBuffer(buffer);
                break;
            }
            case view: {
                EditPane[] editPaneArray;
                for (EditPane editPane2 : editPaneArray = editPane.getView().getEditPanes()) {
                    if (editPane2 == null) continue;
                    BufferSet bufferSet2 = editPane2.getBufferSet();
                    bufferSet2.addBuffer(buffer);
                }
                break;
            }
            case global: {
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        bufferSet.addBuffer(buffer);
                    }
                });
            }
        }
    }

    public void moveBuffer(EditPane editPane, int n, int n2) {
        editPane.getBufferSet().moveBuffer(n, n2);
    }

    public void removeBuffer(EditPane editPane, Buffer buffer) {
        switch (this.scope) {
            case editpane: {
                BufferSet bufferSet = editPane.getBufferSet();
                this.removeBuffer(bufferSet, buffer);
                break;
            }
            case view: {
                EditPane[] editPaneArray;
                for (EditPane editPane2 : editPaneArray = editPane.getView().getEditPanes()) {
                    this.removeBuffer(editPane2.getBufferSet(), buffer);
                }
                break;
            }
            case global: {
                jEdit._closeBuffer(null, buffer);
            }
        }
    }

    void removeBuffer(BufferSet bufferSet, Buffer buffer) {
        Log.log(1, this, "removeBuffer(" + bufferSet + ',' + buffer + ')');
        this._removeBuffer(bufferSet, buffer);
        this.bufferRemoved(bufferSet);
    }

    public void removeBuffer(Buffer buffer) {
        for (BufferSet bufferSet : this.getOwners(buffer)) {
            bufferSet.removeBuffer(buffer);
            this.bufferRemoved(bufferSet);
        }
    }

    private void bufferRemoved(BufferSet bufferSet) {
        if (bufferSet.size() == 0) {
            Buffer buffer = BufferSetManager.createUntitledBuffer();
            EditPane editPane = BufferSetManager.getOwner(bufferSet);
            this.addBuffer(editPane, buffer);
        }
    }

    private void _removeBuffer(BufferSet bufferSet, Buffer buffer) {
        Set<BufferSet> set = this.getOwners(buffer);
        set.remove(bufferSet);
        bufferSet.removeBuffer(buffer);
        if (set.isEmpty()) {
            Log.log(1, this, "Buffer:" + buffer + " is in no bufferSet anymore, closing it");
            jEdit._closeBuffer(null, buffer);
        }
    }

    public static Buffer createUntitledBuffer() {
        Object object;
        int n = jEdit.getNextUntitledBufferId();
        View view = jEdit.getActiveView();
        String string = null;
        if (view != null) {
            object = view.getBuffer();
            string = ((Buffer)object).getDirectory();
        }
        if (string == null) {
            string = MiscUtilities.getBackupDirectory();
        }
        object = null;
        if (string != null) {
            object = VFSManager.getVFSForPath(string);
        }
        if (object != null && (((VFS)object).getCapabilities() & 2) == 0) {
            string = System.getProperty("user.home");
        }
        Buffer buffer = jEdit.openTemporary(view, string, "Untitled-" + n, true, true);
        jEdit.commitTemporary(buffer);
        return buffer;
    }

    public Set<BufferSet> getOwners(Buffer buffer) {
        final HashSet<BufferSet> hashSet = new HashSet<BufferSet>();
        jEdit.visit(new JEditVisitorAdapter(){

            @Override
            public void visit(EditPane editPane) {
                hashSet.add(editPane.getBufferSet());
            }
        });
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            if (((BufferSet)iterator.next()).indexOf(buffer) != -1) continue;
            iterator.remove();
        }
        return hashSet;
    }

    private static EditPane getOwner(BufferSet bufferSet) {
        View[] viewArray;
        for (View view : viewArray = jEdit.getViews()) {
            EditPane[] editPaneArray;
            for (EditPane editPane : editPaneArray = view.getEditPanes()) {
                if (editPane.getBufferSet() != bufferSet) continue;
                return editPane;
            }
        }
        return null;
    }
}

