/*
 * Decompiled with CFR 0.152.
 */
package scala.reflect.internal.util;

import java.lang.invoke.MethodHandle;
import scala.reflect.internal.util.AlmostFinalValue;
import scala.reflect.internal.util.BooleanContainer;

public final class StatisticsStatics
extends BooleanContainer {
    private static final AlmostFinalValue<BooleanContainer> COLD_STATS = new AlmostFinalValue<BooleanContainer>(){

        @Override
        protected BooleanContainer initialValue() {
            return new BooleanContainer.FalseContainer();
        }
    };
    private static final AlmostFinalValue<BooleanContainer> HOT_STATS = new AlmostFinalValue<BooleanContainer>(){

        @Override
        protected BooleanContainer initialValue() {
            return new BooleanContainer.FalseContainer();
        }
    };
    private static final MethodHandle COLD_STATS_GETTER = COLD_STATS.createGetter();
    private static final MethodHandle HOT_STATS_GETTER = HOT_STATS.createGetter();

    public StatisticsStatics(boolean value) {
        super(value);
    }

    public static boolean areSomeColdStatsEnabled() {
        try {
            return ((BooleanContainer)COLD_STATS_GETTER.invokeExact()).isEnabledNow();
        }
        catch (Throwable e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    public static boolean areSomeHotStatsEnabled() {
        try {
            return ((BooleanContainer)HOT_STATS_GETTER.invokeExact()).isEnabledNow();
        }
        catch (Throwable e) {
            throw new AssertionError(e.getMessage(), e);
        }
    }

    public static void enableColdStats() {
        COLD_STATS.setValue(new BooleanContainer.TrueContainer());
    }

    public static void disableColdStats() {
        COLD_STATS.setValue(new BooleanContainer.FalseContainer());
    }

    public static void enableHotStats() {
        HOT_STATS.setValue(new BooleanContainer.TrueContainer());
    }

    public static void disableHotStats() {
        HOT_STATS.setValue(new BooleanContainer.FalseContainer());
    }
}

