/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger.diff;

import java.util.ArrayList;
import org.openoffice.xmerge.merger.DiffAlgorithm;
import org.openoffice.xmerge.merger.Difference;
import org.openoffice.xmerge.merger.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IteratorRowCompare
implements DiffAlgorithm {
    public Difference[] computeDiffs(Iterator orgSeq, Iterator modSeq) {
        Difference diff;
        ArrayList<Difference> diffVector = new ArrayList<Difference>();
        int i = 0;
        int j = 0;
        Object orgSeqObject = orgSeq.start();
        Object modSeqObject = modSeq.start();
        boolean different = false;
        boolean orgSplited = false;
        boolean modSplited = false;
        while (orgSeqObject != null) {
            different = true;
            if (modSeqObject == null) {
                diff = new Difference(2, i, j);
                diffVector.add(diff);
                orgSeqObject = orgSeq.next();
            } else {
                if (!orgSeq.equivalent(orgSeqObject, modSeqObject)) {
                    Element orgRow = (Element)orgSeqObject;
                    Element modRow = (Element)modSeqObject;
                    String orgRowRepeated = orgRow.getAttribute("table:number-rows-repeated");
                    String modRowRepeated = modRow.getAttribute("table:number-rows-repeated");
                    int orgRowNum = 1;
                    int modRowNum = 1;
                    if (orgRowRepeated.length() > 0) {
                        orgRowNum = Integer.parseInt(orgRowRepeated);
                    }
                    if (modRowRepeated.length() > 0) {
                        modRowNum = Integer.parseInt(modRowRepeated);
                    }
                    if (orgRowNum == modRowNum) {
                        orgSeqObject = orgSeq.next();
                        modSeqObject = modSeq.next();
                    } else if (orgRowNum > modRowNum) {
                        Element orgSplitRow = this.splitRepeatedRow(orgRow, modRowNum, orgRowNum - modRowNum);
                        if (orgSeq.equivalent(orgSplitRow, modRow)) {
                            different = false;
                        }
                        orgSplited = true;
                        modSeqObject = modSeq.next();
                    } else {
                        Element modSplitRow = this.splitRepeatedRow(modRow, orgRowNum, modRowNum - orgRowNum);
                        if (modSeq.equivalent(orgRow, modSplitRow)) {
                            different = false;
                        }
                        modSplited = true;
                        orgSeqObject = orgSeq.next();
                    }
                    if (different) {
                        Difference diff2 = new Difference(3, i, j);
                        diffVector.add(diff2);
                    }
                } else {
                    orgSeqObject = orgSeq.next();
                    modSeqObject = modSeq.next();
                }
                ++j;
            }
            ++i;
        }
        while (modSeqObject != null) {
            diff = new Difference(1, i, j);
            diffVector.add(diff);
            modSeqObject = modSeq.next();
            ++j;
        }
        if (orgSplited) {
            orgSeq.refresh();
        }
        if (modSplited) {
            modSeq.refresh();
        }
        Difference[] diffArray = new Difference[diffVector.size()];
        diffVector.toArray(diffArray);
        return diffArray;
    }

    private Element splitRepeatedRow(Element orgRow, int splitNum, int orgNum) {
        Element splitRow = (Element)orgRow.cloneNode(true);
        if (splitNum > 1) {
            splitRow.setAttribute("table:number-rows-repeated", String.valueOf(splitNum));
        } else if (splitNum == 1) {
            splitRow.removeAttribute("table:number-rows-repeated");
        }
        if (orgNum > 1) {
            orgRow.setAttribute("table:number-rows-repeated", String.valueOf(orgNum));
        } else if (orgNum == 1) {
            orgRow.removeAttribute("table:number-rows-repeated");
        }
        Node parentNode = orgRow.getParentNode();
        parentNode.insertBefore(splitRow, orgRow);
        return splitRow;
    }
}

