/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class TermsGroupConfig
implements Writeable,
ToXContentFragment {
    private static final String NAME = "term_group_config";
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("term_group_config", Builder::new);
    private static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private static final List<String> FLOAT_TYPES = Arrays.asList("half_float", "float", "double", "scaled_float");
    private static final List<String> NATURAL_TYPES = Arrays.asList("byte", "short", "integer", "long");
    private final String[] fields;

    private TermsGroupConfig(String[] fields) {
        this.fields = fields;
    }

    TermsGroupConfig(StreamInput in) throws IOException {
        this.fields = in.readStringArray();
    }

    public String[] getFields() {
        return this.fields;
    }

    public List<CompositeValuesSourceBuilder<?>> toBuilders() {
        if (this.fields.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.fields).map(f -> {
            TermsValuesSourceBuilder vsBuilder = new TermsValuesSourceBuilder(RollupField.formatIndexerAggName(f, "terms"));
            vsBuilder.field(f);
            return vsBuilder;
        }).collect(Collectors.toList());
    }

    public Map<String, Object> toAggCap() {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("agg", "terms");
        return map;
    }

    public Map<String, Object> getMetadata() {
        return Collections.emptyMap();
    }

    public Set<String> getAllFields() {
        return Arrays.stream(this.fields).collect(Collectors.toSet());
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Arrays.stream(this.fields).forEach(field -> {
            Map fieldCaps = (Map)fieldCapsResponse.get(field);
            if (fieldCaps != null && !fieldCaps.isEmpty()) {
                fieldCaps.forEach((key, value) -> {
                    if (key.equals("keyword") || key.equals("text")) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else if (FLOAT_TYPES.contains(key)) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else if (NATURAL_TYPES.contains(key)) {
                        if (!value.isAggregatable()) {
                            validationException.addValidationError("The field [" + field + "] must be aggregatable across all indices, but is not.");
                        }
                    } else {
                        validationException.addValidationError("The field referenced by a terms group must be a [numeric] or [keyword/text] type, but found " + fieldCaps.keySet().toString() + " for field [" + field + "]");
                    }
                });
            } else {
                validationException.addValidationError("Could not find a [numeric] or [keyword/text] field with name [" + field + "] in any of the indices matching the index pattern.");
            }
        });
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(FIELDS.getPreferredName(), (Object)this.fields);
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.fields);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TermsGroupConfig that = (TermsGroupConfig)other;
        return Arrays.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareStringArray(Builder::setFields, FIELDS);
    }

    public static class Builder {
        private List<String> fields;

        public List<String> getFields() {
            return this.fields;
        }

        public Builder setFields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public TermsGroupConfig build() {
            if (this.fields == null || this.fields.isEmpty()) {
                throw new IllegalArgumentException("Parameter [" + FIELDS + "] must have at least one value.");
            }
            return new TermsGroupConfig(this.fields.toArray(new String[0]));
        }
    }
}

