/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingQueue;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.UpdateProcessAction;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.job.process.autodetect.UpdateParams;
import org.elasticsearch.xpack.ml.utils.VolatileCursorIterator;

public class UpdateJobProcessNotifier
extends AbstractComponent
implements LocalNodeMasterListener {
    private final Client client;
    private final ThreadPool threadPool;
    private final LinkedBlockingQueue<UpdateHolder> orderedJobUpdates = new LinkedBlockingQueue(1000);
    private volatile Scheduler.Cancellable cancellable;

    public UpdateJobProcessNotifier(Settings settings, Client client, ClusterService clusterService, ThreadPool threadPool) {
        super(settings);
        this.client = client;
        this.threadPool = threadPool;
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                UpdateJobProcessNotifier.this.stop();
            }
        });
    }

    boolean submitJobUpdate(UpdateParams update, ActionListener<Boolean> listener) {
        return this.orderedJobUpdates.offer(new UpdateHolder(update, listener));
    }

    public void onMaster() {
        this.start();
    }

    public void offMaster() {
        this.stop();
    }

    private void start() {
        this.cancellable = this.threadPool.scheduleWithFixedDelay(this::processNextUpdate, TimeValue.timeValueSeconds((long)1L), "generic");
    }

    private void stop() {
        this.orderedJobUpdates.clear();
        Scheduler.Cancellable cancellable = this.cancellable;
        if (cancellable != null) {
            cancellable.cancel();
        }
    }

    public String executorName() {
        return "same";
    }

    private void processNextUpdate() {
        ArrayList updates = new ArrayList(this.orderedJobUpdates.size());
        try {
            this.orderedJobUpdates.drainTo(updates);
            this.executeProcessUpdates(new VolatileCursorIterator<UpdateHolder>(updates));
        }
        catch (Exception e) {
            this.logger.error("Error while processing next job update", (Throwable)e);
        }
    }

    void executeProcessUpdates(final Iterator<UpdateHolder> updatesIterator) {
        if (!updatesIterator.hasNext()) {
            return;
        }
        final UpdateHolder updateHolder = updatesIterator.next();
        final UpdateParams update = updateHolder.update;
        UpdateProcessAction.Request request = new UpdateProcessAction.Request(update.getJobId(), update.getModelPlotConfig(), update.getDetectorUpdates(), update.getFilter(), update.isUpdateScheduledEvents());
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)UpdateProcessAction.INSTANCE, (ActionRequest)request, (ActionListener)new ActionListener<UpdateProcessAction.Response>(){

            public void onResponse(UpdateProcessAction.Response response) {
                if (response.isUpdated()) {
                    UpdateJobProcessNotifier.this.logger.info("Successfully updated remote job [{}]", (Object)update.getJobId());
                    updateHolder.listener.onResponse((Object)true);
                } else {
                    String msg = "Failed to update remote job [" + update.getJobId() + "]";
                    UpdateJobProcessNotifier.this.logger.error(msg);
                    updateHolder.listener.onFailure((Exception)ExceptionsHelper.serverError((String)msg));
                }
                UpdateJobProcessNotifier.this.executeProcessUpdates(updatesIterator);
            }

            public void onFailure(Exception e) {
                if (e instanceof ResourceNotFoundException) {
                    UpdateJobProcessNotifier.this.logger.debug("Remote job [{}] not updated as it has been deleted", (Object)update.getJobId());
                } else if (e.getMessage().contains("because job [" + update.getJobId() + "] is not open") && e instanceof ElasticsearchStatusException) {
                    UpdateJobProcessNotifier.this.logger.debug("Remote job [{}] not updated as it is no longer open", (Object)update.getJobId());
                } else {
                    UpdateJobProcessNotifier.this.logger.error("Failed to update remote job [" + update.getJobId() + "]", (Throwable)e);
                }
                updateHolder.listener.onFailure(e);
                UpdateJobProcessNotifier.this.executeProcessUpdates(updatesIterator);
            }
        });
    }

    private static class UpdateHolder {
        private final UpdateParams update;
        private final ActionListener<Boolean> listener;

        private UpdateHolder(UpdateParams update, ActionListener<Boolean> listener) {
            this.update = update;
            this.listener = listener;
        }
    }
}

