/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.create;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.ShardsAcknowledgedResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class CreateIndexResponse
extends ShardsAcknowledgedResponse {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ConstructingObjectParser<CreateIndexResponse, Void> PARSER = new ConstructingObjectParser("create_index", true, args -> new CreateIndexResponse((Boolean)args[0], (Boolean)args[1], (String)args[2]));
    private String index;

    protected static <T extends CreateIndexResponse> void declareFields(ConstructingObjectParser<T, Void> objectParser) {
        CreateIndexResponse.declareAcknowledgedAndShardsAcknowledgedFields(objectParser);
        objectParser.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> parser.textOrNull(), INDEX, ObjectParser.ValueType.STRING_OR_NULL);
    }

    protected CreateIndexResponse() {
    }

    protected CreateIndexResponse(boolean acknowledged, boolean shardsAcknowledged, String index) {
        super(acknowledged, shardsAcknowledged);
        this.index = index;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.readAcknowledged(in);
        this.readShardsAcknowledged(in);
        if (in.getVersion().onOrAfter(Version.V_5_6_0)) {
            this.index = in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeAcknowledged(out);
        this.writeShardsAcknowledged(out);
        if (out.getVersion().onOrAfter(Version.V_5_6_0)) {
            out.writeString(this.index);
        }
    }

    @Deprecated
    public boolean isShardsAcked() {
        return this.isShardsAcknowledged();
    }

    public String index() {
        return this.index;
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.field(INDEX.getPreferredName(), this.index());
    }

    public static CreateIndexResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            CreateIndexResponse that = (CreateIndexResponse)o;
            return Objects.equals(this.index, that.index);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.index);
    }

    static {
        CreateIndexResponse.declareFields(PARSER);
    }
}

