/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client.shared;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RemoteFailure {
    static final int MAX_RAW_RESPONSE = 524288;
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private final String type;
    private final String reason;
    private final String remoteTrace;
    private final Map<String, String> headers;
    private final Map<String, List<String>> metadata;
    private final RemoteFailure cause;

    public static RemoteFailure parseFromResponse(InputStream stream) throws IOException {
        stream = new BufferedInputStream(stream);
        stream.mark(524288);
        try (JsonParser parser = null;){
            parser = JSON_FACTORY.createParser(stream);
            RemoteFailure remoteFailure = RemoteFailure.parseResponseTopLevel(parser);
            return remoteFailure;
        }
    }

    RemoteFailure(String type, String reason, String remoteTrace, Map<String, String> headers, Map<String, List<String>> metadata, RemoteFailure cause) {
        this.type = type;
        this.reason = reason;
        this.remoteTrace = remoteTrace;
        this.headers = headers;
        this.metadata = metadata;
        this.cause = cause;
    }

    public String type() {
        return this.type;
    }

    public String reason() {
        return this.reason;
    }

    public String remoteTrace() {
        return this.remoteTrace;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public Map<String, List<String>> metadata() {
        return this.metadata;
    }

    public RemoteFailure cause() {
        return this.cause;
    }

    private static RemoteFailure parseResponseTopLevel(JsonParser parser) throws IOException {
        RemoteFailure exception = null;
        JsonToken token = parser.nextToken();
        if (token != JsonToken.START_OBJECT) {
            throw new IllegalArgumentException("Expected error to start with [START_OBJECT] but started with [" + (Object)((Object)token) + "][" + parser.getText() + "]");
        }
        String fieldName = null;
        block8: while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            switch (fieldName) {
                case "error": {
                    if (token != JsonToken.START_OBJECT) {
                        throw new IOException("Expected [error] to be an object but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                    }
                    exception = RemoteFailure.parseFailure(parser);
                    continue block8;
                }
                case "status": {
                    if (token == JsonToken.VALUE_NUMBER_INT) continue block8;
                    throw new IOException("Expected [status] to be a string but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                }
            }
            throw new IOException("Expected one of [error, status] but got [" + fieldName + "][" + parser.getText() + "]");
        }
        if (exception == null) {
            throw new IOException("Expected [error] but didn't see it.");
        }
        return exception;
    }

    private static RemoteFailure parseFailure(JsonParser parser) throws IOException {
        JsonToken token;
        String type = null;
        String reason = null;
        String remoteTrace = null;
        Map<String, String> headers = Collections.emptyMap();
        RemoteFailure cause = null;
        LinkedHashMap<String, List<String>> metadata = new LinkedHashMap<String, List<String>>();
        String fieldName = null;
        block20: while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token == JsonToken.FIELD_NAME) {
                fieldName = parser.getCurrentName();
                continue;
            }
            switch (fieldName) {
                case "caused_by": {
                    if (token != JsonToken.START_OBJECT) {
                        throw new IOException("Expected [caused_by] to be an object but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                    }
                    cause = RemoteFailure.parseFailure(parser);
                    continue block20;
                }
                case "header": {
                    if (token != JsonToken.START_OBJECT) {
                        throw new IOException("Expected [header] to be an object but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                    }
                    headers = RemoteFailure.parseHeaders(parser);
                    continue block20;
                }
                case "reason": {
                    switch (token) {
                        case VALUE_STRING: {
                            reason = parser.getText();
                            continue block20;
                        }
                        case VALUE_NULL: {
                            continue block20;
                        }
                    }
                    throw new IOException("Expected [reason] to be a string but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                }
                case "root_cause": {
                    if (token != JsonToken.START_ARRAY) {
                        throw new IOException("Expected [root_cause] to be an array but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                    }
                    parser.skipChildren();
                    continue block20;
                }
                case "stack_trace": {
                    if (token != JsonToken.VALUE_STRING) {
                        throw new IOException("Expected [stack_trace] to be a string but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                    }
                    remoteTrace = parser.getText();
                    continue block20;
                }
                case "type": {
                    if (token != JsonToken.VALUE_STRING) {
                        throw new IOException("Expected [type] to be a string but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
                    }
                    type = parser.getText();
                    continue block20;
                }
            }
            metadata.putAll(RemoteFailure.parseMetadata(parser));
        }
        if (type == null) {
            throw new IOException("expected [type] but didn't see it");
        }
        if (remoteTrace == null) {
            throw new IOException("expected [stack_trace] cannot but didn't see it");
        }
        return new RemoteFailure(type, reason, remoteTrace, headers, metadata, cause);
    }

    private static Map<String, String> parseHeaders(JsonParser parser) throws IOException {
        JsonToken token;
        HashMap<String, String> headers = new HashMap<String, String>();
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token != JsonToken.FIELD_NAME) {
                throw new IOException("expected header name but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
            }
            String name = parser.getText();
            token = parser.nextToken();
            if (token != JsonToken.VALUE_STRING) {
                throw new IOException("expected header value but was [" + (Object)((Object)token) + "][" + parser.getText() + "]");
            }
            String value = parser.getText();
            headers.put(name, value);
        }
        return headers;
    }

    private static Map<String, List<String>> parseMetadata(JsonParser parser) throws IOException {
        HashMap metadata = new HashMap();
        String currentFieldName = parser.getCurrentName();
        JsonToken token = parser.currentToken();
        if (token == JsonToken.VALUE_STRING) {
            metadata.put(currentFieldName, Collections.singletonList(parser.getText()));
        } else if (token == JsonToken.START_ARRAY) {
            ArrayList<String> values = new ArrayList<String>();
            while ((token = parser.nextToken()) != JsonToken.END_ARRAY) {
                if (token == JsonToken.VALUE_STRING) {
                    values.add(parser.getText());
                    continue;
                }
                parser.skipChildren();
            }
            if (values.size() > 0) {
                if (metadata.containsKey(currentFieldName)) {
                    values.addAll((Collection)metadata.get(currentFieldName));
                }
                metadata.put(currentFieldName, Collections.unmodifiableList(values));
            }
        } else {
            parser.skipChildren();
        }
        return Collections.unmodifiableMap(metadata);
    }

    private static String parseErrorMessage(String message, InputStream stream, JsonParser parser) {
        String responseMessage;
        try {
            try {
                stream.reset();
            }
            catch (IOException e) {
                throw new IOException("Response too large", e);
            }
            try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                int read;
                StringBuilder builder = new StringBuilder();
                builder.append("Response:\n");
                char[] buf = new char[512];
                while ((read = reader.read(buf)) != -1) {
                    builder.append(buf, 0, read);
                }
                responseMessage = builder.toString();
            }
        }
        catch (IOException replayException) {
            responseMessage = "Attempted to include response but failed because [" + replayException.getMessage() + "].";
        }
        String parserLocation = "";
        if (parser != null) {
            parserLocation = " at [line " + parser.getTokenLocation().getLineNr() + " col " + parser.getTokenLocation().getColumnNr() + "]";
        }
        return "Can't parse error from Elasticsearch [" + message + "]" + parserLocation + ". " + responseMessage;
    }

    static {
        JSON_FACTORY.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        JSON_FACTORY.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JSON_FACTORY.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, true);
        JSON_FACTORY.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        JSON_FACTORY.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, false);
        JSON_FACTORY.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
    }
}

