/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client.shared;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.elasticsearch.xpack.sql.client.shared.StringUtils;

public class Version {
    public static final Version CURRENT;
    public final String version;
    public final String hash;
    public final byte major;
    public final byte minor;
    public final byte revision;

    private Version(String version, String hash, byte ... parts) {
        this.version = version;
        this.hash = hash;
        this.major = parts[0];
        this.minor = parts[1];
        this.revision = parts[2];
    }

    public static Version fromString(String version) {
        return new Version(version, "Unknown", Version.from(version));
    }

    static byte[] from(String ver) {
        String[] parts = ver.split("[.-]");
        if (parts.length == 3 || parts.length == 4) {
            return new byte[]{Byte.parseByte(parts[0]), Byte.parseByte(parts[1]), Byte.parseByte(parts[2])};
        }
        throw new IllegalArgumentException("Invalid version " + ver);
    }

    public String toString() {
        return "v" + this.version + " [" + this.hash + "]";
    }

    public static int jdbcMajorVersion() {
        return 4;
    }

    public static int jdbcMinorVersion() {
        return 2;
    }

    static {
        String ver;
        Enumeration<URL> res;
        String target = Version.class.getName().replace(".", "/").concat(".class");
        try {
            res = Version.class.getClassLoader().getResources(target);
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Cannot detect Elasticsearch JDBC jar; it typically indicates a deployment issue...");
        }
        if (res != null) {
            ArrayList<URL> urls = Collections.list(res);
            LinkedHashSet<String> normalized = new LinkedHashSet<String>();
            for (URL url : urls) {
                normalized.add(StringUtils.normalize(url.toString()));
            }
            int foundJars = 0;
            if (normalized.size() > 1) {
                StringBuilder sb = new StringBuilder("Multiple Elasticsearch JDBC versions detected in the classpath; please use only one\n");
                for (String s : normalized) {
                    if (!s.contains("jar:")) continue;
                    ++foundJars;
                    sb.append(s.replace("!/" + target, ""));
                    sb.append("\n");
                }
                if (foundJars > 1) {
                    throw new IllegalArgumentException(sb.toString());
                }
            }
        }
        URL url = Version.class.getProtectionDomain().getCodeSource().getLocation();
        String urlStr = url.toString();
        byte maj = 0;
        byte min = 0;
        byte rev = 0;
        String hash = ver = "Unknown";
        if (urlStr.endsWith(".jar")) {
            try (JarInputStream jar = new JarInputStream(url.openStream());){
                Manifest manifest = jar.getManifest();
                hash = manifest.getMainAttributes().getValue("Change");
                ver = manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Version");
                byte[] vers = Version.from(ver);
                maj = vers[0];
                min = vers[1];
                rev = vers[2];
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Detected Elasticsearch JDBC jar but cannot retrieve its version", ex);
            }
        }
        CURRENT = new Version(ver, hash, maj, min, rev);
    }
}

