/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.sql.plugin.SqlQueryResponse;

public class CliFormatter
implements Writeable {
    private static final int MIN_COLUMN_WIDTH = 15;
    private int[] width;

    public CliFormatter(SqlQueryResponse response) {
        this.width = new int[response.columns().size()];
        for (int i = 0; i < this.width.length; ++i) {
            this.width[i] = Math.max(15, response.columns().get(i).name().length());
        }
        for (List<Object> row : response.rows()) {
            for (int i = 0; i < this.width.length; ++i) {
                this.width[i] = Math.max(this.width[i], Objects.toString(row.get(i)).length());
            }
        }
    }

    public CliFormatter(StreamInput in) throws IOException {
        this.width = in.readIntArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeIntArray(this.width);
    }

    public String formatWithHeader(SqlQueryResponse response) {
        int i;
        StringBuilder sb = new StringBuilder(this.estimateSize(response.rows().size() + 2));
        for (i = 0; i < this.width.length; ++i) {
            int j;
            if (i > 0) {
                sb.append('|');
            }
            String name = response.columns().get(i).name();
            int leftPadding = (this.width[i] - name.length()) / 2;
            for (j = 0; j < leftPadding; ++j) {
                sb.append(' ');
            }
            sb.append(name);
            for (j = 0; j < this.width[i] - name.length() - leftPadding; ++j) {
                sb.append(' ');
            }
        }
        sb.append('\n');
        for (i = 0; i < this.width.length; ++i) {
            if (i > 0) {
                sb.append('+');
            }
            for (int j = 0; j < this.width[i]; ++j) {
                sb.append('-');
            }
        }
        sb.append('\n');
        return this.formatWithoutHeader(sb, response);
    }

    public String formatWithoutHeader(SqlQueryResponse response) {
        return this.formatWithoutHeader(new StringBuilder(this.estimateSize(response.rows().size())), response);
    }

    private String formatWithoutHeader(StringBuilder sb, SqlQueryResponse response) {
        for (List<Object> row : response.rows()) {
            for (int i = 0; i < this.width.length; ++i) {
                String string;
                if (i > 0) {
                    sb.append('|');
                }
                if ((string = Objects.toString(row.get(i))).length() <= this.width[i]) {
                    sb.append(string);
                    int padding = this.width[i] - string.length();
                    for (int p = 0; p < padding; ++p) {
                        sb.append(' ');
                    }
                    continue;
                }
                sb.append(string.substring(0, this.width[i] - 1));
                sb.append('~');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    int estimateSize(int rows) {
        int rowWidthEstimate = this.width.length;
        for (int w : this.width) {
            rowWidthEstimate += w;
        }
        return rowWidthEstimate * rows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CliFormatter that = (CliFormatter)o;
        return Arrays.equals(this.width, that.width);
    }

    public int hashCode() {
        return Arrays.hashCode(this.width);
    }
}

