/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.sql.JDBCType;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public final class ColumnInfo
implements Writeable,
ToXContentObject {
    private static final ConstructingObjectParser<ColumnInfo, Void> PARSER = new ConstructingObjectParser("column_info", true, objects -> new ColumnInfo(objects[0] == null ? "" : (String)objects[0], (String)objects[1], (String)objects[2], objects[3] == null ? null : JDBCType.valueOf((Integer)objects[3]), objects[4] == null ? 0 : (Integer)objects[4]));
    private static final ParseField TABLE = new ParseField("table", new String[0]);
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField ES_TYPE = new ParseField("type", new String[0]);
    private static final ParseField JDBC_TYPE = new ParseField("jdbc_type", new String[0]);
    private static final ParseField DISPLAY_SIZE = new ParseField("display_size", new String[0]);
    private final String table;
    private final String name;
    private final String esType;
    @Nullable
    private final JDBCType jdbcType;
    private final int displaySize;

    public ColumnInfo(String table, String name, String esType, JDBCType jdbcType, int displaySize) {
        this.table = table;
        this.name = name;
        this.esType = esType;
        this.jdbcType = jdbcType;
        this.displaySize = displaySize;
    }

    public ColumnInfo(String table, String name, String esType) {
        this.table = table;
        this.name = name;
        this.esType = esType;
        this.jdbcType = null;
        this.displaySize = 0;
    }

    ColumnInfo(StreamInput in) throws IOException {
        this.table = in.readString();
        this.name = in.readString();
        this.esType = in.readString();
        if (in.readBoolean()) {
            this.jdbcType = JDBCType.valueOf(in.readVInt());
            this.displaySize = in.readVInt();
        } else {
            this.jdbcType = null;
            this.displaySize = 0;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.table);
        out.writeString(this.name);
        out.writeString(this.esType);
        if (this.jdbcType != null) {
            out.writeBoolean(true);
            out.writeVInt(this.jdbcType.getVendorTypeNumber());
            out.writeVInt(this.displaySize);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (Strings.hasText(this.table)) {
            builder.field("table", this.table);
        }
        builder.field("name", this.name);
        builder.field("type", this.esType);
        if (this.jdbcType != null) {
            builder.field("jdbc_type", this.jdbcType.getVendorTypeNumber());
            builder.field("display_size", this.displaySize);
        }
        return builder.endObject();
    }

    public static ColumnInfo fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public String table() {
        return this.table;
    }

    public String name() {
        return this.name;
    }

    public String esType() {
        return this.esType;
    }

    public JDBCType jdbcType() {
        return this.jdbcType;
    }

    public int displaySize() {
        return this.displaySize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        return this.displaySize == that.displaySize && Objects.equals(this.table, that.table) && Objects.equals(this.name, that.name) && Objects.equals(this.esType, that.esType) && this.jdbcType == that.jdbcType;
    }

    public int hashCode() {
        return Objects.hash(this.table, this.name, this.esType, this.jdbcType, this.displaySize);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TABLE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ES_TYPE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), JDBC_TYPE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), DISPLAY_SIZE);
    }
}

