/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.trigger.manual;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.trigger.TriggerEngine;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTrigger;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTriggerEvent;

public class ManualTriggerEngine
implements TriggerEngine<ManualTrigger, ManualTriggerEvent> {
    static final String TYPE = "manual";

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void start(Collection<Watch> jobs) {
    }

    @Override
    public void stop() {
    }

    @Override
    public void register(Consumer<Iterable<TriggerEvent>> consumer) {
    }

    @Override
    public void add(Watch job) {
    }

    @Override
    public void pauseExecution() {
    }

    @Override
    public int getJobCount() {
        return 0;
    }

    @Override
    public boolean remove(String jobId) {
        return false;
    }

    @Override
    public ManualTriggerEvent simulateEvent(String jobId, @Nullable Map<String, Object> data, TriggerService service) {
        if (data == null) {
            throw Exceptions.illegalArgument((String)"could not simulate manual trigger event. missing required simulated trigger type", (Object[])new Object[0]);
        }
        if (data.size() == 1) {
            String type = data.keySet().iterator().next();
            return new ManualTriggerEvent(jobId, service.simulateEvent(type, jobId, data));
        }
        Object type = data.get("type");
        if (type instanceof String) {
            return new ManualTriggerEvent(jobId, service.simulateEvent((String)type, jobId, data));
        }
        throw Exceptions.illegalArgument((String)"could not simulate manual trigger event. could not resolve simulated trigger type", (Object[])new Object[0]);
    }

    @Override
    public ManualTrigger parseTrigger(String context, XContentParser parser) throws IOException {
        return ManualTrigger.parse(parser);
    }

    @Override
    public ManualTriggerEvent parseTriggerEvent(TriggerService service, String watchId, String context, XContentParser parser) throws IOException {
        return ManualTriggerEvent.parse(service, watchId, context, parser);
    }
}

