/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.WriterConstants;
import org.objectweb.asm.Type;

public class FunctionRef {
    public final String interfaceMethodName;
    public final MethodType factoryMethodType;
    public final MethodType interfaceMethodType;
    public final String delegateClassName;
    public final int delegateInvokeType;
    public final String delegateMethodName;
    public final MethodType delegateMethodType;
    public final Definition.Method interfaceMethod;
    public final Definition.Method delegateMethod;
    public final String factoryDescriptor;
    public final Type interfaceType;
    public final Type delegateType;

    public FunctionRef(Definition definition, Class<?> expected, String type, String call, int numCaptures) {
        this(expected, definition.ClassToType(expected).struct.functionalMethod, FunctionRef.lookup(definition, expected, type, call, numCaptures > 0), numCaptures);
    }

    public FunctionRef(Class<?> expected, Definition.Method interfaceMethod, Definition.Method delegateMethod, int numCaptures) {
        MethodType delegateMethodType = delegateMethod.getMethodType();
        this.interfaceMethodName = interfaceMethod.name;
        this.factoryMethodType = MethodType.methodType(expected, delegateMethodType.dropParameterTypes(numCaptures, delegateMethodType.parameterCount()));
        this.interfaceMethodType = interfaceMethod.getMethodType().dropParameterTypes(0, 1);
        this.delegateClassName = delegateMethod.owner == null ? WriterConstants.CLASS_NAME : (delegateMethod.augmentation != null ? delegateMethod.augmentation.getName() : delegateMethod.owner.clazz.getName());
        this.delegateInvokeType = "<init>".equals(delegateMethod.name) ? 8 : (Modifier.isStatic(delegateMethod.modifiers) ? 6 : (delegateMethod.owner.clazz.isInterface() ? 9 : 5));
        this.delegateMethodName = delegateMethod.name;
        this.delegateMethodType = delegateMethodType.dropParameterTypes(0, numCaptures);
        this.interfaceMethod = interfaceMethod;
        this.delegateMethod = delegateMethod;
        this.factoryDescriptor = this.factoryMethodType.toMethodDescriptorString();
        this.interfaceType = Type.getMethodType((String)this.interfaceMethodType.toMethodDescriptorString());
        this.delegateType = Type.getMethodType((String)this.delegateMethodType.toMethodDescriptorString());
    }

    public FunctionRef(Class<?> expected, Definition.Method interfaceMethod, String delegateMethodName, MethodType delegateMethodType, int numCaptures) {
        this.interfaceMethodName = interfaceMethod.name;
        this.factoryMethodType = MethodType.methodType(expected, delegateMethodType.dropParameterTypes(numCaptures, delegateMethodType.parameterCount()));
        this.interfaceMethodType = interfaceMethod.getMethodType().dropParameterTypes(0, 1);
        this.delegateClassName = WriterConstants.CLASS_NAME;
        this.delegateInvokeType = 6;
        this.delegateMethodName = delegateMethodName;
        this.delegateMethodType = delegateMethodType.dropParameterTypes(0, numCaptures);
        this.interfaceMethod = null;
        this.delegateMethod = null;
        this.factoryDescriptor = null;
        this.interfaceType = null;
        this.delegateType = null;
    }

    private static Definition.Method lookup(Definition definition, Class<?> expected, String type, String call, boolean receiverCaptured) {
        Definition.Method impl;
        Definition.Method method = definition.ClassToType(expected).struct.functionalMethod;
        if (method == null) {
            throw new IllegalArgumentException("Cannot convert function reference [" + type + "::" + call + "] to [" + Definition.ClassToName(expected) + "], not a functional interface");
        }
        Definition.Struct struct = definition.getType((String)type).struct;
        if ("new".equals(call)) {
            impl = struct.constructors.get(new Definition.MethodKey("<init>", method.arguments.size()));
        } else {
            Definition.Method staticImpl = struct.staticMethods.get(new Definition.MethodKey(call, method.arguments.size()));
            if (staticImpl == null) {
                int arity = receiverCaptured ? method.arguments.size() : method.arguments.size() - 1;
                impl = struct.methods.get(new Definition.MethodKey(call, arity));
            } else {
                impl = staticImpl;
            }
        }
        if (impl == null) {
            throw new IllegalArgumentException("Unknown reference [" + type + "::" + call + "] matching [" + expected + "]");
        }
        return impl;
    }
}

