/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.rest.RestStatus;

public class GetPipelineResponse
extends ActionResponse
implements StatusToXContentObject {
    private List<PipelineConfiguration> pipelines;

    public GetPipelineResponse() {
    }

    public GetPipelineResponse(List<PipelineConfiguration> pipelines) {
        this.pipelines = pipelines;
    }

    public List<PipelineConfiguration> pipelines() {
        return this.pipelines;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.pipelines = new ArrayList<PipelineConfiguration>(size);
        for (int i = 0; i < size; ++i) {
            this.pipelines.add(PipelineConfiguration.readFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.pipelines.size());
        for (PipelineConfiguration pipeline : this.pipelines) {
            pipeline.writeTo(out);
        }
    }

    public boolean isFound() {
        return !this.pipelines.isEmpty();
    }

    @Override
    public RestStatus status() {
        return this.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (PipelineConfiguration pipeline : this.pipelines) {
            builder.field(pipeline.getId(), pipeline.getConfigAsMap());
        }
        builder.endObject();
        return builder;
    }
}

