/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rollup;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.action.RollupJobCaps;
import org.elasticsearch.xpack.core.rollup.job.DateHistoGroupConfig;
import org.joda.time.DateTimeZone;

public class RollupJobIdentifierUtils {
    private static final Comparator<RollupJobCaps> COMPARATOR = RollupJobIdentifierUtils.getComparator();

    public static Set<RollupJobCaps> findBestJobs(AggregationBuilder source, Set<RollupJobCaps> jobCaps) {
        HashSet<RollupJobCaps> bestCaps = new HashSet<RollupJobCaps>();
        RollupJobIdentifierUtils.doFindBestJobs(source, new ArrayList<RollupJobCaps>(jobCaps), bestCaps);
        return bestCaps;
    }

    private static void doFindBestJobs(AggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        if (source.getWriteableName().equals("date_histogram")) {
            RollupJobIdentifierUtils.checkDateHisto((DateHistogramAggregationBuilder)source, jobCaps, bestCaps);
        } else if (source.getWriteableName().equals("histogram")) {
            RollupJobIdentifierUtils.checkHisto((HistogramAggregationBuilder)source, jobCaps, bestCaps);
        } else if (RollupField.SUPPORTED_METRICS.contains(source.getWriteableName())) {
            RollupJobIdentifierUtils.checkVSLeaf((ValuesSourceAggregationBuilder.LeafOnly)source, jobCaps, bestCaps);
        } else if (source.getWriteableName().equals("terms")) {
            RollupJobIdentifierUtils.checkTerms((TermsAggregationBuilder)source, jobCaps, bestCaps);
        } else {
            throw new IllegalArgumentException("Unable to translate aggregation tree into Rollup.  Aggregation [" + source.getName() + "] is of type [" + source.getClass().getSimpleName() + "] which is currently unsupported.");
        }
    }

    private static void checkDateHisto(DateHistogramAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                String sourceTimeZone;
                if (!agg.get("agg").equals("date_histogram")) continue;
                TimeValue interval = TimeValue.parseTimeValue((String)((String)agg.get("interval")), (String)"date_histogram.interval");
                String thisTimezone = (String)agg.get(DateHistoGroupConfig.TIME_ZONE.getPreferredName());
                if (!thisTimezone.equalsIgnoreCase(sourceTimeZone = source.timeZone() == null ? DateTimeZone.UTC.toString() : source.timeZone().toString())) continue;
                if (source.dateHistogramInterval() != null) {
                    TimeValue sourceInterval = TimeValue.parseTimeValue((String)source.dateHistogramInterval().toString(), (String)"source.date_histogram.interval");
                    if (interval.compareTo(sourceInterval) > 0) continue block0;
                    localCaps.add(cap);
                    continue block0;
                }
                if (interval.getMillis() > source.interval()) continue block0;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static void checkHisto(HistogramAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals("histogram")) continue;
                Long interval = (long)((Long)agg.get("interval"));
                if (!((double)interval.longValue() <= source.interval())) continue block0;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static void checkTerms(TermsAggregationBuilder source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals("terms")) continue;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg on field [" + source.field() + "] which also satisfies all requirements of query.");
        }
        if (source.getSubAggregations().size() == 0) {
            bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
        } else {
            source.getSubAggregations().forEach(sub -> RollupJobIdentifierUtils.doFindBestJobs(sub, localCaps, bestCaps));
        }
    }

    private static void checkVSLeaf(ValuesSourceAggregationBuilder.LeafOnly source, List<RollupJobCaps> jobCaps, Set<RollupJobCaps> bestCaps) {
        ArrayList<RollupJobCaps> localCaps = new ArrayList<RollupJobCaps>();
        block0: for (RollupJobCaps cap : jobCaps) {
            RollupJobCaps.RollupFieldCaps fieldCaps = (RollupJobCaps.RollupFieldCaps)cap.getFieldCaps().get(source.field());
            if (fieldCaps == null) continue;
            for (Map agg : fieldCaps.getAggs()) {
                if (!agg.get("agg").equals(source.getWriteableName())) continue;
                localCaps.add(cap);
                continue block0;
            }
        }
        if (localCaps.isEmpty()) {
            throw new IllegalArgumentException("There is not a rollup job that has a [" + source.getWriteableName() + "] agg with name [" + source.getName() + "] which also satisfies all requirements of query.");
        }
        bestCaps.add(RollupJobIdentifierUtils.getTopEqualCaps(localCaps));
    }

    private static RollupJobCaps getTopEqualCaps(List<RollupJobCaps> caps) {
        assert (!caps.isEmpty());
        caps.sort(COMPARATOR);
        return caps.get(0);
    }

    private static Comparator<RollupJobCaps> getComparator() {
        return (o1, o2) -> {
            if (o1 == null) {
                throw new NullPointerException("RollupJobCap [o1] cannot be null");
            }
            if (o2 == null) {
                throw new NullPointerException("RollupJobCap [o2] cannot be null");
            }
            if (o1.equals(o2)) {
                return 0;
            }
            TimeValue thisTime = null;
            TimeValue thatTime = null;
            float thisHistoWeights = 0.0f;
            float thatHistoWeights = 0.0f;
            long counter = 0L;
            long thisTermsWeights = 0L;
            long thatTermsWeights = 0L;
            for (RollupJobCaps.RollupFieldCaps fieldCaps : o1.getFieldCaps().values()) {
                for (Map agg : fieldCaps.getAggs()) {
                    if (agg.get("agg").equals("date_histogram")) {
                        thisTime = TimeValue.parseTimeValue((String)((String)agg.get("interval")), (String)"interval");
                        continue;
                    }
                    if (agg.get("agg").equals("histogram")) {
                        thisHistoWeights += (float)((Long)agg.get("interval")).longValue();
                        ++counter;
                        continue;
                    }
                    if (!agg.get("agg").equals("terms")) continue;
                    ++thisTermsWeights;
                }
            }
            thisHistoWeights = counter == 0L ? 0.0f : thisHistoWeights / (float)counter;
            counter = 0L;
            for (RollupJobCaps.RollupFieldCaps fieldCaps : o2.getFieldCaps().values()) {
                for (Map agg : fieldCaps.getAggs()) {
                    if (agg.get("agg").equals("date_histogram")) {
                        thatTime = TimeValue.parseTimeValue((String)((String)agg.get("interval")), (String)"interval");
                        continue;
                    }
                    if (agg.get("agg").equals("histogram")) {
                        thatHistoWeights += (float)((Long)agg.get("interval")).longValue();
                        ++counter;
                        continue;
                    }
                    if (!agg.get("agg").equals("terms")) continue;
                    ++thatTermsWeights;
                }
            }
            float f = thatHistoWeights = counter == 0L ? 0.0f : thatHistoWeights / (float)counter;
            assert (thisTime != null);
            assert (thatTime != null);
            int timeCompare = thisTime.compareTo(thatTime);
            if (timeCompare != 0) {
                return -timeCompare;
            }
            int histoCompare = Float.compare(thisHistoWeights, thatHistoWeights);
            if (histoCompare != 0) {
                if (thisHistoWeights == 0.0f) {
                    return -1;
                }
                if (thatHistoWeights == 0.0f) {
                    return 1;
                }
                return -histoCompare;
            }
            return Long.compare(thisTermsWeights, thatTermsWeights);
        };
    }
}

