/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@NotNull Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        LinkedHashMap map2 = new LinkedHashMap();
        boolean bl = false;
        for (K k : $receiver) {
            void index;
            Map map3 = map2;
            Integer n = (int)index;
            map3.put(k, n);
            ++index;
        }
        return map2;
    }

    public static final <T> void addIfNotNull(@NotNull Collection<T> $receiver, @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionsKt.capacity(expectedSize));
    }

    private static final int capacity(int expectedSize) {
        return expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1;
    }

    @NotNull
    public static final <T> List<T> compact(@NotNull ArrayList<T> $receiver) {
        List list;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        switch ($receiver.size()) {
            case 0: {
                list = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((List)$receiver));
                break;
            }
            default: {
                ArrayList<T> arrayList;
                ArrayList<T> $receiver2 = arrayList = $receiver;
                $receiver2.trimToSize();
                list = arrayList;
            }
        }
        return list;
    }
}

