/*
 * Decompiled with CFR 0.152.
 */
package org.testng.remote.strprotocol;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.SocketException;
import org.testng.remote.RemoteTestNG;
import org.testng.remote.strprotocol.BaseMessageSender;
import org.testng.remote.strprotocol.IMessage;
import org.testng.remote.strprotocol.IStringMessage;
import org.testng.remote.strprotocol.MessageHelper;

public class StringMessageSender
extends BaseMessageSender {
    private PrintWriter writer;

    public StringMessageSender(String host, int port) {
        super(host, port, false);
    }

    public StringMessageSender(String host, int port, boolean ack) {
        super(host, port, ack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(IMessage message) {
        if (this.m_outStream == null) {
            throw new IllegalStateException("Trying to send a message on a shutdown sender");
        }
        if (this.writer == null) {
            try {
                this.writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.m_outStream, "UTF-8")), false);
            }
            catch (UnsupportedEncodingException e1) {
                this.writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.m_outStream)), false);
            }
        }
        String msg = ((IStringMessage)message).getMessageAsString();
        if (RemoteTestNG.isVerbose()) {
            StringMessageSender.p("Sending message:" + message);
            StringMessageSender.p("  String version:" + msg);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < msg.length(); ++i) {
                if ('\u0001' == msg.charAt(i)) {
                    StringMessageSender.p("  word:[" + buf.toString() + "]");
                    buf.delete(0, buf.length());
                    continue;
                }
                buf.append(msg.charAt(i));
            }
            StringMessageSender.p("  word:[" + buf.toString() + "]");
        }
        Object object = this.m_ackLock;
        synchronized (object) {
            this.writer.println(msg);
            this.writer.flush();
            this.waitForAck();
        }
    }

    private static void p(String msg) {
        if (RemoteTestNG.isVerbose()) {
            System.out.println("[StringMessageSender] " + msg);
        }
    }

    public IMessage receiveMessage() {
        IMessage result = null;
        if (this.m_inReader == null) {
            try {
                this.m_inReader = new BufferedReader(new InputStreamReader(this.m_inStream, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                this.m_inReader = new BufferedReader(new InputStreamReader(this.m_inStream));
            }
        }
        try {
            result = this.receiveMessage(this.m_inReader.readLine());
        }
        catch (SocketException e) {
            this.handleThrowable(e);
        }
        catch (IOException e) {
            this.handleThrowable(e);
        }
        return result;
    }

    protected void handleThrowable(Throwable cause) {
        if (RemoteTestNG.isVerbose()) {
            cause.printStackTrace();
        }
    }

    private IMessage receiveMessage(String message) {
        if (message == null) {
            return null;
        }
        IStringMessage result = null;
        int messageType = MessageHelper.getMessageType(message);
        result = messageType < 10 ? MessageHelper.unmarshallGenericMessage(message) : (messageType < 100 ? MessageHelper.createSuiteMessage(message) : (messageType < 1000 ? MessageHelper.createTestMessage(message) : MessageHelper.unmarshallTestResultMessage(message)));
        StringMessageSender.p("receiveMessage() received:" + result);
        return result;
    }
}

