/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileBackedDirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.TaskDependencies;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCollection
implements FileCollectionInternal {
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    public File getSingleFile() throws IllegalStateException {
        Iterator<File> iterator = this.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        File singleFile = iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains more than one file.", this.getDisplayName()));
        }
        return singleFile;
    }

    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    public String getAsPath() {
        return GUtil.asPath((Iterable)((Object)this));
    }

    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this, collection);
    }

    public FileCollection minus(final FileCollection collection) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            public Set<File> getFiles() {
                LinkedHashSet<File> files = new LinkedHashSet<File>(AbstractFileCollection.this.getFiles());
                files.removeAll(collection.getFiles());
                return files;
            }

            @Override
            public boolean contains(File file) {
                return AbstractFileCollection.this.contains(file) && !collection.contains(file);
            }
        };
    }

    public FileCollection add(FileCollection collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.format("%s does not allow modification.", this.getCapDisplayName()));
    }

    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> fileTrees = new ArrayList<DirectoryFileTree>();
        Iterator<File> i$ = this.iterator();
        while (i$.hasNext()) {
            File file = i$.next();
            if (!file.isFile()) continue;
            fileTrees.add(new FileBackedDirectoryFileTree(file));
        }
        return fileTrees;
    }

    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    public FileCollection stopExecutionIfEmpty() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"FileCollection.stopExecutionIfEmpty()");
        if (this.isEmpty()) {
            throw new StopExecutionException(String.format("%s does not contain any files.", this.getCapDisplayName()));
        }
        return this;
    }

    @Deprecated
    public Object asType(Class<?> type) throws UnsupportedOperationException {
        if (type.isAssignableFrom(Object[].class)) {
            return this.getFiles().toArray();
        }
        if (type.isAssignableFrom(File[].class)) {
            DeprecationLogger.nagUserOfDeprecatedBehaviour((String)"Do not cast FileCollection to File[]");
            Set files = this.getFiles();
            return files.toArray(new File[0]);
        }
        if (type.isAssignableFrom(File.class)) {
            DeprecationLogger.nagUserOfDeprecatedThing((String)"Do not cast FileCollection to File", (String)"Call getSingleFile() instead");
            return this.getSingleFile();
        }
        if (type.isAssignableFrom(FileCollection.class)) {
            return this;
        }
        if (type.isAssignableFrom(FileTree.class)) {
            DeprecationLogger.nagUserOfDeprecatedThing((String)"Do not cast FileCollection to FileTree", (String)"Call getAsFileTree() instead");
            return this.getAsFileTree();
        }
        return DefaultGroovyMethods.asType((Iterable)((Object)this), type);
    }

    public TaskDependency getBuildDependencies() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"AbstractFileCollection.getBuildDependencies()", (String)"Do not extend AbstractFileCollection, use Project.files() instead.");
        return TaskDependencies.EMPTY;
    }

    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void visitContents(FileCollectionResolveContext context) {
                ResolvableFileCollectionResolveContext nested = context.newContext();
                nested.add(AbstractFileCollection.this);
                context.add(nested.resolveAsFileTrees());
            }

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add(AbstractFileCollection.this);
            }

            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }
        };
    }

    public FileCollection filter(Closure filterClosure) {
        return this.filter((Spec<? super File>)Specs.convertClosureToSpec((Closure)filterClosure));
    }

    public FileCollection filter(final Spec<? super File> filterSpec) {
        Predicate<File> predicate = new Predicate<File>(){

            public boolean apply(@Nullable File input) {
                return filterSpec.isSatisfiedBy((Object)input);
            }
        };
        return new AbstractFileCollection((Predicate)predicate){
            final /* synthetic */ Predicate val$predicate;
            {
                this.val$predicate = predicate;
            }

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            public Set<File> getFiles() {
                return Sets.filter((Set)AbstractFileCollection.this.getFiles(), (Predicate)this.val$predicate);
            }

            @Override
            public boolean contains(File file) {
                return AbstractFileCollection.this.contains(file) && this.val$predicate.apply((Object)file);
            }

            @Override
            public Iterator<File> iterator() {
                return Iterators.filter(AbstractFileCollection.this.iterator(), (Predicate)this.val$predicate);
            }
        };
    }

    protected String getCapDisplayName() {
        return StringUtils.capitalize((String)this.getDisplayName());
    }

    @Override
    public void visitRootElements(FileCollectionVisitor visitor) {
        visitor.visitCollection(this);
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        Iterator<File> i$ = this.iterator();
        while (i$.hasNext()) {
            File file = i$.next();
            builder.add(file);
        }
    }
}

