/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import org.apache.commons.io.FileUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.state.CollectingFileCollectionSnapshotBuilder;
import org.gradle.api.internal.changedetection.state.DirectoryTreeDetails;
import org.gradle.api.internal.changedetection.state.EmptyFileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.MissingFileSnapshot;
import org.gradle.api.internal.changedetection.state.OutputPathNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskOutputChangesListener;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.UnrecoverableTaskOutputUnpackingException;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginFactory;
import org.gradle.internal.file.FileType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskOutputCacheCommandFactory {
    private static final Logger LOGGER = Logging.getLogger(TaskOutputCacheCommandFactory.class);
    private static final Predicate<? super FileSnapshot> EXCLUDE_ROOT_SNAPSHOTS = new Predicate<FileSnapshot>(){

        public boolean apply(FileSnapshot snapshot) {
            return !snapshot.isRoot();
        }
    };
    private final TaskOutputPacker packer;
    private final TaskOutputOriginFactory taskOutputOriginFactory;
    private final FileSystemMirror fileSystemMirror;
    private final StringInterner stringInterner;

    public TaskOutputCacheCommandFactory(TaskOutputPacker packer, TaskOutputOriginFactory taskOutputOriginFactory, FileSystemMirror fileSystemMirror, StringInterner stringInterner) {
        this.packer = packer;
        this.taskOutputOriginFactory = taskOutputOriginFactory;
        this.fileSystemMirror = fileSystemMirror;
        this.stringInterner = stringInterner;
    }

    public BuildCacheLoadCommand<OriginTaskExecutionMetadata> createLoad(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, TaskProperties taskProperties, TaskOutputChangesListener taskOutputChangesListener, TaskArtifactState taskArtifactState) {
        return new LoadCommand(cacheKey, outputProperties, task, taskProperties, taskOutputChangesListener, taskArtifactState);
    }

    public BuildCacheStoreCommand createStore(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, Map<String, Map<String, FileContentSnapshot>> outputSnapshots, TaskInternal task, long taskExecutionTime) {
        return new StoreCommand(cacheKey, outputProperties, outputSnapshots, task, taskExecutionTime);
    }

    private String internedAbsolutePath(File outputFile) {
        return this.stringInterner.intern(outputFile.getAbsolutePath());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final TaskOutputCachingBuildCacheKey cacheKey;
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final Map<String, Map<String, FileContentSnapshot>> outputSnapshots;
        private final TaskInternal task;
        private final long taskExecutionTime;

        private StoreCommand(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, Map<String, Map<String, FileContentSnapshot>> outputSnapshots, TaskInternal task, long taskExecutionTime) {
            this.cacheKey = cacheKey;
            this.outputProperties = outputProperties;
            this.outputSnapshots = outputSnapshots;
            this.task = task;
            this.taskExecutionTime = taskExecutionTime;
        }

        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            LOGGER.info("Packing {}", (Object)this.task);
            final TaskOutputPacker.PackResult packResult = TaskOutputCacheCommandFactory.this.packer.pack(this.outputProperties, this.outputSnapshots, output, TaskOutputCacheCommandFactory.this.taskOutputOriginFactory.createWriter(this.task, this.taskExecutionTime));
            return new BuildCacheStoreCommand.Result(){

                public long getArtifactEntryCount() {
                    return packResult.getEntries();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LoadCommand
    implements BuildCacheLoadCommand<OriginTaskExecutionMetadata> {
        private final TaskOutputCachingBuildCacheKey cacheKey;
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final TaskInternal task;
        private final TaskProperties taskProperties;
        private final TaskOutputChangesListener taskOutputChangesListener;
        private final TaskArtifactState taskArtifactState;

        private LoadCommand(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, TaskProperties taskProperties, TaskOutputChangesListener taskOutputChangesListener, TaskArtifactState taskArtifactState) {
            this.cacheKey = cacheKey;
            this.outputProperties = outputProperties;
            this.task = task;
            this.taskProperties = taskProperties;
            this.taskOutputChangesListener = taskOutputChangesListener;
            this.taskArtifactState = taskArtifactState;
        }

        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        public BuildCacheLoadCommand.Result<OriginTaskExecutionMetadata> load(InputStream input) {
            TaskOutputPacker.UnpackResult unpackResult;
            this.taskOutputChangesListener.beforeTaskOutputChanged();
            try {
                unpackResult = TaskOutputCacheCommandFactory.this.packer.unpack(this.outputProperties, input, TaskOutputCacheCommandFactory.this.taskOutputOriginFactory.createReader(this.task));
                this.updateSnapshots(unpackResult.getSnapshots(), unpackResult.getOriginMetadata());
            }
            catch (Exception e) {
                LOGGER.warn("Cleaning outputs for {} after failed load from cache.", (Object)this.task);
                try {
                    this.cleanupOutputsAfterUnpackFailure();
                    this.taskArtifactState.afterOutputsRemovedBeforeTask();
                }
                catch (Exception eCleanup) {
                    LOGGER.warn("Unrecoverable error during cleaning up after task output unpack failure", (Throwable)eCleanup);
                    throw new UnrecoverableTaskOutputUnpackingException(String.format("Failed to unpack outputs for %s, and then failed to clean up; see log above for details", this.task), e);
                }
                throw new GradleException(String.format("Failed to unpack outputs for %s", this.task), (Throwable)e);
            }
            finally {
                this.cleanLocalState();
            }
            LOGGER.info("Unpacked output for {} from cache.", (Object)this.task);
            return new BuildCacheLoadCommand.Result<OriginTaskExecutionMetadata>(){

                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                public OriginTaskExecutionMetadata getMetadata() {
                    return unpackResult.getOriginMetadata();
                }
            };
        }

        private void updateSnapshots(ImmutableListMultimap<String, FileSnapshot> propertiesFileSnapshots, OriginTaskExecutionMetadata originMetadata) {
            ImmutableSortedMap.Builder propertySnapshotsBuilder = ImmutableSortedMap.naturalOrder();
            block4: for (ResolvedTaskOutputFilePropertySpec property : this.outputProperties) {
                String propertyName = property.getPropertyName();
                File outputFile = property.getOutputFile();
                if (outputFile == null) {
                    propertySnapshotsBuilder.put((Object)propertyName, (Object)EmptyFileCollectionSnapshot.INSTANCE);
                    continue;
                }
                ImmutableList fileSnapshots = propertiesFileSnapshots.get((Object)propertyName);
                CollectingFileCollectionSnapshotBuilder builder = new CollectingFileCollectionSnapshotBuilder(TaskFilePropertyCompareStrategy.UNORDERED, OutputPathNormalizationStrategy.getInstance(), TaskOutputCacheCommandFactory.this.stringInterner);
                for (FileSnapshot fileSnapshot : fileSnapshots) {
                    builder.collectFileSnapshot(fileSnapshot);
                }
                propertySnapshotsBuilder.put((Object)propertyName, (Object)builder.build());
                switch (property.getOutputType()) {
                    case FILE: {
                        FileSnapshot singleSnapshot = (FileSnapshot)Iterables.getOnlyElement((Iterable)fileSnapshots, null);
                        if (singleSnapshot != null) {
                            if (singleSnapshot.getType() != FileType.RegularFile) {
                                throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking property '%s', but saw a %s", propertyName, singleSnapshot.getType()));
                            }
                            TaskOutputCacheCommandFactory.this.fileSystemMirror.putFile(singleSnapshot);
                            continue block4;
                        }
                        TaskOutputCacheCommandFactory.this.fileSystemMirror.putFile(new MissingFileSnapshot(TaskOutputCacheCommandFactory.this.internedAbsolutePath(outputFile), RelativePath.EMPTY_ROOT));
                        continue block4;
                    }
                    case DIRECTORY: {
                        Collection descendants = Collections2.filter((Collection)fileSnapshots, (Predicate)EXCLUDE_ROOT_SNAPSHOTS);
                        TaskOutputCacheCommandFactory.this.fileSystemMirror.putDirectory(new DirectoryTreeDetails(TaskOutputCacheCommandFactory.this.internedAbsolutePath(outputFile), descendants));
                        continue block4;
                    }
                }
                throw new AssertionError();
            }
            this.taskArtifactState.snapshotAfterLoadedFromCache((ImmutableSortedMap<String, FileCollectionSnapshot>)propertySnapshotsBuilder.build(), originMetadata);
        }

        private void cleanLocalState() {
            for (File localStateFile : this.taskProperties.getLocalStateFiles()) {
                try {
                    this.remove(localStateFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", this.task, localStateFile), (Throwable)ex);
                }
            }
        }

        private void cleanupOutputsAfterUnpackFailure() {
            for (ResolvedTaskOutputFilePropertySpec outputProperty : this.outputProperties) {
                File outputFile = outputProperty.getOutputFile();
                try {
                    this.remove(outputFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up files for output property '%s' of %s: %s", outputProperty.getPropertyName(), this.task, outputFile), (Throwable)ex);
                }
            }
        }

        private void remove(File file) throws IOException {
            if (file != null && file.exists()) {
                if (file.isDirectory()) {
                    FileUtils.cleanDirectory((File)file);
                } else {
                    FileUtils.forceDelete((File)file);
                }
            }
        }
    }
}

