/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ModuleVersionSelectorStrictSpec;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class DefaultDependencyConstraint
implements DependencyConstraint {
    private static final Logger LOG = Logging.getLogger(DefaultDependencyConstraint.class);
    private final String group;
    private final String name;
    private final MutableVersionConstraint versionConstraint;
    private String reason;
    private ImmutableAttributesFactory attributesFactory;
    private AttributeContainerInternal attributes;

    public static DefaultDependencyConstraint strictConstraint(String group, String name, String version) {
        return new DefaultDependencyConstraint(group, name, new DefaultMutableVersionConstraint(version, true));
    }

    public DefaultDependencyConstraint(String group, String name, String version) {
        this.group = group;
        this.name = name;
        this.versionConstraint = new DefaultMutableVersionConstraint(version);
    }

    private DefaultDependencyConstraint(String group, String name, MutableVersionConstraint versionConstraint) {
        this.group = group;
        this.name = name;
        this.versionConstraint = versionConstraint;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getVersion() {
        return this.versionConstraint.getPreferredVersion();
    }

    public AttributeContainer getAttributes() {
        return this.attributes == null ? ImmutableAttributes.EMPTY : this.attributes.asImmutable();
    }

    public DependencyConstraint attributes(Action<? super AttributeContainer> configureAction) {
        if (this.attributesFactory == null) {
            this.warnAboutInternalApiUse();
            return this;
        }
        if (this.attributes == null) {
            this.attributes = this.attributesFactory.mutable();
        }
        configureAction.execute((Object)this.attributes);
        return this;
    }

    private void warnAboutInternalApiUse() {
        LOG.warn("Cannot set attributes for constraint \"" + this.getGroup() + ":" + this.getName() + ":" + this.getVersion() + "\": it was probably created by a plugin using internal APIs");
    }

    public void setAttributesFactory(ImmutableAttributesFactory attributesFactory) {
        this.attributesFactory = attributesFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDependencyConstraint that = (DefaultDependencyConstraint)o;
        return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal((Object)this.attributes, (Object)that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.group, this.name, this.versionConstraint, this.attributes});
    }

    public void version(Action<? super MutableVersionConstraint> configureAction) {
        configureAction.execute((Object)this.versionConstraint);
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public boolean matchesStrictly(ModuleVersionIdentifier identifier) {
        return new ModuleVersionSelectorStrictSpec((ModuleVersionSelector)this).isSatisfiedBy(identifier);
    }

    public String getReason() {
        return this.reason;
    }

    public void because(String reason) {
        this.reason = reason;
    }

    public DependencyConstraint copy() {
        DefaultDependencyConstraint constraint = new DefaultDependencyConstraint(this.group, this.name, this.versionConstraint);
        constraint.reason = this.reason;
        constraint.attributes = this.attributes;
        constraint.attributesFactory = this.attributesFactory;
        return constraint;
    }

    public String toString() {
        return "constraint " + this.group + ':' + this.name + ":" + this.versionConstraint + ", attributes=" + this.attributes;
    }
}

