/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.diagnostics.internal.dsl.DependencyResultSpecNotationConverter;
import org.gradle.api.tasks.diagnostics.internal.graph.DependencyGraphRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.LegendRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.NodeRenderer;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.insight.DependencyInsightReporter;
import org.gradle.api.tasks.options.Option;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.typeconversion.NotationParser;

@Incubating
public class DependencyInsightReportTask
extends DefaultTask {
    private Configuration configuration;
    private Spec<DependencyResult> dependencySpec;

    @Internal
    public Spec<DependencyResult> getDependencySpec() {
        return this.dependencySpec;
    }

    public void setDependencySpec(Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    @Option(option="dependency", description="Shows the details of given dependency.")
    public void setDependencySpec(Object dependencyInsightNotation) {
        NotationParser<Object, Spec<DependencyResult>> parser = DependencyResultSpecNotationConverter.parser();
        this.dependencySpec = (Spec)parser.parseNotation(dependencyInsightNotation);
    }

    @Internal
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Option(option="configuration", description="Looks for the dependency in given configuration.")
    public void setConfiguration(String configurationName) {
        this.configuration = this.getProject().getConfigurations().getByName(configurationName);
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionSelectorScheme getVersionSelectorScheme() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionComparator getVersionComparator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionParser getVersionParser() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void report() {
        final Configuration configuration = this.getConfiguration();
        if (configuration == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the input configuration was not specified. \nIt can be specified from the command line, e.g: '" + this.getPath() + " --configuration someConf --dependency someDep'");
        }
        if (this.dependencySpec == null) {
            throw new InvalidUserDataException("Dependency insight report cannot be generated because the dependency to show was not specified.\nIt can be specified from the command line, e.g: '" + this.getPath() + " --dependency someDep'");
        }
        StyledTextOutput output = this.getTextOutputFactory().create(((Object)((Object)this)).getClass());
        GraphRenderer renderer = new GraphRenderer(output);
        ResolutionResult result = configuration.getIncoming().getResolutionResult();
        final LinkedHashSet<DependencyResult> selectedDependencies = new LinkedHashSet<DependencyResult>();
        result.allDependencies((Action)new Action<DependencyResult>(){

            public void execute(DependencyResult dependencyResult) {
                if (DependencyInsightReportTask.this.dependencySpec.isSatisfiedBy((Object)dependencyResult)) {
                    selectedDependencies.add(dependencyResult);
                }
            }
        });
        if (selectedDependencies.isEmpty()) {
            output.println((Object)("No dependencies matching given input were found in " + String.valueOf(configuration)));
            return;
        }
        Collection<RenderableDependency> sortedDeps = new DependencyInsightReporter().prepare(selectedDependencies, this.getVersionSelectorScheme(), this.getVersionComparator(), this.getVersionParser());
        NodeRenderer nodeRenderer = new NodeRenderer(){

            @Override
            public void renderNode(StyledTextOutput target, RenderableDependency node, boolean alreadyRendered) {
                boolean leaf = node.getChildren().isEmpty();
                target.text((Object)(leaf ? configuration.getName() : node.getName()));
                if (alreadyRendered && !leaf) {
                    target.withStyle(StyledTextOutput.Style.Info).text((Object)" (*)");
                }
            }
        };
        LegendRenderer legendRenderer = new LegendRenderer(output);
        DependencyGraphRenderer dependencyGraphRenderer = new DependencyGraphRenderer(renderer, nodeRenderer, legendRenderer);
        int i = 1;
        for (RenderableDependency dependency : sortedDeps) {
            boolean last;
            renderer.visit((Action)new RenderDependencyAction(dependency, configuration), true);
            dependencyGraphRenderer.render(dependency);
            if (last = i++ == sortedDeps.size()) continue;
            output.println();
        }
        legendRenderer.printLegend();
        output.println();
        output.text((Object)"A web-based, searchable dependency report is available by adding the ");
        output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"scan"});
        output.println((Object)" option.");
    }

    private static AttributeMatchDetails match(Attribute<?> actualAttribute, Object actualValue, AttributeContainerInternal requestedAttributes) {
        for (Attribute requested : requestedAttributes.keySet()) {
            Object requestedValue = requestedAttributes.getAttribute(requested);
            if (!requested.getName().equals(actualAttribute.getName())) continue;
            if (requested.equals(actualAttribute)) {
                if (actualValue.equals(requestedValue)) {
                    return new AttributeMatchDetails(MatchType.requested, requested, requestedValue);
                }
                return new AttributeMatchDetails(MatchType.different_value, requested, requestedValue);
            }
            if (actualValue.toString().equals(requestedValue.toString())) {
                return new AttributeMatchDetails(MatchType.requested, requested, requestedValue);
            }
            return new AttributeMatchDetails(MatchType.different_value, requested, requestedValue);
        }
        return new AttributeMatchDetails(MatchType.not_requested, null, null);
    }

    private static class RenderDependencyAction
    implements Action<StyledTextOutput> {
        private final RenderableDependency dependency;
        private final Configuration configuration;

        public RenderDependencyAction(RenderableDependency dependency, Configuration configuration) {
            this.dependency = dependency;
            this.configuration = configuration;
        }

        public void execute(StyledTextOutput out) {
            out.withStyle(StyledTextOutput.Style.Identifier).text((Object)this.dependency.getName());
            if (StringUtils.isNotEmpty((String)this.dependency.getDescription())) {
                out.withStyle(StyledTextOutput.Style.Description).text((Object)(" (" + this.dependency.getDescription() + ")"));
            }
            this.printVariantDetails(out);
            switch (this.dependency.getResolutionState()) {
                case FAILED: {
                    out.withStyle(StyledTextOutput.Style.Failure).text((Object)" FAILED");
                    break;
                }
                case RESOLVED: {
                    break;
                }
                case UNRESOLVED: {
                    out.withStyle(StyledTextOutput.Style.Failure).text((Object)" (n)");
                }
            }
        }

        private void printVariantDetails(StyledTextOutput out) {
            ResolvedVariantResult resolvedVariant = this.dependency.getResolvedVariant();
            if (resolvedVariant != null) {
                out.println();
                out.withStyle(StyledTextOutput.Style.Description).text((Object)("   variant \"" + resolvedVariant.getDisplayName() + "\""));
                AttributeContainer attributes = resolvedVariant.getAttributes();
                AttributeContainerInternal requested = (AttributeContainerInternal)this.configuration.getAttributes();
                if (!attributes.isEmpty() || !requested.isEmpty()) {
                    this.writeAttributeBlock(out, attributes, requested);
                }
            }
        }

        private void writeAttributeBlock(StyledTextOutput out, AttributeContainer attributes, AttributeContainerInternal requested) {
            out.withStyle(StyledTextOutput.Style.Description).text((Object)" [");
            out.println();
            int maxAttributeLen = this.computeAttributePadding(attributes, requested);
            LinkedHashSet matchedAttributes = Sets.newLinkedHashSet();
            this.writeFoundAttributes(out, attributes, requested, maxAttributeLen, matchedAttributes);
            Sets.SetView missing = Sets.difference((Set)requested.keySet(), (Set)matchedAttributes);
            if (!missing.isEmpty()) {
                this.writeMissingAttributes(out, requested, maxAttributeLen, missing);
            }
            out.withStyle(StyledTextOutput.Style.Description).text((Object)"   ]");
        }

        private void writeMissingAttributes(StyledTextOutput out, AttributeContainerInternal requested, int maxAttributeLen, Sets.SetView<Attribute<?>> missing) {
            if (missing.size() != requested.keySet().size()) {
                out.println();
            }
            out.withStyle(StyledTextOutput.Style.Description).text((Object)"      Requested attributes not found in the selected variant:");
            out.println();
            for (Attribute missingAttribute : missing) {
                out.withStyle(StyledTextOutput.Style.Description).text((Object)("         " + StringUtils.rightPad((String)missingAttribute.getName(), (int)maxAttributeLen) + " = " + requested.getAttribute(missingAttribute)));
                out.println();
            }
        }

        private void writeFoundAttributes(StyledTextOutput out, AttributeContainer attributes, AttributeContainerInternal requested, int maxAttributeLen, Set<Attribute<?>> matchedAttributes) {
            for (Attribute attribute : attributes.keySet()) {
                Object actualValue = attributes.getAttribute(attribute);
                AttributeMatchDetails match = DependencyInsightReportTask.match(attribute, actualValue, requested);
                out.withStyle(StyledTextOutput.Style.Description).text((Object)("      " + StringUtils.rightPad((String)attribute.getName(), (int)maxAttributeLen) + " = " + actualValue));
                Attribute requestedAttribute = match.requested;
                if (requestedAttribute != null) {
                    matchedAttributes.add(requestedAttribute);
                }
                switch (match.matchType) {
                    case requested: {
                        break;
                    }
                    case different_value: {
                        out.withStyle(StyledTextOutput.Style.Info).text((Object)(" (compatible with: " + match.requestedValue + ")"));
                        break;
                    }
                    case not_requested: {
                        out.withStyle(StyledTextOutput.Style.Info).text((Object)" (not requested)");
                    }
                }
                out.println();
            }
        }

        private int computeAttributePadding(AttributeContainer attributes, AttributeContainerInternal requested) {
            int maxAttributeLen = 0;
            for (Attribute attribute : requested.keySet()) {
                maxAttributeLen = Math.max(maxAttributeLen, attribute.getName().length());
            }
            for (Attribute attribute : attributes.keySet()) {
                maxAttributeLen = Math.max(maxAttributeLen, attribute.getName().length());
            }
            return maxAttributeLen;
        }
    }

    private static enum MatchType {
        requested,
        different_value,
        not_requested;

    }

    private static class AttributeMatchDetails {
        private final MatchType matchType;
        private final Attribute<?> requested;
        private final Object requestedValue;

        private AttributeMatchDetails(MatchType matchType, Attribute<?> requested, Object requestedValue) {
            this.matchType = matchType;
            this.requested = requested;
            this.requestedValue = requestedValue;
        }
    }
}

