/*
 * Decompiled with CFR 0.152.
 */
package javaslang.control;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import javaslang.Value;
import javaslang.collection.Iterator;

public interface Validation<E, T>
extends Serializable,
Value<T> {
    public boolean isValid();

    public boolean isInvalid();

    @Override
    default public boolean isEmpty() {
        return this.isInvalid();
    }

    @Override
    public T get();

    @Override
    public String toString();

    @Override
    default public void forEach(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (this.isValid()) {
            action2.accept(this.get());
        }
    }

    @Override
    default public boolean isSingleValued() {
        return true;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.isValid() ? Iterator.of(this.get()) : Iterator.empty();
    }
}

