/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.ThreadDumper;
import org.jetbrains.kotlin.com.intellij.extapi.psi.ASTDelegatePsiElement;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.lang.ASTFactory;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageParserDefinitions;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.TreeChangeEvent;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import org.jetbrains.kotlin.com.intellij.pom.tree.events.impl.ReplaceChangeInfoImpl;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.FreeThreadedFileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolder;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.DummyHolderFactory;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.AstBufferUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.AstPath;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChangeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.FileElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseableElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.SharedImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IStubElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.text.StringFactory;

public class CompositeElement
extends TreeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.CompositeElement");
    public static final CompositeElement[] EMPTY_ARRAY = new CompositeElement[0];
    private TreeElement firstChild;
    private TreeElement lastChild;
    private volatile int myCachedLength;
    private volatile int myHC;
    private volatile PsiElement myWrapper;
    private static final AtomicFieldUpdater<CompositeElement, PsiElement> ourPsiUpdater = AtomicFieldUpdater.forFieldOfType(CompositeElement.class, PsiElement.class);

    public CompositeElement(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(0);
        }
        super(type2);
        this.myCachedLength = -1;
        this.myHC = -1;
    }

    @Override
    @NotNull
    public CompositeElement clone() {
        CompositeElement clone = (CompositeElement)super.clone();
        clone.firstChild = null;
        clone.lastChild = null;
        clone.myWrapper = null;
        for (ASTNode child = this.rawFirstChild(); child != null; child = child.getTreeNext()) {
            clone.rawAddChildrenWithoutNotifications((TreeElement)child.clone());
        }
        clone.clearCaches();
        CompositeElement compositeElement = clone;
        if (compositeElement == null) {
            CompositeElement.$$$reportNull$$$0(1);
        }
        return compositeElement;
    }

    public void subtreeChanged() {
        for (CompositeElement compositeElement = this; compositeElement != null; compositeElement = compositeElement.getTreeParent()) {
            compositeElement.clearCaches();
            if (compositeElement instanceof PsiElement) continue;
            PsiElement psi = compositeElement.myWrapper;
            if (psi instanceof ASTDelegatePsiElement) {
                ((ASTDelegatePsiElement)psi).subtreeChanged();
                continue;
            }
            if (!(psi instanceof PsiFile)) continue;
            ((PsiFile)psi).subtreeChanged();
            CompositeElement.assertThreading((PsiFile)psi);
        }
    }

    @Override
    public void clearCaches() {
        this.myCachedLength = -1;
        this.myHC = -1;
        CompositeElement.clearRelativeOffsets(this.rawFirstChild());
    }

    private static void assertThreading(@NotNull PsiFile file2) {
        boolean ok;
        if (file2 == null) {
            CompositeElement.$$$reportNull$$$0(2);
        }
        boolean bl = ok = ApplicationManager.getApplication().isWriteAccessAllowed() || CompositeElement.isNonPhysicalOrInjected(file2);
        if (!ok) {
            LOG.error("Threading assertion. " + CompositeElement.getThreadingDiagnostics(file2));
        }
    }

    private static String getThreadingDiagnostics(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(3);
        }
        return "psiFile: " + psiFile + "; psiFile.getViewProvider(): " + psiFile.getViewProvider() + "; psiFile.isPhysical(): " + psiFile.isPhysical() + "; nonPhysicalOrInjected: " + CompositeElement.isNonPhysicalOrInjected(psiFile);
    }

    private static boolean isNonPhysicalOrInjected(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CompositeElement.$$$reportNull$$$0(4);
        }
        return psiFile instanceof DummyHolder || psiFile.getViewProvider() instanceof FreeThreadedFileViewProvider || !psiFile.isPhysical();
    }

    @Override
    public void acceptTree(TreeElementVisitor visitor2) {
        visitor2.visitComposite(this);
    }

    @Override
    public LeafElement findLeafElementAt(int offset2) {
        TreeElement element = this;
        if (element.getTreeParent() == null && offset2 >= element.getTextLength()) {
            return null;
        }
        block0: while (true) {
            boolean fwd;
            TreeElement child = ((TreeElement)element).getFirstChildNode();
            TreeElement lastChild = ((TreeElement)element).getLastChildNode();
            int elementTextLength = element.getTextLength();
            boolean bl = fwd = lastChild == null || elementTextLength / 2 > offset2;
            if (!fwd) {
                child = lastChild;
                offset2 = elementTextLength - offset2;
            }
            while (child != null) {
                int textLength = child.getTextLength();
                if (textLength > offset2 || !fwd && textLength >= offset2) {
                    if (child instanceof LeafElement) {
                        if (child instanceof ForeignLeafPsiElement) {
                            child = fwd ? child.getTreeNext() : child.getTreePrev();
                            continue;
                        }
                        return (LeafElement)child;
                    }
                    offset2 = fwd ? offset2 : textLength - offset2;
                    element = child;
                    continue block0;
                }
                offset2 -= textLength;
                child = fwd ? child.getTreeNext() : child.getTreePrev();
            }
            break;
        }
        return null;
    }

    @Nullable
    public PsiElement findPsiChildByType(IElementType type2) {
        ASTNode node = this.findChildByType(type2);
        return node == null ? null : node.getPsi();
    }

    @Nullable
    public PsiElement findPsiChildByType(TokenSet types) {
        ASTNode node = this.findChildByType(types);
        return node == null ? null : node.getPsi();
    }

    @Override
    public ASTNode findChildByType(IElementType type2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (element.getElementType() != type2) continue;
            return element;
        }
        return null;
    }

    public ASTNode findChildByType(IElementType type2, ASTNode anchor2) {
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, type2);
    }

    @Override
    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet types) {
        if (types == null) {
            CompositeElement.$$$reportNull$$$0(5);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        for (ASTNode element = this.getFirstChildNode(); element != null; element = element.getTreeNext()) {
            if (!types.contains(element.getElementType())) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, ASTNode anchor2) {
        if (typesSet == null) {
            CompositeElement.$$$reportNull$$$0(6);
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        return TreeUtil.findSibling(anchor2, typesSet);
    }

    @Override
    @NotNull
    public String getText() {
        String string = StringFactory.createShared(this.textToCharArray());
        if (string == null) {
            CompositeElement.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        String string = this.getText();
        if (string == null) {
            CompositeElement.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public int getNotCachedLength() {
        final int[] result2 = new int[]{0};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(false){

            @Override
            protected void visitNode(TreeElement element) {
                if (element instanceof LeafElement || TreeUtil.isCollapsedChameleon(element)) {
                    result2[0] = result2[0] + element.getNotCachedLength();
                }
                super.visitNode(element);
            }
        });
        return result2[0];
    }

    @Override
    @NotNull
    public char[] textToCharArray() {
        int endOffset;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int len = this.getTextLength();
        char[] buffer = new char[len];
        try {
            endOffset = AstBufferUtil.toBuffer(this, buffer, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String msg = "Underestimated text length: " + len;
            try {
                int length = AstBufferUtil.toBuffer(this, new char[len], 0);
                msg = msg + ";\n repetition gives success (" + length + ")";
            }
            catch (ArrayIndexOutOfBoundsException e1) {
                msg = msg + ";\n repetition fails as well";
            }
            throw new RuntimeException(msg, e);
        }
        if (endOffset != len) {
            String msg = "len=" + len + ";\n endOffset=" + endOffset;
            msg = msg + this.diagnoseTextInconsistency(new String(buffer, 0, Math.min(len, endOffset)));
            throw new AssertionError((Object)msg);
        }
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(9);
        }
        return buffer;
    }

    private String diagnoseTextInconsistency(String text2) {
        PsiElement psi;
        String msg = "";
        msg = msg + ";\n nonPhysicalOrInjected=" + CompositeElement.isNonPhysicalOrInjected(SharedImplUtil.getContainingFile(this));
        msg = msg + ";\n buffer=" + text2;
        try {
            msg = msg + ";\n this=" + this;
        }
        catch (StackOverflowError e) {
            msg = msg + ";\n this.toString produces SOE";
        }
        int shitStart = this.textMatches(text2, 0);
        msg = msg + ";\n matches until " + shitStart;
        LeafElement leaf = this.findLeafElementAt(Math.abs(shitStart));
        msg = msg + ";\n element there=" + leaf;
        if (leaf != null) {
            psi = leaf.getPsi();
            msg = msg + ";\n leaf.text=" + leaf.getText();
            msg = msg + ";\n leaf.psi=" + psi;
            msg = msg + ";\n leaf.lang=" + (psi == null ? null : psi.getLanguage());
            msg = msg + ";\n leaf.type=" + leaf.getElementType();
        }
        if ((psi = this.getPsi()) != null) {
            PsiFile file2;
            boolean valid = psi.isValid();
            msg = msg + ";\n psi.valid=" + valid;
            if (valid && (file2 = psi.getContainingFile()) != null) {
                msg = msg + ";\n psi.file=" + file2;
                msg = msg + ";\n psi.file.tl=" + file2.getTextLength();
                msg = msg + ";\n psi.file.lang=" + file2.getLanguage();
                msg = msg + ";\n psi.file.vp=" + file2.getViewProvider();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                msg = msg + ";\n psi.file.vp.lang=" + file2.getViewProvider().getLanguages();
                PsiElement fileLeaf = file2.findElementAt(this.getTextRange().getStartOffset());
                LeafElement myLeaf = this.findLeafElementAt(0);
                msg = msg + ";\n leaves at start=" + fileLeaf + " and " + myLeaf;
            }
        }
        return msg;
    }

    @Override
    public boolean textContains(char c) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!child.textContains(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int textMatches(final @NotNull CharSequence buffer, int start) {
        if (buffer == null) {
            CompositeElement.$$$reportNull$$$0(10);
        }
        final int[] curOffset = new int[]{start};
        this.acceptTree(new RecursiveTreeElementWalkingVisitor(){

            @Override
            public void visitLeaf(LeafElement leaf) {
                this.matchText(leaf);
            }

            private void matchText(TreeElement leaf) {
                curOffset[0] = leaf.textMatches(buffer, curOffset[0]);
                if (curOffset[0] < 0) {
                    this.stopWalking();
                }
            }

            @Override
            public void visitComposite(CompositeElement composite) {
                if (composite instanceof LazyParseableElement && !((LazyParseableElement)composite).isParsed()) {
                    this.matchText(composite);
                } else {
                    super.visitComposite(composite);
                }
            }
        });
        return curOffset[0];
    }

    @Nullable
    public final PsiElement findChildByRoleAsPsiElement(int role) {
        ASTNode element = this.findChildByRole(role);
        if (element == null) {
            return null;
        }
        return SourceTreeToPsiMap.treeElementToPsi(element);
    }

    @Nullable
    public ASTNode findChildByRole(int role) {
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.getChildRole(child) != role) continue;
            return child;
        }
        return null;
    }

    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this, child);
        return 0;
    }

    protected final int getChildRole(ASTNode child, int roleCandidate) {
        if (this.findChildByRole(roleCandidate) == child) {
            return roleCandidate;
        }
        return 0;
    }

    @Override
    @NotNull
    public ASTNode[] getChildren(@Nullable TokenSet filter2) {
        int count2 = this.countChildren(filter2);
        if (count2 == 0) {
            if (EMPTY_ARRAY == null) {
                CompositeElement.$$$reportNull$$$0(11);
            }
            return EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count2];
        count2 = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child.getElementType())) continue;
            result2[count2++] = child;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(12);
        }
        return result2;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@Nullable TokenSet filter2, ArrayFactory<T> constructor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count2 = this.countChildren(filter2);
        PsiElement[] result2 = (PsiElement[])constructor.create(count2);
        if (count2 == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(13);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count2; child = child.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child.getElementType())) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result2[idx++] = element;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(14);
        }
        return result2;
    }

    @NotNull
    public <T extends PsiElement> T[] getChildrenAsPsiElements(@NotNull IElementType type2, ArrayFactory<T> constructor) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int count2 = this.countChildren(type2);
        PsiElement[] result2 = (PsiElement[])constructor.create(count2);
        if (count2 == 0) {
            if (result2 == null) {
                CompositeElement.$$$reportNull$$$0(16);
            }
            return result2;
        }
        int idx = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null && idx < count2; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            PsiElement element = child.getPsi();
            LOG.assertTrue(element != null, child);
            result2[idx++] = element;
        }
        if (result2 == null) {
            CompositeElement.$$$reportNull$$$0(17);
        }
        return result2;
    }

    public int countChildren(@Nullable TokenSet filter2) {
        int count2 = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (filter2 != null && !filter2.contains(child.getElementType())) continue;
            ++count2;
        }
        return count2;
    }

    private int countChildren(@NotNull IElementType type2) {
        if (type2 == null) {
            CompositeElement.$$$reportNull$$$0(18);
        }
        int count2 = 0;
        for (ASTNode child = this.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (type2 != child.getElementType()) continue;
            ++count2;
        }
        return count2;
    }

    public TreeElement addInternal(TreeElement first2, ASTNode last2, ASTNode anchor2, Boolean before) {
        ASTNode anchorBefore = anchor2 != null ? (before != false ? anchor2 : anchor2.getTreeNext()) : (before == null || before != false ? null : this.getFirstChildNode());
        return (TreeElement)CodeEditUtil.addChildren(this, first2, last2, anchorBefore);
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(19);
        }
        CodeEditUtil.removeChild(this, child);
    }

    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(20);
        }
        if (newElement == null) {
            CompositeElement.$$$reportNull$$$0(21);
        }
        CodeEditUtil.replaceChild(this, child, newElement);
    }

    @Override
    public int getTextLength() {
        int cachedLength = this.myCachedLength;
        if (cachedLength >= 0) {
            return cachedLength;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        try {
            return this.walkCachingLength();
        }
        catch (AssertionError e) {
            this.myCachedLength = -1;
            String assertion = StringUtil.getThrowableText((Throwable)((Object)e));
            throw new AssertionError((Object)("Walking failure: ===\n" + assertion + "\n=== Thread dump:\n" + ThreadDumper.dumpThreadsToString() + "\n===\n"));
        }
    }

    @Override
    public int hc() {
        int hc = this.myHC;
        if (hc == -1) {
            hc = 0;
            for (TreeElement child = this.firstChild; child != null; child = child.getTreeNext()) {
                hc += child.hc();
            }
            this.myHC = hc;
        }
        return hc;
    }

    @Override
    public int getCachedLength() {
        return this.myCachedLength;
    }

    @NotNull
    private static TreeElement drillDown(@NotNull TreeElement start) {
        TreeElement child;
        if (start == null) {
            CompositeElement.$$$reportNull$$$0(22);
        }
        TreeElement cur = start;
        while (cur.getCachedLength() < 0 && (child = cur.getFirstChildNode()) != null) {
            cur = child;
        }
        TreeElement treeElement = cur;
        if (treeElement == null) {
            CompositeElement.$$$reportNull$$$0(23);
        }
        return treeElement;
    }

    private int walkCachingLength() {
        TreeElement cur = CompositeElement.drillDown(this);
        while (true) {
            int length;
            if ((length = cur.getCachedLength()) < 0) {
                length = 0;
                for (TreeElement child = cur.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                    length += child.getTextLength();
                }
                ((CompositeElement)cur).setCachedLength(length);
            }
            if (cur == this) {
                return length;
            }
            TreeElement next = cur.getTreeNext();
            cur = next != null ? CompositeElement.drillDown(next) : CompositeElement.getNotNullParent(cur);
        }
    }

    private static TreeElement getNotNullParent(TreeElement cur) {
        CompositeElement parent2 = cur.getTreeParent();
        if (parent2 == null) {
            CompositeElement.diagnoseNullParent(cur);
        }
        return parent2;
    }

    private static void diagnoseNullParent(TreeElement cur) {
        PsiElement psi = cur.getPsi();
        if (psi != null) {
            PsiUtilCore.ensureValid(psi);
        }
        throw new IllegalStateException("Null parent of " + cur + " " + cur.getClass());
    }

    void setCachedLength(int cachedLength) {
        this.myCachedLength = cachedLength;
    }

    @Override
    public TreeElement getFirstChildNode() {
        return this.firstChild;
    }

    @Override
    public TreeElement getLastChildNode() {
        return this.lastChild;
    }

    void setFirstChildNode(TreeElement firstChild) {
        this.firstChild = firstChild;
        CompositeElement.clearRelativeOffsets(firstChild);
    }

    void setLastChildNode(TreeElement lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public void addChild(@NotNull ASTNode child, final @Nullable ASTNode anchorBefore) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(24);
        }
        LOG.assertTrue(anchorBefore == null || ((TreeElement)anchorBefore).getTreeParent() == this, "anchorBefore == null || anchorBefore.getTreeParent() == parent");
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(child);
        TreeElement last2 = ((TreeElement)child).getTreeNext();
        final TreeElement first2 = (TreeElement)child;
        CompositeElement.removeChildrenInner(first2, last2);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                if (anchorBefore != null) {
                    CompositeElement.insertBefore(destinationTreeChange, (TreeElement)anchorBefore, first2);
                } else {
                    CompositeElement.add(destinationTreeChange, CompositeElement.this, first2);
                }
            }
        }, this);
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, ASTNode anchorBefore) {
        if (leafType == null) {
            CompositeElement.$$$reportNull$$$0(25);
        }
        FileElement holder = new DummyHolder(this.getManager(), null).getTreeElement();
        LeafElement leaf = ASTFactory.leaf(leafType, holder.getCharTable().intern(leafText));
        CodeEditUtil.setNodeGenerated(leaf, true);
        holder.rawAddChildren(leaf);
        this.addChild(leaf, anchorBefore);
    }

    public void addChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(26);
        }
        this.addChild(child, null);
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            CompositeElement.$$$reportNull$$$0(27);
        }
        CompositeElement.removeChildInner((TreeElement)child);
    }

    @Override
    public void removeRange(@NotNull ASTNode first2, ASTNode firstWhichStayInTree) {
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(28);
        }
        CompositeElement.removeChildrenInner((TreeElement)first2, (TreeElement)firstWhichStayInTree);
    }

    @Override
    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        if (oldChild == null) {
            CompositeElement.$$$reportNull$$$0(29);
        }
        if (newChild == null) {
            CompositeElement.$$$reportNull$$$0(30);
        }
        LOG.assertTrue(((TreeElement)oldChild).getTreeParent() == this);
        final TreeElement oldChild1 = (TreeElement)oldChild;
        TreeElement newChildNext = ((TreeElement)newChild).getTreeNext();
        final TreeElement newChild1 = (TreeElement)newChild;
        if (oldChild1 == newChild1) {
            return;
        }
        CompositeElement.removeChildrenInner(newChild1, newChildNext);
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                CompositeElement.replace(destinationTreeChange, oldChild1, newChild1);
                CompositeElement.repairRemovedElement(CompositeElement.this, oldChild1);
            }
        }, this);
    }

    @Override
    public void replaceAllChildrenToChildrenOf(final ASTNode anotherParent) {
        TreeUtil.ensureParsed(this.getFirstChildNode());
        TreeUtil.ensureParsed(anotherParent.getFirstChildNode());
        final ASTNode firstChild = anotherParent.getFirstChildNode();
        ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

            @Override
            public void makeChange(TreeChangeEvent destinationTreeChange) {
                destinationTreeChange.addElementaryChange(anotherParent, ChangeInfoImpl.create((short)3, anotherParent));
                ((CompositeElement)anotherParent).rawRemoveAllChildren();
            }
        }, (TreeElement)anotherParent);
        if (firstChild != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    if (CompositeElement.this.getTreeParent() != null) {
                        ChangeInfoImpl changeInfo = ChangeInfoImpl.create((short)3, CompositeElement.this);
                        changeInfo.setOldLength(CompositeElement.this.getTextLength());
                        destinationTreeChange.addElementaryChange(CompositeElement.this, changeInfo);
                        CompositeElement.this.rawRemoveAllChildren();
                        CompositeElement.this.rawAddChildren((TreeElement)firstChild);
                    } else {
                        TreeElement first2 = CompositeElement.this.getFirstChildNode();
                        CompositeElement.remove(destinationTreeChange, first2, null);
                        CompositeElement.add(destinationTreeChange, CompositeElement.this, (TreeElement)firstChild);
                        CompositeElement.repairRemovedElement(CompositeElement.this, first2);
                    }
                }
            }, this);
        } else {
            this.removeAllChildren();
        }
    }

    public void removeAllChildren() {
        TreeElement child = this.getFirstChildNode();
        if (child != null) {
            this.removeRange(child, null);
        }
    }

    @Override
    public void addChildren(ASTNode firstChild, ASTNode lastChild, ASTNode anchorBefore) {
        while (firstChild != lastChild) {
            ASTNode next1 = firstChild.getTreeNext();
            this.addChild(firstChild, anchorBefore);
            firstChild = next1;
        }
    }

    @Nullable
    public final PsiElement getCachedPsi() {
        return this.myWrapper;
    }

    @Override
    public final PsiElement getPsi() {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement wrapper = this.myWrapper;
        if (wrapper != null) {
            return wrapper;
        }
        wrapper = this.obtainStubBasedPsi();
        if (wrapper == null) {
            wrapper = this.createPsiNoLock();
        }
        return ourPsiUpdater.compareAndSet(this, null, wrapper) ? wrapper : ObjectUtils.assertNotNull(this.myWrapper);
    }

    @Nullable
    private PsiElement obtainStubBasedPsi() {
        AstPath path2 = this.getElementType() instanceof IStubElementType ? AstPath.getNodePath(this) : null;
        return path2 == null ? null : path2.getContainingFile().obtainPsi(path2, () -> (StubBasedPsiElementBase)this.createPsiNoLock());
    }

    @Override
    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        if (clazz == null) {
            CompositeElement.$$$reportNull$$$0(31);
        }
        return LeafElement.getPsi(clazz, this.getPsi(), LOG);
    }

    protected PsiElement createPsiNoLock() {
        Language lang = this.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(lang);
        if (parserDefinition != null) {
            return parserDefinition.createElement(this);
        }
        return null;
    }

    public void setPsi(@NotNull PsiElement psi) {
        if (psi == null) {
            CompositeElement.$$$reportNull$$$0(32);
        }
        this.myWrapper = psi;
    }

    protected void clearPsi() {
        this.myWrapper = null;
    }

    public final void rawAddChildren(@NotNull TreeElement first2) {
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(33);
        }
        this.rawAddChildrenWithoutNotifications(first2);
        this.subtreeChanged();
    }

    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first2) {
        PsiFileImpl file2;
        if (first2 == null) {
            CompositeElement.$$$reportNull$$$0(34);
        }
        if (DebugUtil.DO_EXPENSIVE_CHECKS && !(this instanceof LazyParseableElement) && (file2 = CompositeElement.getCachedFile(this)) != null && !file2.useStrongRefs()) {
            throw new AssertionError((Object)"Attempt to modify PSI in a file with weakly-referenced AST. Possible cause: missing PomTransaction.");
        }
        TreeElement last2 = this.getLastChildNode();
        if (last2 == null) {
            first2.rawRemoveUpToWithoutNotifications(null, false);
            this.setFirstChildNode(first2);
            while (true) {
                TreeElement treeNext = first2.getTreeNext();
                first2.setTreeParent(this);
                if (treeNext == null) break;
                first2 = treeNext;
            }
            this.setLastChildNode(first2);
            first2.setTreeParent(this);
        } else {
            last2.rawInsertAfterMeWithoutNotifications(first2);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemoveAllChildren() {
        TreeElement first2 = this.getFirstChildNode();
        if (first2 != null) {
            first2.rawRemoveUpToLast();
        }
    }

    private static void repairRemovedElement(CompositeElement oldParent, TreeElement oldChild) {
        if (oldChild == null) {
            return;
        }
        FileElement treeElement = DummyHolderFactory.createHolder((PsiManager)oldParent.getManager(), null, false).getTreeElement();
        treeElement.rawAddChildren(oldChild);
    }

    private static void add(TreeChangeEvent destinationTreeChange, CompositeElement parent2, TreeElement first2) {
        parent2.rawAddChildren(first2);
        for (TreeElement child = first2; child != null; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void remove(TreeChangeEvent destinationTreeChange, TreeElement first2, TreeElement last2) {
        if (first2 != null) {
            for (TreeElement child = first2; child != last2 && child != null; child = child.getTreeNext()) {
                destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)1, child));
            }
            first2.rawRemoveUpTo(last2);
        }
    }

    private static void insertBefore(TreeChangeEvent destinationTreeChange, TreeElement anchorBefore, TreeElement first2) {
        anchorBefore.rawInsertBeforeMe(first2);
        for (TreeElement child = first2; child != anchorBefore; child = child.getTreeNext()) {
            destinationTreeChange.addElementaryChange(child, ChangeInfoImpl.create((short)0, child));
        }
    }

    private static void replace(TreeChangeEvent sourceTreeChange, TreeElement oldChild, TreeElement newChild) {
        oldChild.rawReplaceWithList(newChild);
        ReplaceChangeInfoImpl change = new ReplaceChangeInfoImpl(newChild);
        sourceTreeChange.addElementaryChange(newChild, change);
        change.setReplaced(oldChild);
    }

    private static void removeChildInner(TreeElement child) {
        CompositeElement.removeChildrenInner(child, child.getTreeNext());
    }

    private static void removeChildrenInner(final TreeElement first2, final TreeElement last2) {
        final FileElement fileElement = TreeUtil.getFileElement(first2);
        if (fileElement != null) {
            ChangeUtil.prepareAndRunChangeAction(new ChangeUtil.ChangeAction(){

                @Override
                public void makeChange(TreeChangeEvent destinationTreeChange) {
                    CompositeElement.remove(destinationTreeChange, first2, last2);
                    CompositeElement.repairRemovedElement((CompositeElement)fileElement, first2);
                }
            }, first2.getTreeParent());
        } else {
            first2.rawRemoveUpTo(last2);
        }
    }

    public TreeElement rawFirstChild() {
        return this.firstChild;
    }

    public TreeElement rawLastChild() {
        return this.lastChild;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesSet";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 19: 
            case 20: 
            case 24: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafType";
                break;
            }
            case 28: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldChild";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/CompositeElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "textToCharArray";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenAsPsiElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "drillDown";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertThreading";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getThreadingDiagnostics";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isNonPhysicalOrInjected";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenAsPsiElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "countChildren";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "replaceChildInternal";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "drillDown";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addLeaf";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeRange";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "replaceChild";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPsi";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildren";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

