/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.MenuComponent;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.openstreetmap.josm.actions.AddImageryLayerAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.MapRectifierWMSmenuAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ImageryMenu
extends JMenu
implements LayerManager.LayerChangeListener {
    public static final Comparator<ImageryInfo> alphabeticImageryComparator = (ii1, ii2) -> ii1.getName().toLowerCase(Locale.ENGLISH).compareTo(ii2.getName().toLowerCase(Locale.ENGLISH));
    private final transient Action offsetAction = new AdjustImageryOffsetAction();
    private final JMenuItem singleOffset;
    private JMenuItem offsetMenuItem = this.singleOffset = new JMenuItem(this.offsetAction);
    private final MapRectifierWMSmenuAction rectaction = new MapRectifierWMSmenuAction();
    private final List<Object> dynamicItems = new ArrayList<Object>(20);

    public ImageryMenu(JMenu subMenu) {
        super(I18n.trc("menu", "Imagery"));
        this.setupMenuScroller();
        MainApplication.getLayerManager().addLayerChangeListener(this);
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ImageryMenu.this.refreshImageryMenu();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        MainMenu.add(subMenu, this.rectaction);
    }

    private void setupMenuScroller() {
        if (!GraphicsEnvironment.isHeadless()) {
            MenuScroller.setScrollerFor(this, 150, 2);
        }
    }

    public void refreshImageryMenu() {
        this.removeDynamicItems();
        this.addDynamic(this.offsetMenuItem);
        this.addDynamicSeparator();
        ArrayList<ImageryInfo> savedLayers = new ArrayList<ImageryInfo>(ImageryLayerInfo.instance.getLayers());
        savedLayers.sort(alphabeticImageryComparator);
        for (ImageryInfo u : savedLayers) {
            this.addDynamic(new AddImageryLayerAction(u));
        }
        if (MainApplication.isDisplayingMapView()) {
            MapView mv = MainApplication.getMap().mapView;
            LatLon pos = mv.getProjection().eastNorth2latlon(mv.getCenter());
            ArrayList<ImageryInfo> inViewLayers = new ArrayList<ImageryInfo>();
            for (ImageryInfo i : ImageryLayerInfo.instance.getDefaultLayers()) {
                if (i.getBounds() == null || !i.getBounds().contains(pos)) continue;
                inViewLayers.add(i);
            }
            inViewLayers.removeAll(ImageryLayerInfo.instance.getLayers());
            Iterator iti = inViewLayers.iterator();
            while (iti.hasNext()) {
                List<Shape> shapes = ((ImageryInfo)iti.next()).getBounds().getShapes();
                if (shapes == null || shapes.isEmpty()) continue;
                boolean found = false;
                Iterator<Shape> its = shapes.iterator();
                while (its.hasNext() && !found) {
                    found = its.next().contains(pos);
                }
                if (found) continue;
                iti.remove();
            }
            if (!inViewLayers.isEmpty()) {
                inViewLayers.sort(alphabeticImageryComparator);
                this.addDynamicSeparator();
                for (ImageryInfo i : inViewLayers) {
                    this.addDynamic(new AddImageryLayerAction(i));
                }
            }
        }
        this.addDynamicSeparator();
        JMenu subMenu = MainApplication.getMenu().imagerySubMenu;
        int heightUnrolled = 30 * (this.getItemCount() + subMenu.getItemCount());
        if (heightUnrolled < MainApplication.getMainPanel().getHeight()) {
            int n = subMenu.getItemCount();
            for (int i = 0; i < n; ++i) {
                this.addDynamic(subMenu.getItem(i).getAction());
            }
        } else {
            this.addDynamic(subMenu);
        }
    }

    private JMenuItem getNewOffsetMenu() {
        List<ImageryLayer> layers = MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class);
        if (layers.isEmpty()) {
            this.offsetAction.setEnabled(false);
            return this.singleOffset;
        }
        this.offsetAction.setEnabled(true);
        JMenu newMenu = new JMenu(I18n.trc("layer", "Offset"));
        newMenu.setIcon(ImageProvider.get("mapmode", "adjustimg"));
        newMenu.setAction(this.offsetAction);
        if (layers.size() == 1) {
            return (JMenuItem)((ImageryLayer)layers.iterator().next()).getOffsetMenuItem(newMenu);
        }
        for (ImageryLayer layer : layers) {
            JMenuItem layerMenu = layer.getOffsetMenuItem();
            layerMenu.setText(layer.getName());
            layerMenu.setIcon(layer.getIcon());
            newMenu.add(layerMenu);
        }
        return newMenu;
    }

    public void refreshOffsetMenu() {
        this.offsetMenuItem = this.getNewOffsetMenu();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
        if (e.getAddedLayer() instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof ImageryLayer) {
            this.refreshOffsetMenu();
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        this.refreshOffsetMenu();
    }

    private void removeDynamicItems() {
        for (Object item : this.dynamicItems) {
            if (item instanceof JMenuItem) {
                Optional.ofNullable(((JMenuItem)item).getAction()).ifPresent(MainApplication.getToolbar()::unregister);
                this.remove((JMenuItem)item);
                continue;
            }
            if (item instanceof MenuComponent) {
                this.remove((MenuComponent)item);
                continue;
            }
            if (!(item instanceof Component)) continue;
            this.remove((Component)item);
        }
        this.dynamicItems.clear();
    }

    private void addDynamicSeparator() {
        JPopupMenu.Separator s = new JPopupMenu.Separator();
        this.dynamicItems.add(s);
        this.add(s);
    }

    private void addDynamic(Action a) {
        this.dynamicItems.add(this.add(a));
    }

    private void addDynamic(JMenuItem it) {
        this.dynamicItems.add(this.add(it));
    }

    static final class AdjustImageryOffsetAction
    extends JosmAction {
        AdjustImageryOffsetAction() {
            super(I18n.tr("Imagery offset", new Object[0]), "mapmode/adjustimg", I18n.tr("Adjust imagery offset", new Object[0]), null, false, false);
            this.putValue("toolbar", "imagery-offset");
            MainApplication.getToolbar().register(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<ImageryLayer> layers = MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class);
            if (layers.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            Component source = null;
            if (e.getSource() instanceof Component) {
                source = (Component)e.getSource();
            }
            JPopupMenu popup = new JPopupMenu();
            if (layers.size() == 1) {
                JComponent c = ((ImageryLayer)layers.iterator().next()).getOffsetMenuItem(popup);
                if (c instanceof JMenuItem) {
                    ((JMenuItem)c).getAction().actionPerformed(e);
                } else {
                    if (source == null) {
                        return;
                    }
                    popup.show(source, source.getWidth() / 2, source.getHeight() / 2);
                }
                return;
            }
            if (source == null || !source.isShowing()) {
                return;
            }
            for (ImageryLayer layer : layers) {
                JMenuItem layerMenu = layer.getOffsetMenuItem();
                layerMenu.setText(layer.getName());
                layerMenu.setIcon(layer.getIcon());
                popup.add(layerMenu);
            }
            popup.show(source, source.getWidth() / 2, source.getHeight() / 2);
        }
    }
}

