/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.tools.Utils;

public abstract class AbstractCopyAction
extends AbstractAction {
    private final JTable tagTable;
    private final IntFunction<String> keySupplier;
    private final Supplier<Collection<? extends Tagged>> objectSupplier;

    public AbstractCopyAction(JTable tagTable, IntFunction<String> keySupplier, Supplier<Collection<? extends Tagged>> objectSupplier) {
        this.tagTable = Objects.requireNonNull(tagTable);
        this.keySupplier = Objects.requireNonNull(keySupplier);
        this.objectSupplier = Objects.requireNonNull(objectSupplier);
    }

    protected abstract Collection<String> getString(Tagged var1, String var2);

    @Override
    public void actionPerformed(ActionEvent ae) {
        int[] rows = this.tagTable.getSelectedRows();
        TreeSet<String> values = new TreeSet<String>();
        Collection<? extends Tagged> sel = this.objectSupplier.get();
        if (rows.length == 0 || sel.isEmpty()) {
            return;
        }
        for (int row : rows) {
            String key = this.keySupplier.apply(row);
            if (sel.isEmpty()) {
                return;
            }
            for (Tagged tagged : sel) {
                Collection<String> s = this.getString(tagged, key);
                if (s == null) continue;
                values.addAll(s);
            }
        }
        if (!values.isEmpty()) {
            ClipboardUtils.copyString(Utils.join("\n", values));
        }
    }
}

