/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.data.preferences.ListProperty;

class RecentTagCollection {
    private final Map<Tag, Void> recentTags;
    private SearchCompiler.Match tagsToIgnore;

    RecentTagCollection(int capacity) {
        this.recentTags = new LruCache(capacity);
        this.tagsToIgnore = SearchCompiler.Never.INSTANCE;
    }

    public void loadFromPreference(ListProperty property) {
        this.recentTags.clear();
        Iterator it = property.get().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)it.next();
            this.add(new Tag(key, value));
        }
    }

    public void saveToPreference(ListProperty property) {
        ArrayList<String> c = new ArrayList<String>(this.recentTags.size() * 2);
        for (Tag t : this.recentTags.keySet()) {
            c.add(t.getKey());
            c.add(t.getValue());
        }
        property.put((List<String>)c);
    }

    public void add(Tag tag) {
        if (!this.tagsToIgnore.match(tag)) {
            this.recentTags.put(tag, null);
        }
    }

    public boolean isEmpty() {
        return this.recentTags.isEmpty();
    }

    public List<Tag> toList() {
        return new ArrayList<Tag>(this.recentTags.keySet());
    }

    public void setTagsToIgnore(SearchCompiler.Match tagsToIgnore) {
        this.tagsToIgnore = tagsToIgnore;
        this.recentTags.keySet().removeIf(tagsToIgnore::match);
    }

    public void setTagsToIgnore(SearchSetting tagsToIgnore) throws SearchParseError {
        this.setTagsToIgnore(tagsToIgnore.text.isEmpty() ? SearchCompiler.Never.INSTANCE : SearchCompiler.compile(tagsToIgnore));
    }

    public SearchSetting ignoreTag(Tag tagToIgnore, SearchSetting settingToUpdate) throws SearchParseError {
        String forTag = SearchCompiler.buildSearchStringForTag(tagToIgnore.getKey(), tagToIgnore.getValue());
        settingToUpdate.text = settingToUpdate.text.isEmpty() ? forTag : settingToUpdate.text + " OR " + forTag;
        this.setTagsToIgnore(settingToUpdate);
        return settingToUpdate;
    }

    static final class LruCache
    extends LinkedHashMap<Tag, Void> {
        private static final long serialVersionUID = 1L;
        private final int capacity;

        LruCache(int capacity) {
            super(capacity + 1, 1.1f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Tag, Void> eldest) {
            return this.size() > this.capacity;
        }
    }
}

