/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DownloadIncompleteMembersAction
extends AbstractRelationEditorAction {
    public DownloadIncompleteMembersAction(MemberTable memberTable, MemberTableModel memberTableModel, String actionMapKey, OsmDataLayer layer, IRelationEditor editor) {
        super(memberTable, memberTableModel, actionMapKey, layer, editor);
        Shortcut sc = Shortcut.registerShortcut("relationeditor:downloadincomplete", I18n.tr("Relation Editor: Download Members", new Object[0]), 36, 5004);
        sc.setAccelerator(this);
        this.putValue("ShortDescription", Main.platform.makeTooltip(I18n.tr("Download all incomplete members", new Object[0]), sc));
        new ImageProvider("dialogs/relation", "downloadincomplete").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Download members", new Object[0]));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        MainApplication.worker.submit(new DownloadRelationMemberTask(this.editor.getRelation(), this.memberTableModel.getIncompleteMemberPrimitives(), this.layer, (Dialog)((Object)this.editor)));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.memberTableModel.hasIncompleteMembers() && this.canDownload());
    }
}

