/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.collections;

import info.monitorenter.util.collections.IComparableProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSetGreedy<T extends IComparableProperty>
extends TreeSet<T>
implements Set<T> {
    private NumberPropertyComparator<T> m_comparator = (NumberPropertyComparator)this.comparator();

    public TreeSetGreedy() {
        super(new NumberPropertyComparator());
    }

    @Override
    public synchronized boolean add(T o) {
        boolean ret = this.addInternal(o);
        this.packComparableProperties();
        return ret;
    }

    private boolean addInternal(T o) {
        boolean ret = super.add(o);
        boolean success = false;
        Object resort = this.m_comparator.m_resort;
        this.m_comparator.m_resort = null;
        if (resort != null) {
            success = this.remove(resort);
            if (!success) {
                System.err.println("Could not remove: " + resort);
            }
            this.addInternal(resort);
        }
        return ret;
    }

    private void packComparableProperties() {
        int i = 0;
        for (IComparableProperty prop : this) {
            prop.setComparableProperty(new Integer(i));
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NumberPropertyComparator<T extends IComparableProperty>
    implements Comparator<T>,
    Serializable {
        protected T m_resort = null;

        @Override
        public int compare(T o1, T o2) throws ClassCastException {
            int result;
            if (o1 == o2) {
                result = 0;
            } else {
                double i2;
                double i1 = o1.getComparableProperty().doubleValue();
                if (i1 < (i2 = o2.getComparableProperty().doubleValue())) {
                    result = -1;
                } else if (i1 == i2) {
                    o2.setComparableProperty(this.createIncreasedNumber(o2.getComparableProperty()));
                    this.m_resort = o2;
                    result = 1;
                } else {
                    result = 1;
                }
            }
            return result;
        }

        private Number createIncreasedNumber(Number number) {
            Number number2;
            Class<?> clazz = number.getClass();
            if (clazz == Integer.class) {
                number2 = new Integer(number.intValue() - 1);
            } else if (clazz == Double.class) {
                number2 = new Double(number.doubleValue() + 1.0);
            } else if (clazz == Float.class) {
                number2 = new Float(number.floatValue() + 1.0f);
            } else if (clazz == Short.class) {
                number2 = new Short((short)(number.shortValue() + 1));
            } else if (clazz == Byte.class) {
                number2 = new Byte((byte)(number.byteValue() + 1));
            } else if (clazz == Long.class) {
                number2 = new Long(number.longValue() + 1L);
            } else if (clazz == BigDecimal.class) {
                BigDecimal bigDecimal = new BigDecimal(number.toString());
                bigDecimal = bigDecimal.add(new BigDecimal(1));
                number2 = bigDecimal;
            } else {
                BigInteger bigInteger = new BigInteger(number.toString());
                bigInteger = bigInteger.add(new BigInteger("1"));
                number2 = bigInteger;
            }
            return number2;
        }
    }
}

