/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.sink;

import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.sink.OutputEventRenderer;

public class OutputEventListenerManager {
    private final OutputEventRenderer renderer;
    private OutputEventListener other;
    private final OutputEventListener broadcaster = new OutputEventListener(){

        public void onOutput(OutputEvent event) {
            OutputEventListenerManager.this.renderer.onOutput(event);
            OutputEventListener otherRef = OutputEventListenerManager.this.other;
            if (otherRef != null) {
                otherRef.onOutput(event);
            }
        }
    };

    public OutputEventListenerManager(OutputEventRenderer renderer) {
        this.renderer = renderer;
    }

    public void setListener(OutputEventListener listener) {
        this.other = listener;
    }

    public void removeListener(OutputEventListener listener) {
        if (this.other == listener) {
            this.other = null;
        }
    }

    public OutputEventListener getBroadcaster() {
        return this.broadcaster;
    }
}

