/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.DefaultPendingSource;
import org.gradle.api.internal.collections.ElementSource;
import org.gradle.api.internal.collections.PendingSource;
import org.gradle.api.internal.provider.ProviderInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IterationOrderRetainingSetElementSource<T>
implements ElementSource<T> {
    private final Set<T> values = new LinkedHashSet<T>();
    private final PendingSource<T> pending = new DefaultPendingSource();

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public boolean constantTimeIsEmpty() {
        return this.values.isEmpty() && this.pending.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size() + this.pending.size();
    }

    @Override
    public int estimatedSize() {
        return this.values.size() + this.pending.size();
    }

    @Override
    public Iterator<T> iterator() {
        this.pending.realizePending();
        return this.values.iterator();
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return this.values.iterator();
    }

    @Override
    public boolean contains(Object element) {
        this.pending.realizePending();
        return this.values.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        this.pending.realizePending();
        return this.values.containsAll(elements);
    }

    @Override
    public boolean add(T element) {
        return this.values.add(element);
    }

    @Override
    public boolean remove(Object o) {
        return this.values.remove(o);
    }

    @Override
    public void clear() {
        this.pending.clear();
        this.values.clear();
    }

    @Override
    public void realizePending() {
        this.pending.realizePending();
    }

    @Override
    public void realizePending(Class<?> type) {
        this.pending.realizePending(type);
    }

    @Override
    public void addPending(ProviderInternal<? extends T> provider) {
        this.pending.addPending(provider);
    }

    @Override
    public void removePending(ProviderInternal<? extends T> provider) {
        this.pending.removePending(provider);
    }

    @Override
    public void onRealize(Action<ProviderInternal<? extends T>> action) {
        this.pending.onRealize(action);
    }
}

