/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

public class DuplicateWay
extends Test {
    protected static final int DUPLICATE_WAY = 1401;
    protected static final int SAME_WAY = 1402;
    private MultiMap<WayPair, OsmPrimitive> ways;
    private MultiMap<WayPairNoTags, OsmPrimitive> waysNoTags;
    private Set<Integer> knownHashCodes;

    public DuplicateWay() {
        super(I18n.tr("Duplicated ways", new Object[0]), I18n.tr("This test checks that there are no ways with same node coordinates and optionally also same tags.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor monitor) {
        super.startTest(monitor);
        this.ways = new MultiMap(1000);
        this.waysNoTags = new MultiMap(1000);
        this.knownHashCodes = new HashSet<Integer>(1000);
    }

    @Override
    public void endTest() {
        super.endTest();
        for (Set<OsmPrimitive> duplicated : this.ways.values()) {
            if (duplicated.size() <= 1) continue;
            TestError testError = TestError.builder(this, Severity.ERROR, 1401).message(I18n.tr("Duplicated ways", new Object[0])).primitives(duplicated).build();
            this.errors.add(testError);
        }
        for (Set<OsmPrimitive> sameway : this.waysNoTags.values()) {
            if (sameway.size() <= 1) continue;
            TagMap tags0 = null;
            boolean skip = true;
            for (OsmPrimitive o : sameway) {
                if (tags0 == null) {
                    tags0 = o.getKeys();
                    this.removeUninterestingKeys(tags0);
                    continue;
                }
                TagMap tagsCmp = o.getKeys();
                this.removeUninterestingKeys(tagsCmp);
                if (tagsCmp.equals(tags0)) continue;
                skip = false;
                break;
            }
            if (skip) continue;
            TestError testError = TestError.builder(this, Severity.WARNING, 1402).message(I18n.tr("Ways with same position", new Object[0])).primitives(sameway).build();
            this.errors.add(testError);
        }
        this.ways = null;
        this.waysNoTags = null;
        this.knownHashCodes = null;
    }

    public void removeUninterestingKeys(Map<String, String> wkeys) {
        for (String key : AbstractPrimitive.getDiscardableKeys()) {
            wkeys.remove(key);
        }
    }

    @Override
    public void visit(Way w) {
        int hash;
        if (!w.isUsable()) {
            return;
        }
        List<LatLon> wLat = DuplicateWay.getOrderedNodes(w);
        if (!w.hasDirectionKeys() && !this.knownHashCodes.contains(hash = wLat.hashCode())) {
            ArrayList<LatLon> reversedwLat = new ArrayList<LatLon>(wLat);
            Collections.reverse(reversedwLat);
            int reverseHash = reversedwLat.hashCode();
            if (!this.knownHashCodes.contains(reverseHash)) {
                this.knownHashCodes.add(hash);
            } else {
                wLat = reversedwLat;
            }
        }
        TagMap wkeys = w.getKeys();
        this.removeUninterestingKeys(wkeys);
        WayPair wKey = new WayPair(wLat, wkeys);
        this.ways.put(wKey, w);
        WayPairNoTags wKeyN = new WayPairNoTags(wLat);
        this.waysNoTags.put(wKeyN, w);
    }

    public static List<LatLon> getOrderedNodes(Way w) {
        List<Node> wNodes = w.getNodes();
        ArrayList<Node> wNodesToUse = new ArrayList<Node>(wNodes.size());
        if (w.isClosed()) {
            int i;
            int lowestIndex = 0;
            long lowestNodeId = wNodes.get(0).getUniqueId();
            for (i = 1; i < wNodes.size(); ++i) {
                if (wNodes.get(i).getUniqueId() >= lowestNodeId) continue;
                lowestNodeId = wNodes.get(i).getUniqueId();
                lowestIndex = i;
            }
            for (i = lowestIndex; i < wNodes.size() - 1; ++i) {
                wNodesToUse.add(wNodes.get(i));
            }
            for (i = 0; i < lowestIndex; ++i) {
                wNodesToUse.add(wNodes.get(i));
            }
            wNodesToUse.add(wNodes.get(lowestIndex));
        } else {
            wNodesToUse.addAll(wNodes);
        }
        ArrayList<LatLon> wLat = new ArrayList<LatLon>(wNodesToUse.size());
        for (Node node : wNodesToUse) {
            wLat.add(node.getCoor());
        }
        return wLat;
    }

    @Override
    public Command fixError(TestError testError) {
        Collection<? extends OsmPrimitive> sel = testError.getPrimitives();
        HashSet<Way> wayz = new HashSet<Way>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Way) || osmPrimitive.isDeleted()) continue;
            wayz.add((Way)osmPrimitive);
        }
        if (wayz.size() < 2) {
            return null;
        }
        long idToKeep = 0L;
        Way wayToKeep = (Way)wayz.iterator().next();
        Way wayWithRelations = null;
        List<Relation> relations = null;
        for (Way w : wayz) {
            List<Relation> list = OsmPrimitive.getFilteredList(w.getReferrers(), Relation.class);
            if (!list.isEmpty()) {
                if (wayWithRelations != null) {
                    throw new AssertionError((Object)"Cannot fix duplicate Ways: More than one way is relation member.");
                }
                wayWithRelations = w;
                relations = list;
            }
            if (w.isNew() || idToKeep != 0L && w.getId() >= idToKeep) continue;
            idToKeep = w.getId();
            wayToKeep = w;
        }
        LinkedList<Command> commands = new LinkedList<Command>();
        if (wayWithRelations != null && relations != null && wayToKeep != wayWithRelations) {
            for (Relation relation : relations) {
                Relation newRel = new Relation(relation);
                for (int i = 0; i < newRel.getMembers().size(); ++i) {
                    RelationMember m = newRel.getMember(i);
                    if (!wayWithRelations.equals(m.getMember())) continue;
                    newRel.setMember(i, new RelationMember(m.getRole(), wayToKeep));
                }
                commands.add(new ChangeCommand(relation, newRel));
            }
        }
        wayz.remove(wayToKeep);
        commands.add(new DeleteCommand(wayz));
        return new SequenceCommand(I18n.tr("Delete duplicate ways", new Object[0]), commands);
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateWay)) {
            return false;
        }
        if (testError.getCode() != 1401) {
            return false;
        }
        Collection<? extends OsmPrimitive> sel = testError.getPrimitives();
        HashSet<Way> wayz = new HashSet<Way>();
        for (OsmPrimitive osmPrimitive : sel) {
            if (!(osmPrimitive instanceof Way)) continue;
            wayz.add((Way)osmPrimitive);
        }
        if (wayz.size() < 2) {
            return false;
        }
        int waysWithRelations = 0;
        for (Way w : wayz) {
            List<Relation> rel = OsmPrimitive.getFilteredList(w.getReferrers(), Relation.class);
            if (rel.isEmpty()) continue;
            ++waysWithRelations;
        }
        return waysWithRelations <= 1;
    }

    private static class WayPairNoTags {
        private final List<LatLon> coor;

        WayPairNoTags(List<LatLon> coor) {
            this.coor = coor;
        }

        public int hashCode() {
            return Objects.hash(this.coor);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WayPairNoTags that = (WayPairNoTags)obj;
            return Objects.equals(this.coor, that.coor);
        }
    }

    private static class WayPair {
        private final List<LatLon> coor;
        private final Map<String, String> keys;

        WayPair(List<LatLon> coor, Map<String, String> keys) {
            this.coor = coor;
            this.keys = keys;
        }

        public int hashCode() {
            return Objects.hash(this.coor, this.keys);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WayPair wayPair = (WayPair)obj;
            return Objects.equals(this.coor, wayPair.coor) && Objects.equals(this.keys, wayPair.keys);
        }
    }
}

