/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.ShiftedProjecting;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.layer.imagery.TileAnchor;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;

public class TileCoordinateConverter {
    private final MapView mapView;
    private final TileSourceDisplaySettings settings;
    private final TileSource tileSource;

    public TileCoordinateConverter(MapView mapView, TileSource tileSource, TileSourceDisplaySettings settings) {
        this.mapView = Objects.requireNonNull(mapView, "mapView");
        this.tileSource = Objects.requireNonNull(tileSource, "tileSource");
        this.settings = Objects.requireNonNull(settings, "settings");
    }

    private MapViewState.MapViewPoint pos(ICoordinate ll) {
        return this.mapView.getState().getPointFor(CoordinateConversion.coorToLL(ll)).add(this.settings.getDisplacement());
    }

    private MapViewState.MapViewPoint pos(IProjected p) {
        return this.mapView.getState().getPointFor(CoordinateConversion.projToEn(p)).add(this.settings.getDisplacement());
    }

    public IProjected shiftDisplayToServer(EastNorth en) {
        return CoordinateConversion.enToProj(en.subtract(this.settings.getDisplacement()));
    }

    public Projecting getProjecting() {
        return new ShiftedProjecting(this.mapView.getProjection(), this.settings.getDisplacement());
    }

    public Point2D getPixelForTile(int x, int y, int zoom) {
        ICoordinate coord = this.tileSource.tileXYToLatLon(x, y, zoom);
        return this.pos(coord).getInView();
    }

    public Point2D getPixelForTile(Tile tile) {
        return this.getPixelForTile(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    public TileXY getTileforPixel(int sx, int sy, int zoom) {
        if (this.requiresReprojection()) {
            LatLon ll = this.getProjecting().eastNorth2latlonClamped(this.mapView.getEastNorth(sx, sy));
            return this.tileSource.latLonToTileXY(CoordinateConversion.llToCoor(ll), zoom);
        }
        IProjected p = this.shiftDisplayToServer(this.mapView.getEastNorth(sx, sy));
        return this.tileSource.projectedToTileXY(p, zoom);
    }

    public Rectangle2D getRectangleForTile(Tile tile) {
        ICoordinate c1 = tile.getTileSource().tileXYToLatLon(tile);
        ICoordinate c2 = tile.getTileSource().tileXYToLatLon(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return this.pos(c1).rectTo(this.pos(c2)).getInView();
    }

    public Shape getTileShapeScreen(Tile tile) {
        if (this.requiresReprojection()) {
            Point2D p00 = this.getPixelForTile(tile.getXtile(), tile.getYtile(), tile.getZoom());
            Point2D p10 = this.getPixelForTile(tile.getXtile() + 1, tile.getYtile(), tile.getZoom());
            Point2D p11 = this.getPixelForTile(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
            Point2D p01 = this.getPixelForTile(tile.getXtile(), tile.getYtile() + 1, tile.getZoom());
            return new Polygon(new int[]{(int)Math.round(p00.getX()), (int)Math.round(p01.getX()), (int)Math.round(p11.getX()), (int)Math.round(p10.getX())}, new int[]{(int)Math.round(p00.getY()), (int)Math.round(p01.getY()), (int)Math.round(p11.getY()), (int)Math.round(p10.getY())}, 4);
        }
        Point2D p00 = this.getPixelForTile(tile.getXtile(), tile.getYtile(), tile.getZoom());
        Point2D p11 = this.getPixelForTile(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return new Rectangle((int)Math.round(p00.getX()), (int)Math.round(p00.getY()), (int)Math.round(p11.getX()) - (int)Math.round(p00.getX()), (int)Math.round(p11.getY()) - (int)Math.round(p00.getY()));
    }

    public double getScaleFactor(int zoom) {
        TileXY t2;
        TileXY t1;
        if (this.requiresReprojection()) {
            LatLon topLeft = this.mapView.getLatLon(0, 0);
            LatLon botRight = this.mapView.getLatLon(this.mapView.getWidth(), this.mapView.getHeight());
            t1 = this.tileSource.latLonToTileXY(CoordinateConversion.llToCoor(topLeft), zoom);
            t2 = this.tileSource.latLonToTileXY(CoordinateConversion.llToCoor(botRight), zoom);
        } else {
            EastNorth topLeftEN = this.mapView.getEastNorth(0, 0);
            EastNorth botRightEN = this.mapView.getEastNorth(this.mapView.getWidth(), this.mapView.getHeight());
            t1 = this.tileSource.projectedToTileXY(CoordinateConversion.enToProj(topLeftEN), zoom);
            t2 = this.tileSource.projectedToTileXY(CoordinateConversion.enToProj(botRightEN), zoom);
        }
        int screenPixels = this.mapView.getWidth() * this.mapView.getHeight();
        double tilePixels = Math.abs((t2.getY() - t1.getY()) * (t2.getX() - t1.getX()) * (double)this.tileSource.getTileSize() * (double)this.tileSource.getTileSize());
        if (screenPixels == 0 || tilePixels == 0.0) {
            return 1.0;
        }
        return (double)screenPixels / tilePixels;
    }

    public TileAnchor getScreenAnchorForTile(Tile tile) {
        if (this.requiresReprojection()) {
            ICoordinate c1 = tile.getTileSource().tileXYToLatLon(tile);
            ICoordinate c2 = tile.getTileSource().tileXYToLatLon(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
            return new TileAnchor(this.pos(c1).getInView(), this.pos(c2).getInView());
        }
        IProjected p1 = this.tileSource.tileXYtoProjected(tile.getXtile(), tile.getYtile(), tile.getZoom());
        IProjected p2 = this.tileSource.tileXYtoProjected(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        return new TileAnchor(this.pos(p1).getInView(), this.pos(p2).getInView());
    }

    public boolean requiresReprojection() {
        return !Objects.equals(this.tileSource.getServerCRS(), Main.getProjection().toCode());
    }
}

