/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.CommunicatorDescriptor;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGrid.ServiceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Adapter;
import com.zeroc.IceGridGUI.Application.Communicator;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.PlainService;
import com.zeroc.IceGridGUI.Application.ServiceTemplateEditor;
import com.zeroc.IceGridGUI.Application.ServiceTemplates;
import com.zeroc.IceGridGUI.Application.TemplateInstance;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServiceTemplate
extends Communicator {
    private TemplateDescriptor _templateDescriptor;
    private final boolean _ephemeral;
    private Editable _editable;
    private ServiceTemplateEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;

    public static TemplateDescriptor copyDescriptor(TemplateDescriptor templateDescriptor) {
        TemplateDescriptor copy = templateDescriptor.clone();
        copy.descriptor = PlainService.copyDescriptor((ServiceDescriptor)copy.descriptor);
        return copy;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setOpenIcon(Utils.getIcon("/icons/16x16/service_template.png"));
            _cellRenderer.setClosedIcon(Utils.getIcon("/icons/16x16/service_template.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public boolean[] getAvailableActions() {
        Object clipboard;
        boolean[] actions = new boolean[20];
        actions[14] = ((TreeNode)this._parent).getAvailableActions()[14] ? true : (clipboard = this.getCoordinator().getClipboard()) != null && (clipboard instanceof Adapter.AdapterCopy || clipboard instanceof DbEnvDescriptor);
        actions[15] = true;
        if (!this._ephemeral) {
            actions[13] = true;
            actions[0] = true;
            actions[1] = true;
        }
        return actions;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(ServiceTemplate.copyDescriptor(this._templateDescriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(0));
            _popup.add(actions.get(1));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServiceTemplateEditor)this.getRoot().getEditor(ServiceTemplateEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new ServiceTemplateEditor();
    }

    ServiceTemplate(boolean brandNew, ServiceTemplates parent, String name, TemplateDescriptor descriptor) throws UpdateFailedException {
        super(parent, name);
        this._editable = new Editable(brandNew);
        this._ephemeral = false;
        this.rebuild(descriptor);
    }

    ServiceTemplate(ServiceTemplates parent, String name, TemplateDescriptor descriptor) {
        super(parent, name);
        this._ephemeral = true;
        this._editable = null;
        this._templateDescriptor = descriptor;
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(ServiceTemplate.createAttribute("id", this._id));
            writer.writeStartTag("service-template", attributes);
            ServiceTemplate.writeParameters(writer, this._templateDescriptor.parameters, this._templateDescriptor.parameterDefaults);
            ServiceDescriptor descriptor = (ServiceDescriptor)this._templateDescriptor.descriptor;
            writer.writeStartTag("service", PlainService.createAttributes(descriptor));
            if (descriptor.description.length() > 0) {
                writer.writeElement("description", descriptor.description);
            }
            ServiceTemplate.writePropertySet(writer, descriptor.propertySet, descriptor.adapters, descriptor.logs);
            ServiceTemplate.writeLogs(writer, descriptor.logs, descriptor.propertySet.properties);
            this._adapters.write(writer, descriptor.propertySet.properties);
            this._dbEnvs.write(writer);
            writer.writeEndTag("service");
            writer.writeEndTag("service-template");
        }
    }

    void rebuild(TemplateDescriptor descriptor) throws UpdateFailedException {
        this._templateDescriptor = descriptor;
        this._adapters.clear();
        this._dbEnvs.clear();
        if (!this._ephemeral) {
            this._adapters.init(this._templateDescriptor.descriptor.adapters);
            this._dbEnvs.init(this._templateDescriptor.descriptor.dbEnvs);
        }
    }

    void commit() {
        this._editable.commit();
    }

    @Override
    public Object getDescriptor() {
        return this._templateDescriptor;
    }

    @Override
    CommunicatorDescriptor getCommunicatorDescriptor() {
        return this._templateDescriptor.descriptor;
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }

    @Override
    public void destroy() {
        ServiceTemplates serviceTemplates = (ServiceTemplates)this._parent;
        if (this._ephemeral) {
            serviceTemplates.removeChild(this);
        } else {
            serviceTemplates.removeDescriptor(this._id);
            this.getRoot().removeServiceInstances(this._id);
            serviceTemplates.removeChild(this);
            serviceTemplates.getEditable().removeElement(this._id, this._editable, ServiceTemplate.class);
            this.getRoot().updated();
        }
    }

    @Override
    List<? extends TemplateInstance> findInstances() {
        return this.getRoot().findServiceInstances(this._id);
    }

    Editable getEditable() {
        return this._editable;
    }

    @Override
    Editable getEnclosingEditable() {
        return this._editable;
    }

    @Override
    public Object saveDescriptor() {
        TemplateDescriptor clone = this._templateDescriptor.clone();
        clone.descriptor = (ServiceDescriptor)this._templateDescriptor.descriptor.clone();
        return clone;
    }

    @Override
    public void restoreDescriptor(Object savedDescriptor) {
        TemplateDescriptor clone = (TemplateDescriptor)savedDescriptor;
        this._templateDescriptor.parameters = clone.parameters;
        ServiceDescriptor sd = (ServiceDescriptor)this._templateDescriptor.descriptor;
        ServiceDescriptor csd = (ServiceDescriptor)clone.descriptor;
        sd.propertySet = csd.propertySet;
        sd.description = csd.description;
        sd.name = csd.name;
        sd.entry = csd.entry;
    }
}

