// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `IceStorm.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceStorm;

/**
 * A topic manager manages topics, and subscribers to topics.
 *
 * @see Topic
 *
 **/
public interface TopicManagerPrx extends Ice.ObjectPrx
{
    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @return A proxy to the topic instance.
     *
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     *
     **/
    public TopicPrx create(String name)
        throws TopicExists;

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     *
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     *
     **/
    public TopicPrx create(String name, java.util.Map<String, String> context)
        throws TopicExists;

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> context);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, Ice.Callback cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, Callback_TopicManager_create cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name, java.util.Map<String, String> context, Callback_TopicManager_create cb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name,
                                        IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name,
                                        IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name,
                                        java.util.Map<String, String> context,
                                        IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_create(String name,
                                        java.util.Map<String, String> context,
                                        IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                        IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Create a new topic. The topic name must be unique, otherwise
     * {@link TopicExists} is raised.
     *
     * @param result The asynchronous result object.
     * @return A proxy to the topic instance.
     *
     * @throws TopicExists Raised if a topic with the same name already
     * exists.
     *
     **/
    public TopicPrx end_create(Ice.AsyncResult result)
        throws TopicExists;

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @return A proxy to the topic instance.
     *
     * @throws NoSuchTopic Raised if the topic does not exist.
     *
     **/
    public TopicPrx retrieve(String name)
        throws NoSuchTopic;

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy to the topic instance.
     *
     * @throws NoSuchTopic Raised if the topic does not exist.
     *
     **/
    public TopicPrx retrieve(String name, java.util.Map<String, String> context)
        throws NoSuchTopic;

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> context);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, Ice.Callback cb);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, Callback_TopicManager_retrieve cb);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name, java.util.Map<String, String> context, Callback_TopicManager_retrieve cb);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name,
                                          IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name,
                                          IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name,
                                          java.util.Map<String, String> context,
                                          IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve a topic by name.
     *
     * @param name The name of the topic.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieve(String name,
                                          java.util.Map<String, String> context,
                                          IceInternal.Functional_GenericCallback1<TopicPrx> responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve a topic by name.
     *
     * @param result The asynchronous result object.
     * @return A proxy to the topic instance.
     *
     * @throws NoSuchTopic Raised if the topic does not exist.
     *
     **/
    public TopicPrx end_retrieve(Ice.AsyncResult result)
        throws NoSuchTopic;

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @return A dictionary of string, topic proxy pairs.
     *
     **/
    public java.util.Map<java.lang.String, TopicPrx> retrieveAll();

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param context The Context map to send with the invocation.
     * @return A dictionary of string, topic proxy pairs.
     *
     **/
    public java.util.Map<java.lang.String, TopicPrx> retrieveAll(java.util.Map<String, String> context);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll();

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> context);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(Ice.Callback cb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(Callback_TopicManager_retrieveAll cb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> context, Callback_TopicManager_retrieveAll cb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, TopicPrx>> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, TopicPrx>> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, TopicPrx>> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_retrieveAll(java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, TopicPrx>> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Retrieve all topics managed by this topic manager.
     *
     * @param result The asynchronous result object.
     * @return A dictionary of string, topic proxy pairs.
     *
     **/
    public java.util.Map<java.lang.String, TopicPrx> end_retrieveAll(Ice.AsyncResult result);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums();

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> context);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums();

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_TopicManager_getSliceChecksums cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context, Callback_TopicManager_getSliceChecksums cb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns the checksums for the IceStorm Slice definitions.
     *
     * @param result The asynchronous result object.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult result);
}
